/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.util;

import javax.annotation.Nonnull;
import net.minecraftforge.common.util.NonNullSupplier;

public interface NonNullLazy<T>
extends NonNullSupplier<T> {
    public static <T> NonNullLazy<T> of(@Nonnull NonNullSupplier<T> supplier) {
        return new Fast(supplier);
    }

    public static <T> NonNullLazy<T> concurrentOf(@Nonnull NonNullSupplier<T> supplier) {
        return new Concurrent(supplier);
    }

    public static final class Concurrent<T>
    implements NonNullLazy<T> {
        private static final Object lock = new Object();
        private volatile NonNullSupplier<T> supplier;
        private volatile T instance;

        private Concurrent(NonNullSupplier<T> supplier) {
            this.supplier = supplier;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nonnull
        public final T get() {
            if (this.supplier != null) {
                Object object = lock;
                synchronized (object) {
                    if (this.supplier != null) {
                        this.instance = this.supplier.get();
                        this.supplier = null;
                    }
                }
            }
            return this.instance;
        }
    }

    public static final class Fast<T>
    implements NonNullLazy<T> {
        private NonNullSupplier<T> supplier;
        private T instance;

        private Fast(NonNullSupplier<T> supplier) {
            this.supplier = supplier;
        }

        @Override
        @Nonnull
        public final T get() {
            if (this.supplier != null) {
                this.instance = this.supplier.get();
                this.supplier = null;
            }
            return this.instance;
        }
    }
}

