/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.server.permission.context;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraftforge.server.permission.context.ContextKey;
import net.minecraftforge.server.permission.context.ContextKeys;
import net.minecraftforge.server.permission.context.PlayerContext;

public class BlockPosContext
extends PlayerContext {
    private final BlockPos blockPos;
    private BlockState blockState;
    private Direction facing;

    public BlockPosContext(PlayerEntity ep, BlockPos pos, @Nullable BlockState state, @Nullable Direction f) {
        super(ep);
        this.blockPos = (BlockPos)Preconditions.checkNotNull((Object)pos, (Object)"BlockPos can't be null in BlockPosContext!");
        this.blockState = state;
        this.facing = f;
    }

    public BlockPosContext(PlayerEntity ep, ChunkPos pos) {
        this(ep, new BlockPos(pos.func_180334_c() + 8, 0, pos.func_180333_d() + 8), null, null);
    }

    @Override
    @Nullable
    public <T> T get(ContextKey<T> key) {
        if (key.equals(ContextKeys.POS)) {
            return (T)this.blockPos;
        }
        if (key.equals(ContextKeys.BLOCK_STATE)) {
            if (this.blockState == null) {
                this.blockState = this.getWorld().func_180495_p(this.blockPos);
            }
            return (T)this.blockState;
        }
        if (key.equals(ContextKeys.FACING)) {
            return (T)this.facing;
        }
        return super.get(key);
    }

    @Override
    protected boolean covers(ContextKey<?> key) {
        return key.equals(ContextKeys.POS) || key.equals(ContextKeys.BLOCK_STATE) || this.facing != null && key.equals(ContextKeys.FACING);
    }
}

