/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.TransformationMatrix;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.Material;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.Direction;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelTransformComposition;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class MultiLayerModel
implements IModelGeometry<MultiLayerModel> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ImmutableMap<RenderType, IUnbakedModel> models;

    public MultiLayerModel(ImmutableMap<RenderType, IUnbakedModel> models) {
        this.models = models;
    }

    @Override
    public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        HashSet materials = Sets.newHashSet();
        materials.add(owner.resolveTexture("particle"));
        for (IUnbakedModel m : this.models.values()) {
            materials.addAll(m.func_225614_a_(modelGetter, missingTextureErrors));
        }
        return materials;
    }

    private static ImmutableMap<RenderType, IBakedModel> buildModels(ImmutableMap<RenderType, IUnbakedModel> models, IModelTransform modelTransform, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ResourceLocation modelLocation) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : models.entrySet()) {
            builder.put(entry.getKey(), (Object)((IUnbakedModel)entry.getValue()).func_225613_a_(bakery, spriteGetter, modelTransform, modelLocation));
        }
        return builder.build();
    }

    @Override
    public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList overrides, ResourceLocation modelLocation) {
        IUnbakedModel missing = ModelLoader.instance().getMissingModel();
        return new MultiLayerBakedModel(owner.useSmoothLighting(), owner.isShadedInGui(), owner.isSideLit(), spriteGetter.apply(owner.resolveTexture("particle")), overrides, MultiLayerModel.buildModels(this.models, modelTransform, bakery, spriteGetter, modelLocation), missing.func_225613_a_(bakery, spriteGetter, modelTransform, modelLocation), PerspectiveMapWrapper.getTransforms(new ModelTransformComposition(owner.getCombinedTransform(), modelTransform)));
    }

    public static final class Loader
    implements IModelLoader<MultiLayerModel> {
        public static final Loader INSTANCE = new Loader();

        private Loader() {
        }

        @Override
        public void func_195410_a(IResourceManager resourceManager) {
        }

        @Override
        public MultiLayerModel read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            JsonObject layersObject = JSONUtils.func_152754_s((JsonObject)modelContents, (String)"layers");
            for (RenderType layer : RenderType.func_228661_n_()) {
                String layerName = layer.toString();
                if (!layersObject.has(layerName)) continue;
                builder.put((Object)layer, deserializationContext.deserialize((JsonElement)JSONUtils.func_152754_s((JsonObject)layersObject, (String)layerName), BlockModel.class));
            }
            ImmutableMap models = builder.build();
            return new MultiLayerModel((ImmutableMap<RenderType, IUnbakedModel>)models);
        }
    }

    private static final class MultiLayerBakedModel
    implements IBakedModel {
        private final ImmutableMap<RenderType, IBakedModel> models;
        private final ImmutableMap<ItemCameraTransforms.TransformType, TransformationMatrix> cameraTransforms;
        protected final boolean ambientOcclusion;
        protected final boolean gui3d;
        protected final boolean isSideLit;
        protected final TextureAtlasSprite particle;
        protected final ItemOverrideList overrides;
        private final IBakedModel missing;

        public MultiLayerBakedModel(boolean ambientOcclusion, boolean isGui3d, boolean isSideLit, TextureAtlasSprite particle, ItemOverrideList overrides, ImmutableMap<RenderType, IBakedModel> models, IBakedModel missing, ImmutableMap<ItemCameraTransforms.TransformType, TransformationMatrix> cameraTransforms) {
            this.isSideLit = isSideLit;
            this.models = models;
            this.cameraTransforms = cameraTransforms;
            this.missing = missing;
            this.ambientOcclusion = ambientOcclusion;
            this.gui3d = isGui3d;
            this.particle = particle;
            this.overrides = overrides;
        }

        public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction side, Random rand) {
            return this.getQuads(state, side, rand, EmptyModelData.INSTANCE);
        }

        @Nonnull
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
            RenderType layer = MinecraftForgeClient.getRenderLayer();
            if (layer == null) {
                ImmutableList.Builder builder = ImmutableList.builder();
                for (IBakedModel model : this.models.values()) {
                    builder.addAll((Iterable)model.func_200117_a(state, side, rand));
                }
                return builder.build();
            }
            return ((IBakedModel)this.models.getOrDefault((Object)layer, (Object)this.missing)).getQuads(state, side, rand, extraData);
        }

        public boolean func_177555_b() {
            return this.ambientOcclusion;
        }

        public boolean isAmbientOcclusion(BlockState state) {
            return this.ambientOcclusion;
        }

        public boolean func_177556_c() {
            return this.gui3d;
        }

        public boolean func_230044_c_() {
            return this.isSideLit;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return this.particle;
        }

        public boolean doesHandlePerspectives() {
            return true;
        }

        public IBakedModel handlePerspective(ItemCameraTransforms.TransformType cameraTransformType, MatrixStack mat) {
            return PerspectiveMapWrapper.handlePerspective((IBakedModel)this, this.cameraTransforms, cameraTransformType, mat);
        }

        public ItemOverrideList func_188617_f() {
            return ItemOverrideList.field_188022_a;
        }
    }
}

