/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml;

import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import net.minecraftforge.fml.Logging;
import net.minecraftforge.fml.MavenVersionStringHelper;
import net.minecraftforge.fml.loading.StringUtils;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import org.apache.commons.lang3.text.ExtendedMessageFormat;
import org.apache.commons.lang3.text.FormatFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ForgeI18n {
    private static final Logger LOGGER = LogManager.getLogger();
    private static Map<String, String> i18n;
    private static Map<String, FormatFactory> customFactories;

    private static void parseException(String formatString, StringBuffer stringBuffer, Object objectToParse) {
        Throwable t = (Throwable)objectToParse;
        if (Objects.equals(formatString, "msg")) {
            stringBuffer.append(t.getMessage());
        } else if (Objects.equals(formatString, "cls")) {
            stringBuffer.append(t.getClass());
        }
    }

    private static void parseModInfo(String formatString, StringBuffer stringBuffer, Object modInfo) {
        ModInfo info = (ModInfo)modInfo;
        if (Objects.equals(formatString, "id")) {
            stringBuffer.append(info.getModId());
        } else if (Objects.equals(formatString, "name")) {
            stringBuffer.append(info.getDisplayName());
        }
    }

    public static String getPattern(String patternName) {
        return i18n == null ? patternName : i18n.getOrDefault(patternName, patternName);
    }

    public static void loadLanguageData(Map<String, String> properties) {
        LOGGER.debug(Logging.CORE, "Loading I18N data entries: {}", (Object)properties.size());
        i18n = properties;
    }

    public static String parseMessage(String i18nMessage, Object ... args) {
        String pattern = ForgeI18n.getPattern(i18nMessage);
        try {
            return ForgeI18n.parseFormat(pattern, args);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error(Logging.CORE, "Illegal format found `{}`", (Object)pattern);
            return pattern;
        }
    }

    public static String parseFormat(String format, Object ... args) {
        ExtendedMessageFormat extendedMessageFormat = new ExtendedMessageFormat(format, customFactories);
        return extendedMessageFormat.format((Object)args);
    }

    static {
        customFactories = new HashMap<String, FormatFactory>();
        customFactories.put("modinfo", (name, formatString, locale) -> new CustomReadOnlyFormat((stringBuffer, objectToParse) -> ForgeI18n.parseModInfo(formatString, stringBuffer, objectToParse)));
        customFactories.put("lower", (name, formatString, locale) -> new CustomReadOnlyFormat((stringBuffer, objectToParse) -> stringBuffer.append(StringUtils.toLowerCase((String)String.valueOf(objectToParse)))));
        customFactories.put("upper", (name, formatString, locale) -> new CustomReadOnlyFormat((stringBuffer, objectToParse) -> stringBuffer.append(StringUtils.toUpperCase((String)String.valueOf(objectToParse)))));
        customFactories.put("exc", (name, formatString, locale) -> new CustomReadOnlyFormat((stringBuffer, objectToParse) -> ForgeI18n.parseException(formatString, stringBuffer, objectToParse)));
        customFactories.put("vr", (name, formatString, locale) -> new CustomReadOnlyFormat((stringBuffer, o) -> MavenVersionStringHelper.parseVersionRange(formatString, stringBuffer, o)));
        customFactories.put("i18n", (name, formatString, locale) -> new CustomReadOnlyFormat((stringBuffer, o) -> stringBuffer.append(ForgeI18n.parseMessage(formatString, o))));
        customFactories.put("ornull", (name, formatString, locale) -> new CustomReadOnlyFormat((stringBuffer, o) -> stringBuffer.append(Objects.equals(String.valueOf(o), "null") ? ForgeI18n.parseMessage(formatString, new Object[0]) : String.valueOf(o))));
    }

    public static class CustomReadOnlyFormat
    extends Format {
        private final BiConsumer<StringBuffer, Object> formatter;

        CustomReadOnlyFormat(BiConsumer<StringBuffer, Object> formatter) {
            this.formatter = formatter;
        }

        @Override
        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            this.formatter.accept(toAppendTo, obj);
            return toAppendTo;
        }

        @Override
        public Object parseObject(String source, ParsePosition pos) {
            throw new UnsupportedOperationException("Parsing is not supported");
        }
    }
}

