/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.PerspectiveMapWrapper;

public class BakedItemModel
implements IBakedModel {
    protected final ImmutableList<BakedQuad> quads;
    protected final TextureAtlasSprite particle;
    protected final ImmutableMap<ItemCameraTransforms.TransformType, TransformationMatrix> transforms;
    protected final ItemOverrideList overrides;
    protected final IBakedModel guiModel;
    protected final boolean isSideLit;

    public BakedItemModel(ImmutableList<BakedQuad> quads, TextureAtlasSprite particle, ImmutableMap<ItemCameraTransforms.TransformType, TransformationMatrix> transforms, ItemOverrideList overrides, boolean untransformed, boolean isSideLit) {
        this.quads = quads;
        this.particle = particle;
        this.transforms = transforms;
        this.overrides = overrides;
        this.isSideLit = isSideLit;
        this.guiModel = untransformed && BakedItemModel.hasGuiIdentity(transforms) ? new BakedGuiItemModel<BakedItemModel>(this) : null;
    }

    private static boolean hasGuiIdentity(ImmutableMap<ItemCameraTransforms.TransformType, TransformationMatrix> transforms) {
        TransformationMatrix guiTransform = (TransformationMatrix)transforms.get((Object)ItemCameraTransforms.TransformType.GUI);
        return guiTransform == null || guiTransform.isIdentity();
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_230044_c_() {
        return this.isSideLit;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.particle;
    }

    public ItemOverrideList func_188617_f() {
        return this.overrides;
    }

    public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction side, Random rand) {
        if (side == null) {
            return this.quads;
        }
        return ImmutableList.of();
    }

    public IBakedModel handlePerspective(ItemCameraTransforms.TransformType type, MatrixStack mat) {
        if (type == ItemCameraTransforms.TransformType.GUI && this.guiModel != null) {
            return this.guiModel.handlePerspective(type, mat);
        }
        return PerspectiveMapWrapper.handlePerspective((IBakedModel)this, this.transforms, type, mat);
    }

    public static class BakedGuiItemModel<T extends BakedItemModel>
    extends BakedModelWrapper<T> {
        private final ImmutableList<BakedQuad> quads;

        public BakedGuiItemModel(T originalModel) {
            super(originalModel);
            ImmutableList.Builder builder = ImmutableList.builder();
            for (BakedQuad quad : ((BakedItemModel)originalModel).quads) {
                if (quad.func_178210_d() != Direction.SOUTH) continue;
                builder.add((Object)quad);
            }
            this.quads = builder.build();
        }

        @Override
        public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction side, Random rand) {
            if (side == null) {
                return this.quads;
            }
            return ImmutableList.of();
        }

        @Override
        public boolean doesHandlePerspectives() {
            return true;
        }

        @Override
        public IBakedModel handlePerspective(ItemCameraTransforms.TransformType type, MatrixStack mat) {
            if (type == ItemCameraTransforms.TransformType.GUI) {
                return PerspectiveMapWrapper.handlePerspective((IBakedModel)this, ((BakedItemModel)this.originalModel).transforms, type, mat);
            }
            return ((BakedItemModel)this.originalModel).handlePerspective(type, mat);
        }
    }
}

