/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.data;

import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.data.BlockTagsProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.TagsProvider;
import net.minecraft.item.DyeColor;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class ForgeBlockTagsProvider
extends BlockTagsProvider {
    public ForgeBlockTagsProvider(DataGenerator gen, ExistingFileHelper existingFileHelper) {
        super(gen, "forge", existingFileHelper);
    }

    public void func_200432_c() {
        this.func_240522_a_(Tags.Blocks.CHESTS).addTags(new ITag.INamedTag[]{Tags.Blocks.CHESTS_ENDER, Tags.Blocks.CHESTS_TRAPPED, Tags.Blocks.CHESTS_WOODEN});
        this.func_240522_a_(Tags.Blocks.CHESTS_ENDER).func_240534_a_((Object[])new Block[]{Blocks.field_150477_bB});
        this.func_240522_a_(Tags.Blocks.CHESTS_TRAPPED).func_240534_a_((Object[])new Block[]{Blocks.field_150447_bR});
        this.func_240522_a_(Tags.Blocks.CHESTS_WOODEN).func_240534_a_((Object[])new Block[]{Blocks.field_150486_ae, Blocks.field_150447_bR});
        this.func_240522_a_(Tags.Blocks.COBBLESTONE).func_240534_a_((Object[])new Block[]{Blocks.field_150347_e, Blocks.field_196687_dd, Blocks.field_150341_Y});
        this.func_240522_a_(Tags.Blocks.DIRT).func_240534_a_((Object[])new Block[]{Blocks.field_150346_d, Blocks.field_196658_i, Blocks.field_196660_k, Blocks.field_196661_l, Blocks.field_150391_bh});
        this.func_240522_a_(Tags.Blocks.END_STONES).func_240534_a_((Object[])new Block[]{Blocks.field_150377_bs});
        this.func_240522_a_(Tags.Blocks.FENCE_GATES).addTags(new ITag.INamedTag[]{Tags.Blocks.FENCE_GATES_WOODEN});
        this.func_240522_a_(Tags.Blocks.FENCE_GATES_WOODEN).func_240534_a_((Object[])new Block[]{Blocks.field_180390_bo, Blocks.field_180391_bp, Blocks.field_180392_bq, Blocks.field_180386_br, Blocks.field_180387_bt, Blocks.field_180385_bs, Blocks.field_235354_mM_, Blocks.field_235355_mN_});
        this.func_240522_a_(Tags.Blocks.FENCES).addTags(new ITag.INamedTag[]{Tags.Blocks.FENCES_NETHER_BRICK, Tags.Blocks.FENCES_WOODEN});
        this.func_240522_a_(Tags.Blocks.FENCES_NETHER_BRICK).func_240534_a_((Object[])new Block[]{Blocks.field_150386_bk});
        this.func_240522_a_(Tags.Blocks.FENCES_WOODEN).func_240534_a_((Object[])new Block[]{Blocks.field_180407_aO, Blocks.field_180408_aP, Blocks.field_180404_aQ, Blocks.field_180403_aR, Blocks.field_180405_aT, Blocks.field_180406_aS, Blocks.field_235350_mI_, Blocks.field_235351_mJ_});
        this.func_240522_a_(Tags.Blocks.GLASS).addTags(new ITag.INamedTag[]{Tags.Blocks.GLASS_COLORLESS, Tags.Blocks.STAINED_GLASS});
        this.func_240522_a_(Tags.Blocks.GLASS_COLORLESS).func_240534_a_((Object[])new Block[]{Blocks.field_150359_w});
        this.addColored(arg_0 -> ForgeBlockTagsProvider.lambda$registerTags$0(this.func_240522_a_(Tags.Blocks.STAINED_GLASS), arg_0), Tags.Blocks.GLASS, "{color}_stained_glass");
        this.func_240522_a_(Tags.Blocks.GLASS_PANES).addTags(new ITag.INamedTag[]{Tags.Blocks.GLASS_PANES_COLORLESS, Tags.Blocks.STAINED_GLASS_PANES});
        this.func_240522_a_(Tags.Blocks.GLASS_PANES_COLORLESS).func_240534_a_((Object[])new Block[]{Blocks.field_150410_aZ});
        this.addColored(arg_0 -> ForgeBlockTagsProvider.lambda$registerTags$1(this.func_240522_a_(Tags.Blocks.STAINED_GLASS_PANES), arg_0), Tags.Blocks.GLASS_PANES, "{color}_stained_glass_pane");
        this.func_240522_a_(Tags.Blocks.GRAVEL).func_240534_a_((Object[])new Block[]{Blocks.field_150351_n});
        this.func_240522_a_(Tags.Blocks.NETHERRACK).func_240534_a_((Object[])new Block[]{Blocks.field_150424_aL});
        this.func_240522_a_(Tags.Blocks.OBSIDIAN).func_240534_a_((Object[])new Block[]{Blocks.field_150343_Z});
        this.func_240522_a_(Tags.Blocks.ORES).addTags(new ITag.INamedTag[]{Tags.Blocks.ORES_COAL, Tags.Blocks.ORES_DIAMOND, Tags.Blocks.ORES_EMERALD, Tags.Blocks.ORES_GOLD, Tags.Blocks.ORES_IRON, Tags.Blocks.ORES_LAPIS, Tags.Blocks.ORES_REDSTONE, Tags.Blocks.ORES_QUARTZ, Tags.Blocks.ORES_NETHERITE_SCRAP});
        this.func_240522_a_(Tags.Blocks.ORES_COAL).func_240534_a_((Object[])new Block[]{Blocks.field_150365_q});
        this.func_240522_a_(Tags.Blocks.ORES_DIAMOND).func_240534_a_((Object[])new Block[]{Blocks.field_150482_ag});
        this.func_240522_a_(Tags.Blocks.ORES_EMERALD).func_240534_a_((Object[])new Block[]{Blocks.field_150412_bA});
        this.func_240522_a_(Tags.Blocks.ORES_GOLD).func_240531_a_(BlockTags.field_232866_P_);
        this.func_240522_a_(Tags.Blocks.ORES_IRON).func_240534_a_((Object[])new Block[]{Blocks.field_150366_p});
        this.func_240522_a_(Tags.Blocks.ORES_LAPIS).func_240534_a_((Object[])new Block[]{Blocks.field_150369_x});
        this.func_240522_a_(Tags.Blocks.ORES_QUARTZ).func_240534_a_((Object[])new Block[]{Blocks.field_196766_fg});
        this.func_240522_a_(Tags.Blocks.ORES_REDSTONE).func_240534_a_((Object[])new Block[]{Blocks.field_150450_ax});
        this.func_240522_a_(Tags.Blocks.ORES_NETHERITE_SCRAP).func_240534_a_((Object[])new Block[]{Blocks.field_235398_nh_});
        this.func_240522_a_(Tags.Blocks.SAND).addTags(new ITag.INamedTag[]{Tags.Blocks.SAND_COLORLESS, Tags.Blocks.SAND_RED});
        this.func_240522_a_(Tags.Blocks.SAND_COLORLESS).func_240534_a_((Object[])new Block[]{Blocks.field_150354_m});
        this.func_240522_a_(Tags.Blocks.SAND_RED).func_240534_a_((Object[])new Block[]{Blocks.field_196611_F});
        this.func_240522_a_(Tags.Blocks.SANDSTONE).func_240534_a_((Object[])new Block[]{Blocks.field_150322_A, Blocks.field_196585_ak, Blocks.field_196583_aj, Blocks.field_196580_bH, Blocks.field_180395_cM, Blocks.field_196799_hB, Blocks.field_196798_hA, Blocks.field_196582_bJ});
        this.func_240522_a_(Tags.Blocks.STONE).func_240534_a_((Object[])new Block[]{Blocks.field_196656_g, Blocks.field_196654_e, Blocks.field_196650_c, Blocks.field_196686_dc, Blocks.field_150348_b, Blocks.field_196657_h, Blocks.field_196655_f, Blocks.field_196652_d});
        this.func_240522_a_(Tags.Blocks.STORAGE_BLOCKS).addTags(new ITag.INamedTag[]{Tags.Blocks.STORAGE_BLOCKS_COAL, Tags.Blocks.STORAGE_BLOCKS_DIAMOND, Tags.Blocks.STORAGE_BLOCKS_EMERALD, Tags.Blocks.STORAGE_BLOCKS_GOLD, Tags.Blocks.STORAGE_BLOCKS_IRON, Tags.Blocks.STORAGE_BLOCKS_LAPIS, Tags.Blocks.STORAGE_BLOCKS_QUARTZ, Tags.Blocks.STORAGE_BLOCKS_REDSTONE, Tags.Blocks.STORAGE_BLOCKS_NETHERITE});
        this.func_240522_a_(Tags.Blocks.STORAGE_BLOCKS_COAL).func_240534_a_((Object[])new Block[]{Blocks.field_150402_ci});
        this.func_240522_a_(Tags.Blocks.STORAGE_BLOCKS_DIAMOND).func_240534_a_((Object[])new Block[]{Blocks.field_150484_ah});
        this.func_240522_a_(Tags.Blocks.STORAGE_BLOCKS_EMERALD).func_240534_a_((Object[])new Block[]{Blocks.field_150475_bE});
        this.func_240522_a_(Tags.Blocks.STORAGE_BLOCKS_GOLD).func_240534_a_((Object[])new Block[]{Blocks.field_150340_R});
        this.func_240522_a_(Tags.Blocks.STORAGE_BLOCKS_IRON).func_240534_a_((Object[])new Block[]{Blocks.field_150339_S});
        this.func_240522_a_(Tags.Blocks.STORAGE_BLOCKS_LAPIS).func_240534_a_((Object[])new Block[]{Blocks.field_150368_y});
        this.func_240522_a_(Tags.Blocks.STORAGE_BLOCKS_QUARTZ).func_240534_a_((Object[])new Block[]{Blocks.field_150371_ca});
        this.func_240522_a_(Tags.Blocks.STORAGE_BLOCKS_REDSTONE).func_240534_a_((Object[])new Block[]{Blocks.field_150451_bX});
        this.func_240522_a_(Tags.Blocks.STORAGE_BLOCKS_NETHERITE).func_240534_a_((Object[])new Block[]{Blocks.field_235397_ng_});
    }

    private void addColored(Consumer<Block> consumer, ITag.INamedTag<Block> group, String pattern) {
        String prefix = group.func_230234_a_().func_110623_a().toUpperCase(Locale.ENGLISH) + '_';
        for (DyeColor color : DyeColor.values()) {
            ResourceLocation key = new ResourceLocation("minecraft", pattern.replace("{color}", color.func_176762_d()));
            ITag.INamedTag<Block> tag = this.getForgeTag(prefix + color.func_176762_d());
            Block block = ForgeRegistries.BLOCKS.getValue(key);
            if (block == null || block == Blocks.field_150350_a) {
                throw new IllegalStateException("Unknown vanilla block: " + key.toString());
            }
            this.func_240522_a_(tag).func_240534_a_((Object[])new Block[]{block});
            consumer.accept(block);
        }
    }

    private ITag.INamedTag<Block> getForgeTag(String name) {
        try {
            name = name.toUpperCase(Locale.ENGLISH);
            return (ITag.INamedTag)Tags.Blocks.class.getDeclaredField(name).get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new IllegalStateException(Tags.Blocks.class.getName() + " is missing tag name: " + name);
        }
    }

    public String func_200397_b() {
        return "Forge Block Tags";
    }

    private static /* synthetic */ void lambda$registerTags$1(TagsProvider.Builder rec$, Block xva$0) {
        rec$.func_240534_a_((Object[])new Block[]{xva$0});
    }

    private static /* synthetic */ void lambda$registerTags$0(TagsProvider.Builder rec$, Block xva$0) {
        rec$.func_240534_a_((Object[])new Block[]{xva$0});
    }
}

