/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.ConditionalAdvancement;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.registries.ObjectHolder;

public class ConditionalRecipe {
    @ObjectHolder(value="forge:conditional")
    public static final IRecipeSerializer<IRecipe<?>> SERIALZIER = null;

    public static Builder builder() {
        return new Builder();
    }

    private static class Finished
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final List<ICondition[]> conditions;
        private final List<IFinishedRecipe> recipes;
        private final ResourceLocation advId;
        private final ConditionalAdvancement.Builder adv;

        private Finished(ResourceLocation id, List<ICondition[]> conditions, List<IFinishedRecipe> recipes, @Nullable ResourceLocation advId, @Nullable ConditionalAdvancement.Builder adv) {
            this.id = id;
            this.conditions = conditions;
            this.recipes = recipes;
            this.advId = advId;
            this.adv = adv;
        }

        public void func_218610_a(JsonObject json) {
            JsonArray array = new JsonArray();
            json.add("recipes", (JsonElement)array);
            for (int x = 0; x < this.conditions.size(); ++x) {
                JsonObject holder = new JsonObject();
                JsonArray conds = new JsonArray();
                for (ICondition c : this.conditions.get(x)) {
                    conds.add((JsonElement)CraftingHelper.serialize(c));
                }
                holder.add("conditions", (JsonElement)conds);
                holder.add("recipe", (JsonElement)this.recipes.get(x).func_200441_a());
                array.add((JsonElement)holder);
            }
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        public IRecipeSerializer<?> func_218609_c() {
            return SERIALZIER;
        }

        public JsonObject func_200440_c() {
            return this.adv == null ? null : this.adv.write();
        }

        public ResourceLocation func_200443_d() {
            return this.advId;
        }
    }

    public static class Builder {
        private List<ICondition[]> conditions = new ArrayList<ICondition[]>();
        private List<IFinishedRecipe> recipes = new ArrayList<IFinishedRecipe>();
        private ResourceLocation advId;
        private ConditionalAdvancement.Builder adv;
        private List<ICondition> currentConditions = new ArrayList<ICondition>();

        public Builder addCondition(ICondition condition) {
            this.currentConditions.add(condition);
            return this;
        }

        public Builder addRecipe(Consumer<Consumer<IFinishedRecipe>> callable) {
            callable.accept(this::addRecipe);
            return this;
        }

        public Builder addRecipe(IFinishedRecipe recipe) {
            if (this.currentConditions.isEmpty()) {
                throw new IllegalStateException("Can not add a recipe with no conditions.");
            }
            this.conditions.add(this.currentConditions.toArray(new ICondition[this.currentConditions.size()]));
            this.recipes.add(recipe);
            this.currentConditions.clear();
            return this;
        }

        public Builder generateAdvancement() {
            return this.generateAdvancement(null);
        }

        public Builder generateAdvancement(@Nullable ResourceLocation id) {
            ConditionalAdvancement.Builder builder = ConditionalAdvancement.builder();
            for (int i = 0; i < this.recipes.size(); ++i) {
                for (ICondition cond : this.conditions.get(i)) {
                    builder = builder.addCondition(cond);
                }
                builder = builder.addAdvancement(this.recipes.get(i));
            }
            return this.setAdvancement(id, builder);
        }

        public Builder setAdvancement(ConditionalAdvancement.Builder advancement) {
            return this.setAdvancement(null, advancement);
        }

        public Builder setAdvancement(String namespace, String path, ConditionalAdvancement.Builder advancement) {
            return this.setAdvancement(new ResourceLocation(namespace, path), advancement);
        }

        public Builder setAdvancement(@Nullable ResourceLocation id, ConditionalAdvancement.Builder advancement) {
            if (this.adv != null) {
                throw new IllegalStateException("Invalid ConditionalRecipeBuilder, Advancement already set");
            }
            this.advId = id;
            this.adv = advancement;
            return this;
        }

        public void build(Consumer<IFinishedRecipe> consumer, String namespace, String path) {
            this.build(consumer, new ResourceLocation(namespace, path));
        }

        public void build(Consumer<IFinishedRecipe> consumer, ResourceLocation id) {
            if (!this.currentConditions.isEmpty()) {
                throw new IllegalStateException("Invalid ConditionalRecipe builder, Orphaned conditions");
            }
            if (this.recipes.isEmpty()) {
                throw new IllegalStateException("Invalid ConditionalRecipe builder, No recipes");
            }
            if (this.advId == null && this.adv != null) {
                this.advId = new ResourceLocation(id.func_110624_b(), "recipes/" + id.func_110623_a());
            }
            consumer.accept(new Finished(id, this.conditions, this.recipes, this.advId, this.adv));
        }
    }

    public static class Serializer<T extends IRecipe<?>>
    implements IRecipeSerializer<T> {
        private ResourceLocation name;

        public IRecipeSerializer<?> setRegistryName(ResourceLocation name) {
            this.name = name;
            return this;
        }

        public ResourceLocation getRegistryName() {
            return this.name;
        }

        public Class<IRecipeSerializer<?>> getRegistryType() {
            return Serializer.castClass(IRecipeSerializer.class);
        }

        private static <G> Class<G> castClass(Class<?> cls) {
            return cls;
        }

        public T func_199425_a_(ResourceLocation recipeId, JsonObject json) {
            JsonArray items = JSONUtils.func_151214_t((JsonObject)json, (String)"recipes");
            int idx = 0;
            for (JsonElement ele : items) {
                if (!ele.isJsonObject()) {
                    throw new JsonSyntaxException("Invalid recipes entry at index " + idx + " Must be JsonObject");
                }
                if (CraftingHelper.processConditions(JSONUtils.func_151214_t((JsonObject)ele.getAsJsonObject(), (String)"conditions"))) {
                    return (T)RecipeManager.func_215377_a((ResourceLocation)recipeId, (JsonObject)JSONUtils.func_152754_s((JsonObject)ele.getAsJsonObject(), (String)"recipe"));
                }
                ++idx;
            }
            return null;
        }

        public T func_199426_a_(ResourceLocation recipeId, PacketBuffer buffer) {
            return null;
        }

        public void func_199427_a_(PacketBuffer buffer, T recipe) {
        }
    }
}

