/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml;

import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.LogicalSide;

public enum LogicalSidedProvider {
    WORKQUEUE(c -> (Minecraft)c.get(), s -> (MinecraftServer)s.get()),
    INSTANCE(c -> (Minecraft)c.get(), s -> (MinecraftServer)s.get()),
    CLIENTWORLD(c -> Optional.of(((Minecraft)c.get()).field_71441_e), s -> Optional.empty());

    private static Supplier<Minecraft> client;
    private static Supplier<MinecraftServer> server;
    private final Function<Supplier<Minecraft>, ?> clientSide;
    private final Function<Supplier<MinecraftServer>, ?> serverSide;

    private LogicalSidedProvider(Function<Supplier<Minecraft>, ?> clientSide, Function<Supplier<MinecraftServer>, ?> serverSide) {
        this.clientSide = clientSide;
        this.serverSide = serverSide;
    }

    public static void setClient(Supplier<Minecraft> client) {
        LogicalSidedProvider.client = client;
    }

    public static void setServer(Supplier<MinecraftServer> server) {
        LogicalSidedProvider.server = server;
    }

    public <T> T get(LogicalSide side) {
        return (T)(side == LogicalSide.CLIENT ? this.clientSide.apply(client) : this.serverSide.apply(server));
    }
}

