/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

public class ForgeSpawnEggItem
extends SpawnEggItem {
    private static final List<ForgeSpawnEggItem> MOD_EGGS = new ArrayList<ForgeSpawnEggItem>();
    private static final Map<EntityType<?>, ForgeSpawnEggItem> TYPE_MAP = new IdentityHashMap();
    private final Supplier<? extends EntityType<?>> typeSupplier;
    private static final DefaultDispenseItemBehavior DEFAULT_DISPENSE_BEHAVIOR = new DefaultDispenseItemBehavior(){

        protected ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
            Direction face = (Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a);
            EntityType type = ((SpawnEggItem)stack.func_77973_b()).func_208076_b(stack.func_77978_p());
            try {
                type.func_220331_a(source.func_197524_h(), stack, null, source.func_180699_d().func_177972_a(face), SpawnReason.DISPENSER, face != Direction.UP, false);
            }
            catch (Exception exception) {
                DefaultDispenseItemBehavior.LOGGER.error("Error while dispensing spawn egg from dispenser at {}", (Object)source.func_180699_d(), (Object)exception);
                return ItemStack.field_190927_a;
            }
            stack.func_190918_g(1);
            return stack;
        }
    };

    public ForgeSpawnEggItem(Supplier<? extends EntityType<?>> type, int backgroundColor, int highlightColor, Item.Properties props) {
        super((EntityType)null, backgroundColor, highlightColor, props);
        this.typeSupplier = type;
        MOD_EGGS.add(this);
    }

    public EntityType<?> func_208076_b(@Nullable CompoundNBT tag) {
        EntityType<?> type = super.func_208076_b(tag);
        return type != null ? type : this.typeSupplier.get();
    }

    @Nullable
    protected DefaultDispenseItemBehavior createDispenseBehavior() {
        return DEFAULT_DISPENSE_BEHAVIOR;
    }

    @Nullable
    public static SpawnEggItem fromEntityType(@Nullable EntityType<?> type) {
        SpawnEggItem ret = TYPE_MAP.get(type);
        return ret != null ? ret : SpawnEggItem.func_200889_b(type);
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="forge", bus=Mod.EventBusSubscriber.Bus.MOD)
    private static class ColorRegisterHandler {
        private ColorRegisterHandler() {
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void registerSpawnEggColors(ColorHandlerEvent.Item event) {
            MOD_EGGS.forEach(egg -> event.getItemColors().func_199877_a((stack, layer) -> egg.func_195983_a(layer), new IItemProvider[]{egg}));
        }
    }

    @Mod.EventBusSubscriber(modid="forge", bus=Mod.EventBusSubscriber.Bus.MOD)
    private static class CommonHandler {
        private CommonHandler() {
        }

        @SubscribeEvent
        public static void onCommonSetup(FMLCommonSetupEvent event) {
            MOD_EGGS.forEach(egg -> {
                DefaultDispenseItemBehavior dispenseBehavior = egg.createDispenseBehavior();
                if (dispenseBehavior != null) {
                    DispenserBlock.func_199774_a((IItemProvider)egg, (IDispenseItemBehavior)dispenseBehavior);
                }
                TYPE_MAP.put(((ForgeSpawnEggItem)egg).typeSupplier.get(), egg);
            });
        }
    }
}

