/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.loot;

import com.google.gson.JsonObject;
import net.minecraft.loot.ConditionArraySerializer;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IForgeRegistryEntry;

public abstract class GlobalLootModifierSerializer<T extends IGlobalLootModifier>
implements IForgeRegistryEntry<GlobalLootModifierSerializer<?>> {
    private ResourceLocation registryName = null;

    public final GlobalLootModifierSerializer<T> setRegistryName(String name) {
        if (this.getRegistryName() != null) {
            throw new IllegalStateException("Attempted to set registry name with existing registry name! New: " + name + " Old: " + this.getRegistryName());
        }
        this.registryName = GameData.checkPrefix(name, true);
        return this;
    }

    @Override
    public final GlobalLootModifierSerializer<T> setRegistryName(ResourceLocation name) {
        return this.setRegistryName(name.toString());
    }

    public final GlobalLootModifierSerializer<T> setRegistryName(String modID, String name) {
        return this.setRegistryName(modID + ":" + name);
    }

    @Override
    public final ResourceLocation getRegistryName() {
        return this.registryName;
    }

    public abstract T read(ResourceLocation var1, JsonObject var2, ILootCondition[] var3);

    public abstract JsonObject write(T var1);

    public JsonObject makeConditions(ILootCondition[] conditions) {
        JsonObject json = new JsonObject();
        json.add("conditions", ConditionArraySerializer.field_235679_a_.func_235681_a_(conditions));
        return json;
    }

    @Override
    public final Class<GlobalLootModifierSerializer<?>> getRegistryType() {
        return GlobalLootModifierSerializer.castClass(GlobalLootModifierSerializer.class);
    }

    private static <G> Class<G> castClass(Class<?> cls) {
        return cls;
    }
}

