/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.client.gui.widget;

import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.client.gui.GuiUtils;
import net.minecraftforge.fml.client.gui.widget.ExtendedButton;

public class Slider
extends ExtendedButton {
    public double sliderValue = 1.0;
    public ITextComponent dispString;
    public boolean dragging = false;
    public boolean showDecimal = true;
    public double minValue = 0.0;
    public double maxValue = 5.0;
    public int precision = 1;
    @Nullable
    public ISlider parent = null;
    public ITextComponent suffix;
    public boolean drawString = true;

    public Slider(int xPos, int yPos, int width, int height, ITextComponent prefix, ITextComponent suf, double minVal, double maxVal, double currentVal, boolean showDec, boolean drawStr, Button.IPressable handler) {
        this(xPos, yPos, width, height, prefix, suf, minVal, maxVal, currentVal, showDec, drawStr, handler, null);
    }

    public Slider(int xPos, int yPos, int width, int height, ITextComponent prefix, ITextComponent suf, double minVal, double maxVal, double currentVal, boolean showDec, boolean drawStr, Button.IPressable handler, @Nullable ISlider par) {
        super(xPos, yPos, width, height, prefix, handler);
        String val;
        this.minValue = minVal;
        this.maxValue = maxVal;
        this.sliderValue = (currentVal - this.minValue) / (this.maxValue - this.minValue);
        this.dispString = prefix;
        this.parent = par;
        this.suffix = suf;
        this.showDecimal = showDec;
        if (this.showDecimal) {
            val = Double.toString(this.sliderValue * (this.maxValue - this.minValue) + this.minValue);
            this.precision = Math.min(val.substring(val.indexOf(".") + 1).length(), 4);
        } else {
            val = Integer.toString((int)Math.round(this.sliderValue * (this.maxValue - this.minValue) + this.minValue));
            this.precision = 0;
        }
        this.func_238482_a_((ITextComponent)new StringTextComponent("").func_230529_a_(this.dispString).func_240702_b_(val).func_230529_a_(this.suffix));
        this.drawString = drawStr;
        if (!this.drawString) {
            this.func_238482_a_((ITextComponent)new StringTextComponent(""));
        }
    }

    public Slider(int xPos, int yPos, ITextComponent displayStr, double minVal, double maxVal, double currentVal, Button.IPressable handler, ISlider par) {
        this(xPos, yPos, 150, 20, displayStr, (ITextComponent)new StringTextComponent(""), minVal, maxVal, currentVal, true, true, handler, par);
    }

    public int func_230989_a_(boolean par1) {
        return 0;
    }

    protected void func_230441_a_(MatrixStack mStack, Minecraft par1Minecraft, int par2, int par3) {
        if (this.field_230694_p_) {
            if (this.dragging) {
                this.sliderValue = (float)(par2 - (this.field_230690_l_ + 4)) / (float)(this.field_230688_j_ - 8);
                this.updateSlider();
            }
            GuiUtils.drawContinuousTexturedBox(mStack, field_230687_i_, this.field_230690_l_ + (int)(this.sliderValue * (double)(this.field_230688_j_ - 8)), this.field_230691_m_, 0, 66, 8, this.field_230689_k_, 200, 20, 2, 3, 2, 2, this.func_230927_p_());
        }
    }

    public void func_230982_a_(double mouseX, double mouseY) {
        this.sliderValue = (mouseX - (double)(this.field_230690_l_ + 4)) / (double)(this.field_230688_j_ - 8);
        this.updateSlider();
        this.dragging = true;
    }

    public void updateSlider() {
        String val;
        if (this.sliderValue < 0.0) {
            this.sliderValue = 0.0;
        }
        if (this.sliderValue > 1.0) {
            this.sliderValue = 1.0;
        }
        if (this.showDecimal) {
            val = Double.toString(this.sliderValue * (this.maxValue - this.minValue) + this.minValue);
            if (val.substring(val.indexOf(".") + 1).length() > this.precision) {
                if ((val = val.substring(0, val.indexOf(".") + this.precision + 1)).endsWith(".")) {
                    val = val.substring(0, val.indexOf(".") + this.precision);
                }
            } else {
                while (val.substring(val.indexOf(".") + 1).length() < this.precision) {
                    val = val + "0";
                }
            }
        } else {
            val = Integer.toString((int)Math.round(this.sliderValue * (this.maxValue - this.minValue) + this.minValue));
        }
        if (this.drawString) {
            this.func_238482_a_((ITextComponent)new StringTextComponent("").func_230529_a_(this.dispString).func_240702_b_(val).func_230529_a_(this.suffix));
        }
        if (this.parent != null) {
            this.parent.onChangeSliderValue(this);
        }
    }

    public void func_231000_a__(double mouseX, double mouseY) {
        this.dragging = false;
    }

    public int getValueInt() {
        return (int)Math.round(this.sliderValue * (this.maxValue - this.minValue) + this.minValue);
    }

    public double getValue() {
        return this.sliderValue * (this.maxValue - this.minValue) + this.minValue;
    }

    public void setValue(double d) {
        this.sliderValue = (d - this.minValue) / (this.maxValue - this.minValue);
    }

    public static interface ISlider {
        public void onChangeSliderValue(Slider var1);
    }
}

