/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.network;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.network.IPacket;
import net.minecraft.network.NetworkManager;

public abstract class VanillaPacketFilter
extends MessageToMessageEncoder<IPacket<?>> {
    protected final Map<Class<? extends IPacket<?>>, BiConsumer<IPacket<?>, List<? super IPacket<?>>>> handlers;

    protected VanillaPacketFilter(Map<Class<? extends IPacket<?>>, BiConsumer<IPacket<?>, List<? super IPacket<?>>>> handlers) {
        this.handlers = handlers;
    }

    @Nonnull
    protected static <T extends IPacket<?>> Map.Entry<Class<? extends IPacket<?>>, BiConsumer<IPacket<?>, List<? super IPacket<?>>>> handler(Class<T> cls, Function<T, ? extends IPacket<?>> function) {
        return VanillaPacketFilter.handler(cls, (IPacket<?> pkt, List<? super IPacket<?>> list) -> list.add(function.apply(cls.cast(pkt))));
    }

    @Nonnull
    protected static <T extends IPacket<?>> Map.Entry<Class<? extends IPacket<?>>, BiConsumer<IPacket<?>, List<? super IPacket<?>>>> handler(Class<T> cls, BiConsumer<IPacket<?>, List<? super IPacket<?>>> consumer) {
        return new AbstractMap.SimpleEntry(cls, consumer);
    }

    protected abstract boolean isNecessary(NetworkManager var1);

    protected void encode(ChannelHandlerContext ctx, IPacket<?> msg, List<Object> out) {
        BiConsumer<IPacket, List> consumer = this.handlers.getOrDefault(msg.getClass(), (pkt, list) -> list.add(pkt));
        consumer.accept(msg, out);
    }
}

