/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screens.worldselection.WorldPreset;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraftforge.common.world.ForgeWorldType;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ForgeWorldTypeScreens {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<ForgeWorldType, WorldPreset> GENERATORS = Maps.newHashMap();
    private static final Map<ForgeWorldType, WorldPreset.PresetEditor> GENERATOR_SCREEN_FACTORIES = Maps.newHashMap();

    public static synchronized void registerFactory(ForgeWorldType type, WorldPreset.PresetEditor factory) {
        if (GENERATOR_SCREEN_FACTORIES.containsKey(type)) {
            throw new IllegalStateException("Factory has already been registered for: " + type);
        }
        GENERATOR_SCREEN_FACTORIES.put(type, factory);
    }

    static WorldPreset getDefaultGenerator() {
        ForgeWorldType def = ForgeWorldType.getDefaultWorldType();
        if (def == null) {
            return WorldPreset.f_101506_;
        }
        WorldPreset gen = GENERATORS.get(def);
        if (gen == null) {
            LOGGER.error("The default world type '{}' has not been added to the GUI. Was it registered too late?", (Object)def.getRegistryName());
            return WorldPreset.f_101506_;
        }
        return gen;
    }

    static WorldPreset.PresetEditor getGeneratorScreenFactory(Optional<WorldPreset> generator, @Nullable WorldPreset.PresetEditor biomegeneratortypescreens$ifactory) {
        return generator.filter(gen -> gen instanceof GeneratorType).map(type -> GENERATOR_SCREEN_FACTORIES.get(((GeneratorType)((Object)type)).getWorldType())).orElse(biomegeneratortypescreens$ifactory);
    }

    static void registerTypes() {
        ForgeRegistries.WORLD_TYPES.forEach(wt -> {
            GeneratorType gen = new GeneratorType((ForgeWorldType)wt);
            GENERATORS.put((ForgeWorldType)wt, gen);
            WorldPreset.registerGenerator((WorldPreset)gen);
        });
    }

    private static class GeneratorType
    extends WorldPreset {
        private final ForgeWorldType worldType;

        public GeneratorType(ForgeWorldType wt) {
            super(wt.getDisplayName());
            this.worldType = wt;
        }

        public ForgeWorldType getWorldType() {
            return this.worldType;
        }

        @Nonnull
        public WorldGenSettings m_7012_(@Nonnull RegistryAccess.RegistryHolder dynamicRegistries, long seed, boolean generateStructures, boolean bonusChest) {
            return this.worldType.createSettings((RegistryAccess)dynamicRegistries, seed, generateStructures, bonusChest, "");
        }

        @Nonnull
        protected ChunkGenerator m_7474_(@Nonnull Registry<Biome> p_241869_1_, @Nonnull Registry<NoiseGeneratorSettings> p_241869_2_, long p_241869_3_) {
            return this.worldType.createChunkGenerator(p_241869_1_, p_241869_2_, p_241869_3_, "");
        }
    }
}

