/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.event;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;

public abstract class RenderTooltipEvent
extends Event {
    @Nonnull
    protected final ItemStack stack;
    @Deprecated(since="1.18", forRemoval=true)
    protected final List<? extends FormattedText> lines;
    protected final PoseStack matrixStack;
    protected int x;
    protected int y;
    protected Font fr;
    protected final List<ClientTooltipComponent> components;

    @Deprecated(since="1.18", forRemoval=true)
    public RenderTooltipEvent(@Nonnull ItemStack stack, @Nonnull List<? extends FormattedText> lines, PoseStack matrixStack, int x, int y, @Nonnull Font fr) {
        this.stack = stack;
        this.lines = Collections.unmodifiableList(lines);
        this.matrixStack = matrixStack;
        this.x = x;
        this.y = y;
        this.fr = fr;
        this.components = List.of();
    }

    public RenderTooltipEvent(@Nonnull ItemStack stack, PoseStack poseStack, int x, int y, @Nonnull Font font, @Nonnull List<ClientTooltipComponent> components) {
        this.stack = stack;
        this.lines = List.of();
        this.components = Collections.unmodifiableList(components);
        this.matrixStack = poseStack;
        this.x = x;
        this.y = y;
        this.fr = font;
    }

    @Nonnull
    public ItemStack getStack() {
        return this.stack;
    }

    @Nonnull
    @Deprecated(since="1.18", forRemoval=true)
    public List<? extends FormattedText> getLines() {
        return this.lines;
    }

    @Nonnull
    public List<ClientTooltipComponent> getComponents() {
        return this.components;
    }

    public PoseStack getMatrixStack() {
        return this.matrixStack;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    @Nonnull
    public Font getFontRenderer() {
        return this.fr;
    }

    public static class Color
    extends RenderTooltipEvent {
        private final int originalBackground;
        private final int originalBorderStart;
        private final int originalBorderEnd;
        private int backgroundStart;
        private int backgroundEnd;
        private int borderStart;
        private int borderEnd;

        @Deprecated(since="1.18", forRemoval=true)
        public Color(@Nonnull ItemStack stack, @Nonnull List<? extends FormattedText> textLines, PoseStack matrixStack, int x, int y, @Nonnull Font fr, int background, int borderStart, int borderEnd) {
            super(stack, textLines, matrixStack, x, y, fr);
            this.originalBackground = background;
            this.originalBorderStart = borderStart;
            this.originalBorderEnd = borderEnd;
            this.backgroundStart = background;
            this.backgroundEnd = background;
            this.borderStart = borderStart;
            this.borderEnd = borderEnd;
        }

        public Color(@Nonnull ItemStack stack, PoseStack matrixStack, int x, int y, @Nonnull Font fr, int background, int borderStart, int borderEnd, @Nonnull List<ClientTooltipComponent> components) {
            super(stack, matrixStack, x, y, fr, components);
            this.originalBackground = background;
            this.originalBorderStart = borderStart;
            this.originalBorderEnd = borderEnd;
            this.backgroundStart = background;
            this.backgroundEnd = background;
            this.borderStart = borderStart;
            this.borderEnd = borderEnd;
        }

        @Deprecated(since="1.18", forRemoval=true)
        public int getBackground() {
            return this.backgroundStart;
        }

        public int getBackgroundStart() {
            return this.backgroundStart;
        }

        public int getBackgroundEnd() {
            return this.backgroundEnd;
        }

        public void setBackground(int background) {
            this.backgroundStart = background;
            this.backgroundEnd = background;
        }

        public void setBackgroundStart(int backgroundStart) {
            this.backgroundStart = backgroundStart;
        }

        public void setBackgroundEnd(int backgroundEnd) {
            this.backgroundEnd = backgroundEnd;
        }

        public int getBorderStart() {
            return this.borderStart;
        }

        public void setBorderStart(int borderStart) {
            this.borderStart = borderStart;
        }

        public int getBorderEnd() {
            return this.borderEnd;
        }

        public void setBorderEnd(int borderEnd) {
            this.borderEnd = borderEnd;
        }

        @Deprecated(since="1.18", forRemoval=true)
        public int getOriginalBackground() {
            return this.originalBackground;
        }

        public int getOriginalBackgroundStart() {
            return this.originalBackground;
        }

        public int getOriginalBackgroundEnd() {
            return this.originalBackground;
        }

        public int getOriginalBorderStart() {
            return this.originalBorderStart;
        }

        public int getOriginalBorderEnd() {
            return this.originalBorderEnd;
        }
    }

    @Deprecated(since="1.18", forRemoval=true)
    public static class PostText
    extends Post {
        public PostText(@Nonnull ItemStack stack, @Nonnull List<? extends FormattedText> textLines, PoseStack matrixStack, int x, int y, @Nonnull Font fr, int width, int height) {
            super(stack, textLines, matrixStack, x, y, fr, width, height);
        }
    }

    @Deprecated(since="1.18", forRemoval=true)
    public static class PostBackground
    extends Post {
        public PostBackground(@Nonnull ItemStack stack, @Nonnull List<? extends FormattedText> textLines, PoseStack matrixStack, int x, int y, @Nonnull Font fr, int width, int height) {
            super(stack, textLines, matrixStack, x, y, fr, width, height);
        }
    }

    @Deprecated(since="1.18", forRemoval=true)
    protected static abstract class Post
    extends RenderTooltipEvent {
        private final int width;
        private final int height;

        public Post(@Nonnull ItemStack stack, @Nonnull List<? extends FormattedText> textLines, PoseStack matrixStack, int x, int y, @Nonnull Font fr, int width, int height) {
            super(stack, textLines, matrixStack, x, y, fr);
            this.width = width;
            this.height = height;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }
    }

    @Cancelable
    public static class Pre
    extends RenderTooltipEvent {
        private int screenWidth;
        private int screenHeight;
        private int maxWidth;

        @Deprecated(since="1.18", forRemoval=true)
        public Pre(@Nonnull ItemStack stack, @Nonnull List<? extends FormattedText> lines, PoseStack matrixStack, int x, int y, int screenWidth, int screenHeight, int maxWidth, @Nonnull Font fr) {
            super(stack, lines, matrixStack, x, y, fr);
            this.screenWidth = screenWidth;
            this.screenHeight = screenHeight;
            this.maxWidth = maxWidth;
        }

        public Pre(@Nonnull ItemStack stack, PoseStack matrixStack, int x, int y, int screenWidth, int screenHeight, @Nonnull Font font, @Nonnull List<ClientTooltipComponent> components) {
            super(stack, matrixStack, x, y, font, components);
            this.screenWidth = screenWidth;
            this.screenHeight = screenHeight;
            this.maxWidth = -1;
        }

        public int getScreenWidth() {
            return this.screenWidth;
        }

        @Deprecated(since="1.18", forRemoval=true)
        public void setScreenWidth(int screenWidth) {
            this.screenWidth = screenWidth;
        }

        public int getScreenHeight() {
            return this.screenHeight;
        }

        @Deprecated(since="1.18", forRemoval=true)
        public void setScreenHeight(int screenHeight) {
            this.screenHeight = screenHeight;
        }

        @Deprecated(since="1.18", forRemoval=true)
        public int getMaxWidth() {
            return this.maxWidth;
        }

        @Deprecated(since="1.18", forRemoval=true)
        public void setMaxWidth(int maxWidth) {
            this.maxWidth = maxWidth;
        }

        public void setFontRenderer(@Nonnull Font fr) {
            this.fr = fr;
        }

        public void setX(int x) {
            this.x = x;
        }

        public void setY(int y) {
            this.y = y;
        }
    }

    @Cancelable
    public static class GatherComponents
    extends Event {
        private final ItemStack stack;
        private final int screenWidth;
        private final int screenHeight;
        private final List<Either<FormattedText, TooltipComponent>> tooltipElements;
        private int maxWidth;

        public GatherComponents(ItemStack stack, int screenWidth, int screenHeight, List<Either<FormattedText, TooltipComponent>> tooltipElements, int maxWidth) {
            this.stack = stack;
            this.screenWidth = screenWidth;
            this.screenHeight = screenHeight;
            this.tooltipElements = tooltipElements;
            this.maxWidth = maxWidth;
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public int getScreenWidth() {
            return this.screenWidth;
        }

        public int getScreenHeight() {
            return this.screenHeight;
        }

        public List<Either<FormattedText, TooltipComponent>> getTooltipElements() {
            return this.tooltipElements;
        }

        public int getMaxWidth() {
            return this.maxWidth;
        }

        public void setMaxWidth(int maxWidth) {
            this.maxWidth = maxWidth;
        }
    }
}

