/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Quaternion;
import com.mojang.math.Transformation;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.CompositeModelState;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.ItemMultiLayerBakedModel;
import net.minecraftforge.client.model.ItemTextureQuadConverter;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class DynamicBucketModel
implements IModelGeometry<DynamicBucketModel> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final float NORTH_Z_COVER = 0.4685f;
    private static final float SOUTH_Z_COVER = 0.5315f;
    private static final float NORTH_Z_FLUID = 0.468625f;
    private static final float SOUTH_Z_FLUID = 0.531375f;
    @Nonnull
    private final Fluid fluid;
    private final boolean flipGas;
    private final boolean tint;
    private final boolean coverIsMask;
    private final boolean applyFluidLuminosity;

    @Deprecated
    public DynamicBucketModel(Fluid fluid, boolean flipGas, boolean tint, boolean coverIsMask) {
        this(fluid, flipGas, tint, coverIsMask, true);
    }

    public DynamicBucketModel(Fluid fluid, boolean flipGas, boolean tint, boolean coverIsMask, boolean applyFluidLuminosity) {
        this.fluid = fluid;
        this.flipGas = flipGas;
        this.tint = tint;
        this.coverIsMask = coverIsMask;
        this.applyFluidLuminosity = applyFluidLuminosity;
    }

    public DynamicBucketModel withFluid(Fluid newFluid) {
        return new DynamicBucketModel(newFluid, this.flipGas, this.tint, this.coverIsMask, this.applyFluidLuminosity);
    }

    @Override
    public BakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
        TextureAtlasSprite templateSprite;
        TextureAtlasSprite particleSprite;
        Material particleLocation = owner.isTexturePresent("particle") ? owner.resolveTexture("particle") : null;
        Material baseLocation = owner.isTexturePresent("base") ? owner.resolveTexture("base") : null;
        Material fluidMaskLocation = owner.isTexturePresent("fluid") ? owner.resolveTexture("fluid") : null;
        Material coverLocation = owner.isTexturePresent("cover") ? owner.resolveTexture("cover") : null;
        ModelState transformsFromModel = owner.getCombinedTransform();
        TextureAtlasSprite fluidSprite = this.fluid != Fluids.f_76191_ ? spriteGetter.apply(ForgeHooksClient.getBlockMaterial(this.fluid.getAttributes().getStillTexture())) : null;
        TextureAtlasSprite coverSprite = coverLocation != null && (!this.coverIsMask || baseLocation != null) ? spriteGetter.apply(coverLocation) : null;
        ImmutableMap<ItemTransforms.TransformType, Transformation> transformMap = PerspectiveMapWrapper.getTransforms(new CompositeModelState(transformsFromModel, modelTransform));
        TextureAtlasSprite textureAtlasSprite = particleSprite = particleLocation != null ? spriteGetter.apply(particleLocation) : null;
        if (particleSprite == null) {
            particleSprite = fluidSprite;
        }
        if (particleSprite == null && !this.coverIsMask) {
            particleSprite = coverSprite;
        }
        if (this.flipGas && this.fluid != Fluids.f_76191_ && this.fluid.getAttributes().isLighterThanAir()) {
            modelTransform = new SimpleModelState(modelTransform.m_6189_().blockCornerToCenter().m_121096_(new Transformation(null, new Quaternion(0.0f, 0.0f, 1.0f, 0.0f), null, null)).blockCenterToCorner());
        }
        Transformation transform = modelTransform.m_6189_();
        ItemMultiLayerBakedModel.Builder builder = ItemMultiLayerBakedModel.builder(owner, particleSprite, new ContainedFluidOverrideHandler(overrides, bakery, owner, this), transformMap);
        if (baseLocation != null) {
            builder.addQuads(ItemLayerModel.getLayerRenderType(false), (Collection<BakedQuad>)ItemLayerModel.getQuadsForSprites((List<Material>)ImmutableList.of((Object)baseLocation), transform, spriteGetter));
        }
        if (fluidMaskLocation != null && fluidSprite != null && (templateSprite = spriteGetter.apply(fluidMaskLocation)) != null) {
            int luminosity = this.applyFluidLuminosity ? this.fluid.getAttributes().getLuminosity() : 0;
            int color = this.tint ? this.fluid.getAttributes().getColor() : -1;
            builder.addQuads(ItemLayerModel.getLayerRenderType(luminosity > 0), ItemTextureQuadConverter.convertTexture(transform, templateSprite, fluidSprite, 0.468625f, Direction.NORTH, color, 1, luminosity));
            builder.addQuads(ItemLayerModel.getLayerRenderType(luminosity > 0), ItemTextureQuadConverter.convertTexture(transform, templateSprite, fluidSprite, 0.531375f, Direction.SOUTH, color, 1, luminosity));
        }
        if (this.coverIsMask) {
            if (coverSprite != null && baseLocation != null) {
                TextureAtlasSprite baseSprite = spriteGetter.apply(baseLocation);
                builder.addQuads(ItemLayerModel.getLayerRenderType(false), ItemTextureQuadConverter.convertTexture(transform, coverSprite, baseSprite, 0.4685f, Direction.NORTH, -1, 2));
                builder.addQuads(ItemLayerModel.getLayerRenderType(false), ItemTextureQuadConverter.convertTexture(transform, coverSprite, baseSprite, 0.5315f, Direction.SOUTH, -1, 2));
            }
        } else if (coverSprite != null) {
            builder.addQuads(ItemLayerModel.getLayerRenderType(false), ItemTextureQuadConverter.genQuad(transform, 0.0f, 0.0f, 16.0f, 16.0f, 0.4685f, coverSprite, Direction.NORTH, -1, 2));
            builder.addQuads(ItemLayerModel.getLayerRenderType(false), ItemTextureQuadConverter.genQuad(transform, 0.0f, 0.0f, 16.0f, 16.0f, 0.5315f, coverSprite, Direction.SOUTH, -1, 2));
        }
        builder.setParticle(particleSprite);
        return builder.build();
    }

    @Override
    public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        HashSet texs = Sets.newHashSet();
        if (owner.isTexturePresent("particle")) {
            texs.add(owner.resolveTexture("particle"));
        }
        if (owner.isTexturePresent("base")) {
            texs.add(owner.resolveTexture("base"));
        }
        if (owner.isTexturePresent("fluid")) {
            texs.add(owner.resolveTexture("fluid"));
        }
        if (owner.isTexturePresent("cover")) {
            texs.add(owner.resolveTexture("cover"));
        }
        return texs;
    }

    private static final class ContainedFluidOverrideHandler
    extends ItemOverrides {
        private final Map<String, BakedModel> cache = Maps.newHashMap();
        private final ItemOverrides nested;
        private final ModelBakery bakery;
        private final IModelConfiguration owner;
        private final DynamicBucketModel parent;

        private ContainedFluidOverrideHandler(ItemOverrides nested, ModelBakery bakery, IModelConfiguration owner, DynamicBucketModel parent) {
            this.nested = nested;
            this.bakery = bakery;
            this.owner = owner;
            this.parent = parent;
        }

        public BakedModel m_173464_(BakedModel originalModel, ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity entity, int seed) {
            BakedModel overriden = this.nested.m_173464_(originalModel, stack, world, entity, seed);
            if (overriden != originalModel) {
                return overriden;
            }
            return FluidUtil.getFluidContained(stack).map(fluidStack -> {
                Fluid fluid = fluidStack.getFluid();
                String name = fluid.getRegistryName().toString();
                if (!this.cache.containsKey(name)) {
                    DynamicBucketModel unbaked = this.parent.withFluid(fluid);
                    BakedModel bakedModel = unbaked.bake(this.owner, this.bakery, ModelLoader.defaultTextureGetter(), (ModelState)BlockModelRotation.X0_Y0, this, new ResourceLocation("forge:bucket_override"));
                    this.cache.put(name, bakedModel);
                    return bakedModel;
                }
                return this.cache.get(name);
            }).orElse(originalModel);
        }
    }

    public static enum Loader implements IModelLoader<DynamicBucketModel>
    {
        INSTANCE;


        public void m_6213_(ResourceManager resourceManager) {
        }

        @Override
        public DynamicBucketModel read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            if (!modelContents.has("fluid")) {
                throw new RuntimeException("Bucket model requires 'fluid' value.");
            }
            ResourceLocation fluidName = new ResourceLocation(modelContents.get("fluid").getAsString());
            Fluid fluid = ForgeRegistries.FLUIDS.getValue(fluidName);
            boolean flip = false;
            if (modelContents.has("flipGas")) {
                flip = modelContents.get("flipGas").getAsBoolean();
            }
            boolean tint = true;
            if (modelContents.has("applyTint")) {
                tint = modelContents.get("applyTint").getAsBoolean();
            }
            boolean coverIsMask = true;
            if (modelContents.has("coverIsMask")) {
                coverIsMask = modelContents.get("coverIsMask").getAsBoolean();
            }
            boolean applyFluidLuminosity = true;
            if (modelContents.has("applyFluidLuminosity")) {
                applyFluidLuminosity = modelContents.get("applyFluidLuminosity").getAsBoolean();
            }
            return new DynamicBucketModel(fluid, flip, tint, coverIsMask, applyFluidLuminosity);
        }
    }
}

