/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Transformation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemModelGenerator;
import net.minecraft.client.renderer.block.model.ItemOverride;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.CompositeModel;
import net.minecraftforge.client.model.CompositeModelState;
import net.minecraftforge.client.model.DynamicBucketModel;
import net.minecraftforge.client.model.IModelBuilder;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.MultiLayerModel;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.SeparatePerspectiveModel;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import net.minecraftforge.client.model.geometry.ISimpleModelGeometry;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.common.model.TransformationHelper;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModLoader;

public class ModelLoaderRegistry {
    public static final String WHITE_TEXTURE = "forge:white";
    private static final ItemModelGenerator ITEM_MODEL_GENERATOR = new ItemModelGenerator();
    private static final Map<ResourceLocation, IModelLoader<?>> loaders = Maps.newHashMap();
    private static volatile boolean registryFrozen = false;
    private static final Pattern FILESYSTEM_PATH_TO_RESLOC = Pattern.compile("(?:.*[\\\\/]assets[\\\\/](?<namespace>[a-z_-]+)[\\\\/]textures[\\\\/])?(?<path>[a-z_\\\\/-]+)\\.png");

    public static void init() {
        ModelLoaderRegistry.registerLoader(new ResourceLocation("minecraft", "elements"), VanillaProxy.Loader.INSTANCE);
        ModelLoaderRegistry.registerLoader(new ResourceLocation("forge", "obj"), OBJLoader.INSTANCE);
        ModelLoaderRegistry.registerLoader(new ResourceLocation("forge", "bucket"), DynamicBucketModel.Loader.INSTANCE);
        ModelLoaderRegistry.registerLoader(new ResourceLocation("forge", "composite"), CompositeModel.Loader.INSTANCE);
        ModelLoaderRegistry.registerLoader(new ResourceLocation("forge", "multi-layer"), MultiLayerModel.Loader.INSTANCE);
        ModelLoaderRegistry.registerLoader(new ResourceLocation("forge", "item-layers"), ItemLayerModel.Loader.INSTANCE);
        ModelLoaderRegistry.registerLoader(new ResourceLocation("forge", "separate-perspective"), SeparatePerspectiveModel.Loader.INSTANCE);
    }

    public static void onModelLoadingStart() {
        if (!registryFrozen) {
            ModLoader.get().postEvent((Event)new ModelRegistryEvent());
            registryFrozen = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerLoader(ResourceLocation id, IModelLoader<?> loader) {
        if (registryFrozen) {
            throw new IllegalStateException("Can not register model loaders after models have started loading. Please use ModelRegistryEvent to register your loaders.");
        }
        Map<ResourceLocation, IModelLoader<?>> map = loaders;
        synchronized (map) {
            loaders.put(id, loader);
            ((ReloadableResourceManager)Minecraft.m_91087_().m_91098_()).m_7217_(loader);
        }
    }

    public static IModelGeometry<?> getModel(ResourceLocation loaderId, JsonDeserializationContext deserializationContext, JsonObject data) {
        try {
            if (!loaders.containsKey(loaderId)) {
                throw new IllegalStateException(String.format("Model loader '%s' not found. Registered loaders: %s", loaderId, loaders.keySet().stream().map(ResourceLocation::toString).collect(Collectors.joining(", "))));
            }
            IModelLoader<?> loader = loaders.get(loaderId);
            return loader.read(deserializationContext, data);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    @Nullable
    public static IModelGeometry<?> deserializeGeometry(JsonDeserializationContext deserializationContext, JsonObject object) {
        if (!object.has("loader")) {
            return null;
        }
        ResourceLocation loader = new ResourceLocation(GsonHelper.m_13906_((JsonObject)object, (String)"loader"));
        return ModelLoaderRegistry.getModel(loader, deserializationContext, object);
    }

    public static Material resolveTexture(@Nullable String tex, IModelConfiguration owner) {
        if (tex == null) {
            return ModelLoaderRegistry.blockMaterial(WHITE_TEXTURE);
        }
        if (tex.startsWith("#")) {
            return owner.resolveTexture(tex);
        }
        Matcher match = FILESYSTEM_PATH_TO_RESLOC.matcher(tex);
        if (match.matches()) {
            String namespace = match.group("namespace");
            String path = match.group("path").replace("\\", "/");
            if (namespace != null) {
                return ModelLoaderRegistry.blockMaterial(new ResourceLocation(namespace, path));
            }
            return ModelLoaderRegistry.blockMaterial(path);
        }
        return ModelLoaderRegistry.blockMaterial(tex);
    }

    public static Material blockMaterial(String location) {
        return new Material(TextureAtlas.f_118259_, new ResourceLocation(location));
    }

    public static Material blockMaterial(ResourceLocation location) {
        return new Material(TextureAtlas.f_118259_, location);
    }

    @Nullable
    public static ModelState deserializeModelTransforms(JsonDeserializationContext deserializationContext, JsonObject modelData) {
        if (!modelData.has("transform")) {
            return null;
        }
        return ModelLoaderRegistry.deserializeTransform(deserializationContext, modelData.get("transform")).orElse(null);
    }

    public static Optional<ModelState> deserializeTransform(JsonDeserializationContext context, JsonElement transformData) {
        if (!transformData.isJsonObject()) {
            try {
                Transformation base = (Transformation)context.deserialize(transformData, Transformation.class);
                return Optional.of(new SimpleModelState(ImmutableMap.of(), base.blockCenterToCorner()));
            }
            catch (JsonParseException e) {
                throw new JsonParseException("transform: expected a string, object or valid base transformation, got: " + transformData);
            }
        }
        JsonObject transform = transformData.getAsJsonObject();
        EnumMap transforms = Maps.newEnumMap(ItemTransforms.TransformType.class);
        ModelLoaderRegistry.deserializeTRSR(context, transforms, transform, "thirdperson", ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND);
        ModelLoaderRegistry.deserializeTRSR(context, transforms, transform, "thirdperson_righthand", ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND);
        ModelLoaderRegistry.deserializeTRSR(context, transforms, transform, "thirdperson_lefthand", ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND);
        ModelLoaderRegistry.deserializeTRSR(context, transforms, transform, "firstperson", ItemTransforms.TransformType.FIRST_PERSON_RIGHT_HAND);
        ModelLoaderRegistry.deserializeTRSR(context, transforms, transform, "firstperson_righthand", ItemTransforms.TransformType.FIRST_PERSON_RIGHT_HAND);
        ModelLoaderRegistry.deserializeTRSR(context, transforms, transform, "firstperson_lefthand", ItemTransforms.TransformType.FIRST_PERSON_LEFT_HAND);
        ModelLoaderRegistry.deserializeTRSR(context, transforms, transform, "head", ItemTransforms.TransformType.HEAD);
        ModelLoaderRegistry.deserializeTRSR(context, transforms, transform, "gui", ItemTransforms.TransformType.GUI);
        ModelLoaderRegistry.deserializeTRSR(context, transforms, transform, "ground", ItemTransforms.TransformType.GROUND);
        ModelLoaderRegistry.deserializeTRSR(context, transforms, transform, "fixed", ItemTransforms.TransformType.FIXED);
        int k = transform.entrySet().size();
        if (transform.has("matrix")) {
            --k;
        }
        if (transform.has("translation")) {
            --k;
        }
        if (transform.has("rotation")) {
            --k;
        }
        if (transform.has("scale")) {
            --k;
        }
        if (transform.has("post-rotation")) {
            --k;
        }
        if (transform.has("origin")) {
            --k;
        }
        if (k > 0) {
            throw new JsonParseException("transform: allowed keys: 'thirdperson', 'firstperson', 'gui', 'head', 'matrix', 'translation', 'rotation', 'scale', 'post-rotation', 'origin'");
        }
        Transformation base = Transformation.m_121093_();
        if (!transform.entrySet().isEmpty()) {
            base = (Transformation)context.deserialize((JsonElement)transform, Transformation.class);
        }
        SimpleModelState state = new SimpleModelState(Maps.immutableEnumMap((Map)transforms), base);
        return Optional.of(state);
    }

    private static void deserializeTRSR(JsonDeserializationContext context, EnumMap<ItemTransforms.TransformType, Transformation> transforms, JsonObject transform, String name, ItemTransforms.TransformType itemCameraTransform) {
        if (transform.has(name)) {
            Transformation t = (Transformation)context.deserialize(transform.remove(name), Transformation.class);
            transforms.put(itemCameraTransform, t.blockCenterToCorner());
        }
    }

    public static BakedModel bakeHelper(BlockModel blockModel, ModelBakery modelBakery, BlockModel otherModel, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ResourceLocation modelLocation, boolean guiLight3d) {
        IModelGeometry<?> customModel = blockModel.customData.getCustomGeometry();
        ModelState customModelState = blockModel.customData.getCustomModelState();
        if (customModelState != null) {
            modelTransform = new CompositeModelState(modelTransform, customModelState, modelTransform.m_7538_());
        }
        BakedModel model = customModel != null ? customModel.bake(blockModel.customData, modelBakery, spriteGetter, modelTransform, blockModel.getOverrides(modelBakery, otherModel, spriteGetter), modelLocation) : (blockModel.m_111490_() == ModelBakery.f_119232_ ? ITEM_MODEL_GENERATOR.m_111670_(spriteGetter, blockModel).m_111449_(modelBakery, blockModel, spriteGetter, modelTransform, modelLocation, guiLight3d) : blockModel.bakeVanilla(modelBakery, otherModel, spriteGetter, modelTransform, modelLocation, guiLight3d));
        if (customModelState != null && !model.doesHandlePerspectives()) {
            model = new PerspectiveMapWrapper(model, customModelState);
        }
        return model;
    }

    public static class VanillaProxy
    implements ISimpleModelGeometry<VanillaProxy> {
        private final List<BlockElement> elements;

        public VanillaProxy(List<BlockElement> list) {
            this.elements = list;
        }

        @Override
        public void addQuads(IModelConfiguration owner, IModelBuilder<?> modelBuilder, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ResourceLocation modelLocation) {
            for (BlockElement blockpart : this.elements) {
                for (Direction direction : blockpart.f_111310_.keySet()) {
                    BlockElementFace blockpartface = (BlockElementFace)blockpart.f_111310_.get(direction);
                    TextureAtlasSprite textureatlassprite1 = spriteGetter.apply(owner.resolveTexture(blockpartface.f_111356_));
                    if (blockpartface.f_111354_ == null) {
                        modelBuilder.addGeneralQuad(BlockModel.makeBakedQuad((BlockElement)blockpart, (BlockElementFace)blockpartface, (TextureAtlasSprite)textureatlassprite1, (Direction)direction, (ModelState)modelTransform, (ResourceLocation)modelLocation));
                        continue;
                    }
                    modelBuilder.addFaceQuad(modelTransform.m_6189_().rotateTransform(blockpartface.f_111354_), BlockModel.makeBakedQuad((BlockElement)blockpart, (BlockElementFace)blockpartface, (TextureAtlasSprite)textureatlassprite1, (Direction)direction, (ModelState)modelTransform, (ResourceLocation)modelLocation));
                }
            }
        }

        @Override
        public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
            HashSet textures = Sets.newHashSet();
            for (BlockElement part : this.elements) {
                for (BlockElementFace face : part.f_111310_.values()) {
                    Material texture = owner.resolveTexture(face.f_111356_);
                    if (Objects.equals(texture, MissingTextureAtlasSprite.m_118071_().toString())) {
                        missingTextureErrors.add((Pair<String, String>)Pair.of((Object)face.f_111356_, (Object)owner.getModelName()));
                    }
                    textures.add(texture);
                }
            }
            return textures;
        }

        public static class Loader
        implements IModelLoader<VanillaProxy> {
            public static final Loader INSTANCE = new Loader();

            private Loader() {
            }

            public void m_6213_(ResourceManager resourceManager) {
            }

            @Override
            public VanillaProxy read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
                List<BlockElement> list = this.getModelElements(deserializationContext, modelContents);
                return new VanillaProxy(list);
            }

            private List<BlockElement> getModelElements(JsonDeserializationContext deserializationContext, JsonObject object) {
                ArrayList list = Lists.newArrayList();
                if (object.has("elements")) {
                    for (JsonElement jsonelement : GsonHelper.m_13933_((JsonObject)object, (String)"elements")) {
                        list.add((BlockElement)deserializationContext.deserialize(jsonelement, BlockElement.class));
                    }
                }
                return list;
            }
        }
    }

    public static class ExpandedBlockModelDeserializer
    extends BlockModel.Deserializer {
        public static final Gson INSTANCE = new GsonBuilder().registerTypeAdapter(BlockModel.class, (Object)new ExpandedBlockModelDeserializer()).registerTypeAdapter(BlockElement.class, (Object)new BlockElement.Deserializer()).registerTypeAdapter(BlockElementFace.class, (Object)new BlockElementFace.Deserializer()).registerTypeAdapter(BlockFaceUV.class, (Object)new BlockFaceUV.Deserializer()).registerTypeAdapter(ItemTransform.class, (Object)new ItemTransform.Deserializer()).registerTypeAdapter(ItemTransforms.class, (Object)new ItemTransforms.Deserializer()).registerTypeAdapter(ItemOverride.class, (Object)new ItemOverride.Deserializer()).registerTypeAdapter(Transformation.class, (Object)new TransformationHelper.Deserializer()).create();

        public BlockModel deserialize(JsonElement element, Type targetType, JsonDeserializationContext deserializationContext) throws JsonParseException {
            ModelState modelState;
            BlockModel model = super.deserialize(element, targetType, deserializationContext);
            JsonObject jsonobject = element.getAsJsonObject();
            IModelGeometry<?> geometry = ModelLoaderRegistry.deserializeGeometry(deserializationContext, jsonobject);
            List elements = model.m_111436_();
            if (geometry != null) {
                elements.clear();
                model.customData.setCustomGeometry(geometry);
            }
            if ((modelState = ModelLoaderRegistry.deserializeModelTransforms(deserializationContext, jsonobject)) != null) {
                model.customData.setCustomModelState(modelState);
            }
            if (jsonobject.has("visibility")) {
                JsonObject visibility = GsonHelper.m_13930_((JsonObject)jsonobject, (String)"visibility");
                for (Map.Entry part : visibility.entrySet()) {
                    model.customData.visibilityData.setVisibilityState((String)part.getKey(), ((JsonElement)part.getValue()).getAsBoolean());
                }
            }
            return model;
        }
    }
}

