/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.b3d;

import com.google.common.collect.ImmutableSet;
import com.mojang.math.Transformation;
import net.minecraftforge.client.model.b3d.B3DLoader;
import net.minecraftforge.client.model.b3d.B3DModel;
import net.minecraftforge.common.animation.Event;
import net.minecraftforge.common.model.TransformationHelper;
import net.minecraftforge.common.model.animation.IClip;
import net.minecraftforge.common.model.animation.IJoint;
import net.minecraftforge.common.model.animation.IJointClip;
import net.minecraftforge.common.model.animation.JointClips;

public enum B3DClip implements IClip
{
    INSTANCE;


    @Override
    public IJointClip apply(IJoint joint) {
        if (!(joint instanceof B3DLoader.NodeJoint)) {
            return JointClips.IdentityJointClip.INSTANCE;
        }
        return new NodeClip(((B3DLoader.NodeJoint)joint).getNode());
    }

    @Override
    public Iterable<Event> pastEvents(float lastPollTime, float time) {
        return ImmutableSet.of();
    }

    protected static class NodeClip
    implements IJointClip {
        private final B3DModel.Node<?> node;

        public NodeClip(B3DModel.Node<?> node) {
            this.node = node;
        }

        @Override
        public Transformation apply(float time) {
            Transformation endTr;
            Transformation ret = Transformation.m_121093_();
            if (this.node.getAnimation() == null) {
                return ret.m_121096_(new Transformation(this.node.getPos(), this.node.getRot(), this.node.getScale(), null));
            }
            int start = Math.max(1, (int)Math.round(Math.floor(time)));
            int end = Math.min(start + 1, (int)Math.round(Math.ceil(time)));
            float progress = time - (float)Math.floor(time);
            B3DModel.Key keyStart = (B3DModel.Key)this.node.getAnimation().getKeys().get((Object)start, this.node);
            B3DModel.Key keyEnd = (B3DModel.Key)this.node.getAnimation().getKeys().get((Object)end, this.node);
            Transformation startTr = keyStart == null ? null : new Transformation(keyStart.getPos(), keyStart.getRot(), keyStart.getScale(), null);
            Transformation transformation = endTr = keyEnd == null ? null : new Transformation(keyEnd.getPos(), keyEnd.getRot(), keyEnd.getScale(), null);
            ret = keyStart == null ? (keyEnd == null ? ret.m_121096_(new Transformation(this.node.getPos(), this.node.getRot(), this.node.getScale(), null)) : ret.m_121096_(endTr)) : ((double)progress < 1.0E-5 || keyEnd == null ? ret.m_121096_(startTr) : ret.m_121096_(TransformationHelper.slerp(startTr, endTr, progress)));
            return ret;
        }
    }
}

