/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.obj;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import com.mojang.math.Transformation;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import joptsimple.internal.Strings;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.client.model.IModelBuilder;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.geometry.IModelGeometryPart;
import net.minecraftforge.client.model.geometry.IMultipartModelGeometry;
import net.minecraftforge.client.model.obj.LineReader;
import net.minecraftforge.client.model.obj.MaterialLibrary;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.client.model.pipeline.BakedQuadBuilder;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import org.apache.commons.lang3.tuple.Pair;

public class OBJModel
implements IMultipartModelGeometry<OBJModel> {
    private static Vector4f COLOR_WHITE = new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
    private static Vec2[] DEFAULT_COORDS = new Vec2[]{new Vec2(0.0f, 0.0f), new Vec2(0.0f, 1.0f), new Vec2(1.0f, 1.0f), new Vec2(1.0f, 0.0f)};
    private final Map<String, ModelGroup> parts = Maps.newHashMap();
    private final List<Vector3f> positions = Lists.newArrayList();
    private final List<Vec2> texCoords = Lists.newArrayList();
    private final List<Vector3f> normals = Lists.newArrayList();
    private final List<Vector4f> colors = Lists.newArrayList();
    public final boolean detectCullableFaces;
    public final boolean diffuseLighting;
    public final boolean flipV;
    public final boolean ambientToFullbright;
    public final ResourceLocation modelLocation;
    @Nullable
    public final String materialLibraryOverrideLocation;

    OBJModel(LineReader reader, ModelSettings settings) throws IOException {
        String[] line;
        this.modelLocation = settings.modelLocation;
        this.detectCullableFaces = settings.detectCullableFaces;
        this.diffuseLighting = settings.diffuseLighting;
        this.flipV = settings.flipV;
        this.ambientToFullbright = settings.ambientToFullbright;
        this.materialLibraryOverrideLocation = settings.materialLibraryOverrideLocation;
        String modelDomain = this.modelLocation.m_135827_();
        String modelPath = this.modelLocation.m_135815_();
        int lastSlash = modelPath.lastIndexOf(47);
        modelPath = lastSlash >= 0 ? modelPath.substring(0, lastSlash + 1) : "";
        MaterialLibrary mtllib = MaterialLibrary.EMPTY;
        MaterialLibrary.Material currentMat = null;
        String currentSmoothingGroup = null;
        ModelObject currentGroup = null;
        ModelObject currentObject = null;
        ModelMesh currentMesh = null;
        boolean objAboveGroup = false;
        if (this.materialLibraryOverrideLocation != null) {
            String lib = this.materialLibraryOverrideLocation;
            mtllib = lib.contains(":") ? OBJLoader.INSTANCE.loadMaterialLibrary(new ResourceLocation(lib)) : OBJLoader.INSTANCE.loadMaterialLibrary(new ResourceLocation(modelDomain, modelPath + lib));
        }
        while ((line = reader.readAndSplitLine(true)) != null) {
            switch (line[0]) {
                case "mtllib": {
                    if (this.materialLibraryOverrideLocation != null) break;
                    String lib = line[1];
                    if (lib.contains(":")) {
                        mtllib = OBJLoader.INSTANCE.loadMaterialLibrary(new ResourceLocation(lib));
                        break;
                    }
                    mtllib = OBJLoader.INSTANCE.loadMaterialLibrary(new ResourceLocation(modelDomain, modelPath + lib));
                    break;
                }
                case "usemtl": {
                    String mat = Strings.join((String[])Arrays.copyOfRange(line, 1, line.length), (String)" ");
                    MaterialLibrary.Material newMat = mtllib.getMaterial(mat);
                    if (Objects.equals(newMat, currentMat)) break;
                    currentMat = newMat;
                    if (currentMesh != null && currentMesh.mat == null && currentMesh.faces.size() == 0) {
                        currentMesh.mat = currentMat;
                        break;
                    }
                    currentMesh = null;
                    break;
                }
                case "v": {
                    this.positions.add(OBJModel.parseVector4To3(line));
                    break;
                }
                case "vt": {
                    this.texCoords.add(OBJModel.parseVector2(line));
                    break;
                }
                case "vn": {
                    this.normals.add(OBJModel.parseVector3(line));
                    break;
                }
                case "vc": {
                    this.colors.add(OBJModel.parseVector4(line));
                    break;
                }
                case "f": {
                    if (currentMesh == null) {
                        currentMesh = new ModelMesh(currentMat, currentSmoothingGroup);
                        if (currentObject != null) {
                            currentObject.meshes.add(currentMesh);
                        } else {
                            if (currentGroup == null) {
                                currentGroup = new ModelGroup("");
                                this.parts.put("", (ModelGroup)currentGroup);
                            }
                            ((ModelGroup)currentGroup).meshes.add(currentMesh);
                        }
                    }
                    int[][] vertices = new int[line.length - 1][];
                    for (int i = 0; i < vertices.length; ++i) {
                        String vertexData = line[i + 1];
                        String[] vertexParts = vertexData.split("/");
                        int[] vertex = Arrays.stream(vertexParts).mapToInt(num -> Strings.isNullOrEmpty((String)num) ? 0 : Integer.parseInt(num)).toArray();
                        vertex[0] = vertex[0] < 0 ? this.positions.size() + vertex[0] : vertex[0] - 1;
                        if (vertex.length > 1) {
                            vertex[1] = vertex[1] < 0 ? this.texCoords.size() + vertex[1] : vertex[1] - 1;
                            if (vertex.length > 2) {
                                vertex[2] = vertex[2] < 0 ? this.normals.size() + vertex[2] : vertex[2] - 1;
                                if (vertex.length > 3) {
                                    vertex[3] = vertex[3] < 0 ? this.colors.size() + vertex[3] : vertex[3] - 1;
                                }
                            }
                        }
                        vertices[i] = vertex;
                    }
                    currentMesh.faces.add(vertices);
                    break;
                }
                case "s": {
                    String smoothingGroup;
                    String string = smoothingGroup = "off".equals(line[1]) ? null : line[1];
                    if (Objects.equals(currentSmoothingGroup, smoothingGroup)) break;
                    currentSmoothingGroup = smoothingGroup;
                    if (currentMesh != null && currentMesh.smoothingGroup == null && currentMesh.faces.size() == 0) {
                        currentMesh.smoothingGroup = currentSmoothingGroup;
                        break;
                    }
                    currentMesh = null;
                    break;
                }
                case "g": {
                    String name = line[1];
                    if (objAboveGroup) {
                        currentObject = new ModelObject(currentGroup.name() + "/" + name);
                        ((ModelGroup)currentGroup).parts.put(name, currentObject);
                    } else {
                        currentGroup = new ModelGroup(name);
                        this.parts.put(name, (ModelGroup)currentGroup);
                        currentObject = null;
                    }
                    currentMesh = null;
                    break;
                }
                case "o": {
                    String name = line[1];
                    if (objAboveGroup || currentGroup == null) {
                        objAboveGroup = true;
                        currentGroup = new ModelGroup(name);
                        this.parts.put(name, (ModelGroup)currentGroup);
                        currentObject = null;
                    } else {
                        currentObject = new ModelObject(currentGroup.name() + "/" + name);
                        ((ModelGroup)currentGroup).parts.put(name, currentObject);
                    }
                    currentMesh = null;
                    break;
                }
            }
        }
    }

    public static Vector3f parseVector4To3(String[] line) {
        switch (line.length) {
            case 1: {
                return new Vector3f(0.0f, 0.0f, 0.0f);
            }
            case 2: {
                return new Vector3f(Float.parseFloat(line[1]), 0.0f, 0.0f);
            }
            case 3: {
                return new Vector3f(Float.parseFloat(line[1]), Float.parseFloat(line[2]), 0.0f);
            }
            case 4: {
                return new Vector3f(Float.parseFloat(line[1]), Float.parseFloat(line[2]), Float.parseFloat(line[3]));
            }
        }
        Vector4f vec4 = OBJModel.parseVector4(line);
        return new Vector3f(vec4.m_123601_() / vec4.m_123617_(), vec4.m_123615_() / vec4.m_123617_(), vec4.m_123616_() / vec4.m_123617_());
    }

    public static Vec2 parseVector2(String[] line) {
        switch (line.length) {
            case 1: {
                return new Vec2(0.0f, 0.0f);
            }
            case 2: {
                return new Vec2(Float.parseFloat(line[1]), 0.0f);
            }
        }
        return new Vec2(Float.parseFloat(line[1]), Float.parseFloat(line[2]));
    }

    public static Vector3f parseVector3(String[] line) {
        switch (line.length) {
            case 1: {
                return new Vector3f(0.0f, 0.0f, 0.0f);
            }
            case 2: {
                return new Vector3f(Float.parseFloat(line[1]), 0.0f, 0.0f);
            }
            case 3: {
                return new Vector3f(Float.parseFloat(line[1]), Float.parseFloat(line[2]), 0.0f);
            }
        }
        return new Vector3f(Float.parseFloat(line[1]), Float.parseFloat(line[2]), Float.parseFloat(line[3]));
    }

    public static Vector4f parseVector4(String[] line) {
        switch (line.length) {
            case 1: {
                return new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
            }
            case 2: {
                return new Vector4f(Float.parseFloat(line[1]), 0.0f, 0.0f, 1.0f);
            }
            case 3: {
                return new Vector4f(Float.parseFloat(line[1]), Float.parseFloat(line[2]), 0.0f, 1.0f);
            }
            case 4: {
                return new Vector4f(Float.parseFloat(line[1]), Float.parseFloat(line[2]), Float.parseFloat(line[3]), 1.0f);
            }
        }
        return new Vector4f(Float.parseFloat(line[1]), Float.parseFloat(line[2]), Float.parseFloat(line[3]), Float.parseFloat(line[4]));
    }

    @Override
    public Collection<? extends IModelGeometryPart> getParts() {
        return this.parts.values();
    }

    @Override
    public Optional<? extends IModelGeometryPart> getPart(String name) {
        return Optional.ofNullable(this.parts.get(name));
    }

    private Pair<BakedQuad, Direction> makeQuad(int[][] indices, int tintIndex, Vector4f colorTint, Vector4f ambientColor, TextureAtlasSprite texture, Transformation transform) {
        boolean needsNormalRecalculation = false;
        for (int[] ints : indices) {
            needsNormalRecalculation |= ints.length < 3;
        }
        Vector3f faceNormal = new Vector3f(0.0f, 0.0f, 0.0f);
        if (needsNormalRecalculation) {
            Vector3f a = this.positions.get(indices[0][0]);
            Vector3f ab = this.positions.get(indices[1][0]);
            Vector3f ac = this.positions.get(indices[2][0]);
            Vector3f abs = ab.m_122281_();
            abs.m_122267_(a);
            Vector3f acs = ac.m_122281_();
            acs.m_122267_(a);
            abs.m_122279_(acs);
            abs.m_122278_();
            faceNormal = abs;
        }
        Vector4f[] pos = new Vector4f[4];
        Vector3f[] norm = new Vector3f[4];
        BakedQuadBuilder builder = new BakedQuadBuilder(texture);
        builder.setQuadTint(tintIndex);
        Vec2 uv2 = new Vec2(0.0f, 0.0f);
        if (this.ambientToFullbright) {
            int fakeLight = (int)((ambientColor.m_123601_() + ambientColor.m_123615_() + ambientColor.m_123616_()) * 15.0f / 3.0f);
            uv2 = new Vec2((float)(fakeLight << 4) / 32767.0f, (float)(fakeLight << 4) / 32767.0f);
            builder.setApplyDiffuseLighting(fakeLight == 0);
        } else {
            builder.setApplyDiffuseLighting(this.diffuseLighting);
        }
        boolean hasTransform = !transform.isIdentity();
        Transformation transformation = hasTransform ? transform.blockCenterToCorner() : transform;
        for (int i = 0; i < 4; ++i) {
            Vector4f color;
            Vector3f norm0;
            int[] index = indices[Math.min(i, indices.length - 1)];
            Vector3f pos0 = this.positions.get(index[0]);
            Vector4f position = new Vector4f(pos0);
            Vec2 texCoord = index.length >= 2 && this.texCoords.size() > 0 ? this.texCoords.get(index[1]) : DEFAULT_COORDS[i];
            Vector3f normal = norm0 = !needsNormalRecalculation && index.length >= 3 && this.normals.size() > 0 ? this.normals.get(index[2]) : faceNormal;
            Vector4f vector4f = color = index.length >= 4 && this.colors.size() > 0 ? this.colors.get(index[3]) : COLOR_WHITE;
            if (hasTransform) {
                normal = norm0.m_122281_();
                transformation.transformPosition(position);
                transformation.transformNormal(normal);
            }
            Vector4f tintedColor = new Vector4f(color.m_123601_() * colorTint.m_123601_(), color.m_123615_() * colorTint.m_123615_(), color.m_123616_() * colorTint.m_123616_(), color.m_123617_() * colorTint.m_123617_());
            this.putVertexData(builder, position, texCoord, normal, tintedColor, uv2, texture);
            pos[i] = position;
            norm[i] = normal;
        }
        builder.setQuadOrientation(Direction.m_122372_((float)norm[0].m_122239_(), (float)norm[0].m_122260_(), (float)norm[0].m_122269_()));
        Direction cull = null;
        if (this.detectCullableFaces) {
            if (Mth.m_14033_((float)pos[0].m_123601_(), (float)0.0f) && Mth.m_14033_((float)pos[1].m_123601_(), (float)0.0f) && Mth.m_14033_((float)pos[2].m_123601_(), (float)0.0f) && Mth.m_14033_((float)pos[3].m_123601_(), (float)0.0f) && norm[0].m_122239_() < 0.0f) {
                cull = Direction.WEST;
            } else if (Mth.m_14033_((float)pos[0].m_123601_(), (float)1.0f) && Mth.m_14033_((float)pos[1].m_123601_(), (float)1.0f) && Mth.m_14033_((float)pos[2].m_123601_(), (float)1.0f) && Mth.m_14033_((float)pos[3].m_123601_(), (float)1.0f) && norm[0].m_122239_() > 0.0f) {
                cull = Direction.EAST;
            } else if (Mth.m_14033_((float)pos[0].m_123616_(), (float)0.0f) && Mth.m_14033_((float)pos[1].m_123616_(), (float)0.0f) && Mth.m_14033_((float)pos[2].m_123616_(), (float)0.0f) && Mth.m_14033_((float)pos[3].m_123616_(), (float)0.0f) && norm[0].m_122269_() < 0.0f) {
                cull = Direction.NORTH;
            } else if (Mth.m_14033_((float)pos[0].m_123616_(), (float)1.0f) && Mth.m_14033_((float)pos[1].m_123616_(), (float)1.0f) && Mth.m_14033_((float)pos[2].m_123616_(), (float)1.0f) && Mth.m_14033_((float)pos[3].m_123616_(), (float)1.0f) && norm[0].m_122269_() > 0.0f) {
                cull = Direction.SOUTH;
            } else if (Mth.m_14033_((float)pos[0].m_123615_(), (float)0.0f) && Mth.m_14033_((float)pos[1].m_123615_(), (float)0.0f) && Mth.m_14033_((float)pos[2].m_123615_(), (float)0.0f) && Mth.m_14033_((float)pos[3].m_123615_(), (float)0.0f) && norm[0].m_122260_() < 0.0f) {
                cull = Direction.DOWN;
            } else if (Mth.m_14033_((float)pos[0].m_123615_(), (float)1.0f) && Mth.m_14033_((float)pos[1].m_123615_(), (float)1.0f) && Mth.m_14033_((float)pos[2].m_123615_(), (float)1.0f) && Mth.m_14033_((float)pos[3].m_123615_(), (float)1.0f) && norm[0].m_122260_() > 0.0f) {
                cull = Direction.UP;
            }
        }
        return Pair.of((Object)builder.build(), cull);
    }

    private void putVertexData(IVertexConsumer consumer, Vector4f position0, Vec2 texCoord0, Vector3f normal0, Vector4f color0, Vec2 uv2, TextureAtlasSprite texture) {
        ImmutableList elements = consumer.getVertexFormat().m_86023_();
        block10: for (int j = 0; j < elements.size(); ++j) {
            VertexFormatElement e = (VertexFormatElement)elements.get(j);
            switch (e.m_86048_()) {
                case POSITION: {
                    consumer.put(j, position0.m_123601_(), position0.m_123615_(), position0.m_123616_(), position0.m_123617_());
                    continue block10;
                }
                case COLOR: {
                    consumer.put(j, color0.m_123601_(), color0.m_123615_(), color0.m_123616_(), color0.m_123617_());
                    continue block10;
                }
                case UV: {
                    switch (e.m_86049_()) {
                        case 0: {
                            consumer.put(j, texture.m_118367_((double)(texCoord0.f_82470_ * 16.0f)), texture.m_118393_((double)((this.flipV ? 1.0f - texCoord0.f_82471_ : texCoord0.f_82471_) * 16.0f)));
                            continue block10;
                        }
                        case 2: {
                            consumer.put(j, uv2.f_82470_, uv2.f_82471_);
                            continue block10;
                        }
                    }
                    consumer.put(j, new float[0]);
                    continue block10;
                }
                case NORMAL: {
                    consumer.put(j, normal0.m_122239_(), normal0.m_122260_(), normal0.m_122269_());
                    continue block10;
                }
                default: {
                    consumer.put(j, new float[0]);
                }
            }
        }
    }

    public static class ModelSettings {
        @Nonnull
        public final ResourceLocation modelLocation;
        public final boolean detectCullableFaces;
        public final boolean diffuseLighting;
        public final boolean flipV;
        public final boolean ambientToFullbright;
        @Nullable
        public final String materialLibraryOverrideLocation;

        public ModelSettings(@Nonnull ResourceLocation modelLocation, boolean detectCullableFaces, boolean diffuseLighting, boolean flipV, boolean ambientToFullbright, @Nullable String materialLibraryOverrideLocation) {
            this.modelLocation = modelLocation;
            this.detectCullableFaces = detectCullableFaces;
            this.diffuseLighting = diffuseLighting;
            this.flipV = flipV;
            this.ambientToFullbright = ambientToFullbright;
            this.materialLibraryOverrideLocation = materialLibraryOverrideLocation;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ModelSettings that = (ModelSettings)o;
            return this.equals(that);
        }

        public boolean equals(@Nonnull ModelSettings that) {
            return this.detectCullableFaces == that.detectCullableFaces && this.diffuseLighting == that.diffuseLighting && this.flipV == that.flipV && this.ambientToFullbright == that.ambientToFullbright && this.modelLocation.equals((Object)that.modelLocation) && Objects.equals(this.materialLibraryOverrideLocation, that.materialLibraryOverrideLocation);
        }

        public int hashCode() {
            return Objects.hash(this.modelLocation, this.detectCullableFaces, this.diffuseLighting, this.flipV, this.ambientToFullbright, this.materialLibraryOverrideLocation);
        }
    }

    private class ModelMesh {
        @Nullable
        public MaterialLibrary.Material mat;
        @Nullable
        public String smoothingGroup;
        public final List<int[][]> faces = Lists.newArrayList();

        public ModelMesh(@Nullable MaterialLibrary.Material currentMat, String currentSmoothingGroup) {
            this.mat = currentMat;
            this.smoothingGroup = currentSmoothingGroup;
        }
    }

    public class ModelObject
    implements IModelGeometryPart {
        public final String name;
        List<ModelMesh> meshes = Lists.newArrayList();

        ModelObject(String name) {
            this.name = name;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public void addQuads(IModelConfiguration owner, IModelBuilder<?> modelBuilder, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ResourceLocation modelLocation) {
            for (ModelMesh mesh : this.meshes) {
                MaterialLibrary.Material mat = mesh.mat;
                if (mat == null) continue;
                TextureAtlasSprite texture = spriteGetter.apply(ModelLoaderRegistry.resolveTexture(mat.diffuseColorMap, owner));
                int tintIndex = mat.diffuseTintIndex;
                Vector4f colorTint = mat.diffuseColor;
                for (int[][] face : mesh.faces) {
                    Pair<BakedQuad, Direction> quad = OBJModel.this.makeQuad(face, tintIndex, colorTint, mat.ambientColor, texture, modelTransform.m_6189_());
                    if (quad.getRight() == null) {
                        modelBuilder.addGeneralQuad((BakedQuad)quad.getLeft());
                        continue;
                    }
                    modelBuilder.addFaceQuad((Direction)quad.getRight(), (BakedQuad)quad.getLeft());
                }
            }
        }

        @Override
        public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<com.mojang.datafixers.util.Pair<String, String>> missingTextureErrors) {
            return this.meshes.stream().map(mesh -> ModelLoaderRegistry.resolveTexture(mesh.mat.diffuseColorMap, owner)).collect(Collectors.toSet());
        }
    }

    public class ModelGroup
    extends ModelObject {
        final Map<String, ModelObject> parts;

        ModelGroup(String name) {
            super(name);
            this.parts = Maps.newHashMap();
        }

        public Collection<? extends IModelGeometryPart> getParts() {
            return this.parts.values();
        }

        @Override
        public void addQuads(IModelConfiguration owner, IModelBuilder<?> modelBuilder, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ResourceLocation modelLocation) {
            super.addQuads(owner, modelBuilder, bakery, spriteGetter, modelTransform, modelLocation);
            this.getParts().stream().filter(part -> owner.getPartVisibility((IModelGeometryPart)part)).forEach(part -> part.addQuads(owner, modelBuilder, bakery, spriteGetter, modelTransform, modelLocation));
        }

        @Override
        public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<com.mojang.datafixers.util.Pair<String, String>> missingTextureErrors) {
            HashSet combined = Sets.newHashSet();
            combined.addAll(super.getTextures(owner, modelGetter, missingTextureErrors));
            for (IModelGeometryPart iModelGeometryPart : this.getParts()) {
                combined.addAll(iModelGeometryPart.getTextures(owner, modelGetter, missingTextureErrors));
            }
            return combined;
        }
    }
}

