/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import com.google.common.collect.ImmutableList;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BiomeDictionary {
    private static final boolean DEBUG = false;
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<ResourceKey<Biome>, BiomeInfo> biomeInfoMap = new HashMap<ResourceKey<Biome>, BiomeInfo>();

    public static void init() {
    }

    public static void addTypes(ResourceKey<Biome> biome, Type ... types) {
        Collection<Type> supertypes = BiomeDictionary.listSupertypes(types);
        Collections.addAll(supertypes, types);
        for (Type type : supertypes) {
            type.biomes.add(biome);
        }
        BiomeInfo biomeInfo = BiomeDictionary.getBiomeInfo(biome);
        Collections.addAll(biomeInfo.types, types);
        biomeInfo.types.addAll(supertypes);
    }

    @Nonnull
    public static Set<ResourceKey<Biome>> getBiomes(Type type) {
        return type.biomesUn;
    }

    @Nonnull
    public static Set<Type> getTypes(ResourceKey<Biome> biome) {
        return BiomeDictionary.getBiomeInfo(biome).typesUn;
    }

    public static boolean areSimilar(ResourceKey<Biome> biomeA, ResourceKey<Biome> biomeB) {
        Set<Type> typesA = BiomeDictionary.getTypes(biomeA);
        Set<Type> typesB = BiomeDictionary.getTypes(biomeB);
        return typesA.stream().anyMatch(typesB::contains);
    }

    public static boolean hasType(ResourceKey<Biome> biome, Type type) {
        return BiomeDictionary.getTypes(biome).contains(type);
    }

    public static boolean hasAnyType(ResourceKey<Biome> biome) {
        return !BiomeDictionary.getBiomeInfo(biome).types.isEmpty();
    }

    private static BiomeInfo getBiomeInfo(ResourceKey<Biome> biome) {
        return biomeInfoMap.computeIfAbsent(biome, k -> new BiomeInfo());
    }

    private static Collection<Type> listSupertypes(Type ... types) {
        HashSet<Type> supertypes = new HashSet<Type>();
        ArrayDeque<Type> next = new ArrayDeque<Type>();
        Collections.addAll(next, types);
        while (!next.isEmpty()) {
            Type type = (Type)next.remove();
            for (Type sType : Type.byName.values()) {
                if (!sType.subTypes.contains(type) || !supertypes.add(sType)) continue;
                next.add(sType);
            }
        }
        return supertypes;
    }

    private static void registerVanillaBiomes() {
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48174_, Type.OCEAN, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48202_, Type.PLAINS, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48203_, Type.HOT, Type.DRY, Type.SANDY, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48204_, Type.MOUNTAIN, Type.HILLS, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48205_, Type.FOREST, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48206_, Type.COLD, Type.CONIFEROUS, Type.FOREST, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48207_, Type.WET, Type.SWAMP, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48208_, Type.RIVER, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48209_, Type.HOT, Type.DRY, Type.NETHER);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48210_, Type.COLD, Type.DRY, Type.END);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48211_, Type.COLD, Type.OCEAN, Type.SNOWY, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48212_, Type.COLD, Type.RIVER, Type.SNOWY, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48213_, Type.COLD, Type.SNOWY, Type.WASTELAND, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48214_, Type.COLD, Type.SNOWY, Type.MOUNTAIN, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48215_, Type.MUSHROOM, Type.RARE, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48216_, Type.MUSHROOM, Type.BEACH, Type.RARE, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48217_, Type.BEACH, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48218_, Type.HOT, Type.DRY, Type.SANDY, Type.HILLS, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48219_, Type.FOREST, Type.HILLS, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48220_, Type.COLD, Type.CONIFEROUS, Type.FOREST, Type.HILLS, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48221_, Type.MOUNTAIN, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48222_, Type.HOT, Type.WET, Type.DENSE, Type.JUNGLE, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48223_, Type.HOT, Type.WET, Type.DENSE, Type.JUNGLE, Type.HILLS, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48224_, Type.HOT, Type.WET, Type.JUNGLE, Type.FOREST, Type.RARE, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48225_, Type.OCEAN, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48226_, Type.BEACH, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48148_, Type.COLD, Type.BEACH, Type.SNOWY, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48149_, Type.FOREST, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48150_, Type.FOREST, Type.HILLS, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48151_, Type.SPOOKY, Type.DENSE, Type.FOREST, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48152_, Type.COLD, Type.CONIFEROUS, Type.FOREST, Type.SNOWY, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48153_, Type.COLD, Type.CONIFEROUS, Type.FOREST, Type.SNOWY, Type.HILLS, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48154_, Type.COLD, Type.CONIFEROUS, Type.FOREST, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48155_, Type.COLD, Type.CONIFEROUS, Type.FOREST, Type.HILLS, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48156_, Type.MOUNTAIN, Type.FOREST, Type.SPARSE, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48157_, Type.HOT, Type.SAVANNA, Type.PLAINS, Type.SPARSE, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48158_, Type.HOT, Type.SAVANNA, Type.PLAINS, Type.SPARSE, Type.RARE, Type.OVERWORLD, Type.PLATEAU);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48159_, Type.MESA, Type.SANDY, Type.DRY, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48160_, Type.MESA, Type.SANDY, Type.DRY, Type.SPARSE, Type.OVERWORLD, Type.PLATEAU);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48161_, Type.MESA, Type.SANDY, Type.DRY, Type.OVERWORLD, Type.PLATEAU);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48162_, Type.END);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48163_, Type.END);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48164_, Type.END);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48165_, Type.END);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48166_, Type.OCEAN, Type.HOT, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48167_, Type.OCEAN, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48168_, Type.OCEAN, Type.COLD, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48169_, Type.OCEAN, Type.HOT, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48170_, Type.OCEAN, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48171_, Type.OCEAN, Type.COLD, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48172_, Type.OCEAN, Type.COLD, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48173_, Type.VOID);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48176_, Type.PLAINS, Type.RARE, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48177_, Type.HOT, Type.DRY, Type.SANDY, Type.RARE, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48178_, Type.MOUNTAIN, Type.SPARSE, Type.RARE, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48179_, Type.FOREST, Type.HILLS, Type.RARE, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48180_, Type.COLD, Type.CONIFEROUS, Type.FOREST, Type.MOUNTAIN, Type.RARE, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48181_, Type.WET, Type.SWAMP, Type.HILLS, Type.RARE, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48182_, Type.COLD, Type.SNOWY, Type.HILLS, Type.RARE, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48183_, Type.HOT, Type.WET, Type.DENSE, Type.JUNGLE, Type.MOUNTAIN, Type.RARE, Type.OVERWORLD, Type.MODIFIED);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48184_, Type.HOT, Type.SPARSE, Type.JUNGLE, Type.HILLS, Type.RARE, Type.OVERWORLD, Type.MODIFIED);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48185_, Type.FOREST, Type.DENSE, Type.HILLS, Type.RARE, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48186_, Type.FOREST, Type.DENSE, Type.MOUNTAIN, Type.RARE, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48187_, Type.SPOOKY, Type.DENSE, Type.FOREST, Type.MOUNTAIN, Type.RARE, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48188_, Type.COLD, Type.CONIFEROUS, Type.FOREST, Type.SNOWY, Type.MOUNTAIN, Type.RARE, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48189_, Type.DENSE, Type.FOREST, Type.RARE, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48190_, Type.DENSE, Type.FOREST, Type.HILLS, Type.RARE, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48191_, Type.MOUNTAIN, Type.SPARSE, Type.RARE, Type.OVERWORLD, Type.MODIFIED);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48192_, Type.HOT, Type.DRY, Type.SPARSE, Type.SAVANNA, Type.MOUNTAIN, Type.RARE, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48193_, Type.HOT, Type.DRY, Type.SPARSE, Type.SAVANNA, Type.HILLS, Type.RARE, Type.OVERWORLD, Type.PLATEAU);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48194_, Type.HOT, Type.DRY, Type.SPARSE, Type.MOUNTAIN, Type.RARE, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48195_, Type.HOT, Type.DRY, Type.SPARSE, Type.HILLS, Type.RARE, Type.OVERWORLD, Type.PLATEAU, Type.MODIFIED);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48196_, Type.HOT, Type.DRY, Type.SPARSE, Type.MOUNTAIN, Type.RARE, Type.OVERWORLD, Type.PLATEAU, Type.MODIFIED);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48197_, Type.HOT, Type.WET, Type.RARE, Type.JUNGLE, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48198_, Type.HOT, Type.WET, Type.RARE, Type.JUNGLE, Type.HILLS, Type.OVERWORLD);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48199_, Type.HOT, Type.DRY, Type.NETHER);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48200_, Type.HOT, Type.DRY, Type.NETHER, Type.FOREST);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48201_, Type.HOT, Type.DRY, Type.NETHER, Type.FOREST);
        BiomeDictionary.addTypes((ResourceKey<Biome>)Biomes.f_48175_, Type.HOT, Type.DRY, Type.NETHER);
    }

    private static /* synthetic */ ResourceKey lambda$registerVanillaBiomes$3(Biome b) {
        return ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)b.getRegistryName());
    }

    private static /* synthetic */ void lambda$registerVanillaBiomes$2(StringBuilder buf, String name, Type type) {
        buf.append("    ").append(type.name).append(": ").append(type.biomes.stream().map(ResourceKey::m_135782_).sorted((a, b) -> a.compareNamespaced(b)).map(Object::toString).collect(Collectors.joining(", "))).append('\n');
    }

    static {
        BiomeDictionary.registerVanillaBiomes();
    }

    public static final class Type {
        private static final Map<String, Type> byName = new TreeMap<String, Type>();
        private static Collection<Type> allTypes = Collections.unmodifiableCollection(byName.values());
        public static final Type HOT = new Type("HOT", new Type[0]);
        public static final Type COLD = new Type("COLD", new Type[0]);
        public static final Type SPARSE = new Type("SPARSE", new Type[0]);
        public static final Type DENSE = new Type("DENSE", new Type[0]);
        public static final Type WET = new Type("WET", new Type[0]);
        public static final Type DRY = new Type("DRY", new Type[0]);
        public static final Type SAVANNA = new Type("SAVANNA", new Type[0]);
        public static final Type CONIFEROUS = new Type("CONIFEROUS", new Type[0]);
        public static final Type JUNGLE = new Type("JUNGLE", new Type[0]);
        public static final Type SPOOKY = new Type("SPOOKY", new Type[0]);
        public static final Type DEAD = new Type("DEAD", new Type[0]);
        public static final Type LUSH = new Type("LUSH", new Type[0]);
        public static final Type MUSHROOM = new Type("MUSHROOM", new Type[0]);
        public static final Type MAGICAL = new Type("MAGICAL", new Type[0]);
        public static final Type RARE = new Type("RARE", new Type[0]);
        public static final Type PLATEAU = new Type("PLATEAU", new Type[0]);
        public static final Type MODIFIED = new Type("MODIFIED", new Type[0]);
        public static final Type OCEAN = new Type("OCEAN", new Type[0]);
        public static final Type RIVER = new Type("RIVER", new Type[0]);
        public static final Type WATER = new Type("WATER", OCEAN, RIVER);
        public static final Type MESA = new Type("MESA", new Type[0]);
        public static final Type FOREST = new Type("FOREST", new Type[0]);
        public static final Type PLAINS = new Type("PLAINS", new Type[0]);
        public static final Type MOUNTAIN = new Type("MOUNTAIN", new Type[0]);
        public static final Type HILLS = new Type("HILLS", new Type[0]);
        public static final Type SWAMP = new Type("SWAMP", new Type[0]);
        public static final Type SANDY = new Type("SANDY", new Type[0]);
        public static final Type SNOWY = new Type("SNOWY", new Type[0]);
        public static final Type WASTELAND = new Type("WASTELAND", new Type[0]);
        public static final Type BEACH = new Type("BEACH", new Type[0]);
        public static final Type VOID = new Type("VOID", new Type[0]);
        public static final Type OVERWORLD = new Type("OVERWORLD", new Type[0]);
        public static final Type NETHER = new Type("NETHER", new Type[0]);
        public static final Type END = new Type("END", new Type[0]);
        private final String name;
        private final List<Type> subTypes;
        private final Set<ResourceKey<Biome>> biomes = new HashSet<ResourceKey<Biome>>();
        private final Set<ResourceKey<Biome>> biomesUn = Collections.unmodifiableSet(this.biomes);

        private Type(String name, Type ... subTypes) {
            this.name = name;
            this.subTypes = ImmutableList.copyOf((Object[])subTypes);
            byName.put(name, this);
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public static Type getType(String name, Type ... subTypes) {
            Type t = byName.get(name = name.toUpperCase());
            if (t == null) {
                t = new Type(name, subTypes);
            }
            return t;
        }

        public static boolean hasType(String name) {
            return byName.containsKey(name.toUpperCase());
        }

        public static Collection<Type> getAll() {
            return allTypes;
        }

        @Nullable
        public static Type fromVanilla(Biome.BiomeCategory category) {
            if (category == Biome.BiomeCategory.NONE) {
                return null;
            }
            if (category == Biome.BiomeCategory.THEEND) {
                return VOID;
            }
            return Type.getType(category.name(), new Type[0]);
        }
    }

    private static class BiomeInfo {
        private final Set<Type> types = new HashSet<Type>();
        private final Set<Type> typesUn = Collections.unmodifiableSet(this.types);

        private BiomeInfo() {
        }
    }
}

