/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.capabilities;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.Logging;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.Type;

public enum CapabilityManager {
    INSTANCE;

    static final Logger LOGGER;
    private static final Type CAP_INJECT;
    private final IdentityHashMap<String, Capability<?>> providers = new IdentityHashMap();

    @Deprecated(since="1.18", forRemoval=true)
    public <T> void register(Class<T> type) {
        Objects.requireNonNull(type, "Attempted to register a capability with invalid type");
        this.get(Type.getInternalName(type), true);
    }

    public static <T> Capability<T> get(CapabilityToken<T> type) {
        return INSTANCE.get(type.getType(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> Capability<T> get(String realName, boolean registering) {
        Capability cap;
        Object object = this.providers;
        synchronized (object) {
            realName = realName.intern();
            cap = this.providers.computeIfAbsent(realName, Capability::new);
        }
        if (registering) {
            object = cap;
            synchronized (object) {
                if (cap.isRegistered()) {
                    LOGGER.error(Logging.CAPABILITIES, "Cannot register capability implementation multiple times : {}", (Object)realName);
                    throw new IllegalArgumentException("Cannot register a capability implementation multiple times : " + realName);
                }
                cap.onRegister();
            }
        }
        return cap;
    }

    public void injectCapabilities(List<ModFileScanData> data) {
        List<ModFileScanData.AnnotationData> elementsToInject = data.stream().map(ModFileScanData::getAnnotations).flatMap(Collection::stream).filter(a -> CAP_INJECT.equals((Object)a.annotationType())).collect(Collectors.toList());
        IdentityHashMap callbacks = new IdentityHashMap();
        elementsToInject.forEach(entry -> this.gatherCallbacks(callbacks, (ModFileScanData.AnnotationData)entry));
        RegisterCapabilitiesEvent event = new RegisterCapabilitiesEvent();
        ModLoader.get().postEvent((Event)event);
    }

    private void gatherCallbacks(Map<String, List<Function<Capability<?>, Object>>> callbacks, ModFileScanData.AnnotationData annotationData) {
        String targetClass = annotationData.clazz().getClassName();
        String targetName = annotationData.memberName();
        Type type = (Type)annotationData.annotationData().get("value");
        if (type == null) {
            LOGGER.warn(Logging.CAPABILITIES, "Unable to inject capability at {}.{} (Invalid Annotation)", (Object)targetClass, (Object)targetName);
            return;
        }
        String capabilityName = type.getInternalName();
        Capability cap = this.get(capabilityName, false);
        if (annotationData.memberName().indexOf(40) > 0) {
            cap.addListener(input -> {
                try {
                    for (Method mtd : Class.forName(targetClass).getDeclaredMethods()) {
                        if (!targetName.equals(mtd.getName() + Type.getMethodDescriptor((Method)mtd))) continue;
                        if ((mtd.getModifiers() & 8) != 8) {
                            LOGGER.warn(Logging.CAPABILITIES, "Unable to inject capability {} at {}.{} (Non-Static)", (Object)capabilityName, (Object)targetClass, (Object)targetName);
                            return;
                        }
                        mtd.setAccessible(true);
                        mtd.invoke(null, input);
                        return;
                    }
                    LOGGER.warn(Logging.CAPABILITIES, "Unable to inject capability {} at {}.{} (Method Not Found)", (Object)capabilityName, (Object)targetClass, (Object)targetName);
                }
                catch (Exception e) {
                    LOGGER.warn(Logging.CAPABILITIES, "Unable to inject capability {} at {}.{}", (Object)capabilityName, (Object)targetClass, (Object)targetName, (Object)e);
                }
            });
        } else {
            cap.addListener(input -> {
                try {
                    Field field = Class.forName(targetClass).getDeclaredField(targetName);
                    if ((field.getModifiers() & 8) != 8) {
                        LOGGER.warn(Logging.CAPABILITIES, "Unable to inject capability {} at {}.{} (Non-Static)", (Object)capabilityName, (Object)targetClass, (Object)targetName);
                        return;
                    }
                    field.setAccessible(true);
                    field.set(null, input);
                }
                catch (Exception e) {
                    LOGGER.warn(Logging.CAPABILITIES, "Unable to inject capability {} at {}.{}", (Object)capabilityName, (Object)targetClass, (Object)targetName, (Object)e);
                }
            });
        }
    }

    static {
        LOGGER = LogManager.getLogger();
        CAP_INJECT = Type.getType(CapabilityInject.class);
    }
}

