/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.data;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Lifecycle;
import java.nio.file.Path;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public abstract class ForgeRegistryTagsProvider<T extends IForgeRegistryEntry<T>>
extends TagsProvider<T> {
    private static final Map<IForgeRegistry<?>, String> vanillaTypes = ImmutableMap.builder().put(ForgeRegistries.BLOCKS, (Object)"blocks").put(ForgeRegistries.ENTITIES, (Object)"entity_types").put(ForgeRegistries.FLUIDS, (Object)"fluids").put(ForgeRegistries.ITEMS, (Object)"items").build();

    private static <T extends IForgeRegistryEntry<T>> Registry<T> wrapRegistry(IForgeRegistry<T> registryIn) {
        if (!(registryIn instanceof ForgeRegistry)) {
            throw new IllegalArgumentException("Forge registry " + registryIn.getRegistryName() + " is not an instance of a ForgeRegistry");
        }
        ForgeRegistry forgeRegistry = (ForgeRegistry)registryIn;
        if (forgeRegistry.getTagFolder() == null && !vanillaTypes.containsKey(registryIn)) {
            throw new IllegalArgumentException("Forge registry " + registryIn.getRegistryName() + " does not have support for tags");
        }
        if (forgeRegistry.getDefaultKey() == null) {
            return GameData.getWrapper(forgeRegistry.getRegistryKey(), Lifecycle.experimental());
        }
        return GameData.getWrapper(forgeRegistry.getRegistryKey(), Lifecycle.experimental(), "default");
    }

    private static <T extends IForgeRegistryEntry<T>> String getTagFolder(IForgeRegistry<T> registryIn) {
        String tagFolder = ((ForgeRegistry)registryIn).getTagFolder();
        return tagFolder == null ? vanillaTypes.get(registryIn) : tagFolder;
    }

    public ForgeRegistryTagsProvider(DataGenerator generatorIn, IForgeRegistry<T> registryIn, String modId, @Nullable ExistingFileHelper existingFileHelper) {
        super(generatorIn, ForgeRegistryTagsProvider.wrapRegistry(registryIn), modId, existingFileHelper, ForgeRegistryTagsProvider.getTagFolder(registryIn));
    }

    protected Path m_6648_(ResourceLocation id) {
        return this.f_126539_.m_123916_().resolve("data/" + id.m_135827_() + "/tags/" + this.folder + "/" + id.m_135815_() + ".json");
    }
}

