/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fmlclient.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class GuiUtils {
    public static final int DEFAULT_BACKGROUND_COLOR = -267386864;
    public static final int DEFAULT_BORDER_COLOR_START = 0x505000FF;
    public static final int DEFAULT_BORDER_COLOR_END = 1344798847;
    public static final String UNDO_CHAR = "\u21b6";
    public static final String RESET_CHAR = "\u2604";
    public static final String VALID = "\u2714";
    public static final String INVALID = "\u2715";
    public static int[] colorCodes = new int[]{0, 170, 43520, 43690, 0xAA0000, 0xAA00AA, 0xFFAA00, 0xAAAAAA, 0x555555, 0x5555FF, 0x55FF55, 0x55FFFF, 0xFF5555, 0xFF55FF, 0xFFFF55, 0xFFFFFF, 0, 42, 10752, 10794, 0x2A0000, 0x2A002A, 0x2A2A00, 0x2A2A2A, 0x151515, 1381695, 1392405, 1392447, 4134165, 4134207, 4144917, 0x3F3F3F};
    @Nonnull
    private static ItemStack cachedTooltipStack = ItemStack.f_41583_;

    public static int getColorCode(char c, boolean isLighter) {
        return colorCodes[isLighter ? "0123456789abcdef".indexOf(c) : "0123456789abcdef".indexOf(c) + 16];
    }

    public static void drawContinuousTexturedBox(PoseStack matrixStack, int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight, int borderSize, float zLevel) {
        GuiUtils.drawContinuousTexturedBox(matrixStack, x, y, u, v, width, height, textureWidth, textureHeight, borderSize, borderSize, borderSize, borderSize, zLevel);
    }

    public static void drawContinuousTexturedBox(PoseStack matrixStack, ResourceLocation res, int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight, int borderSize, float zLevel) {
        GuiUtils.drawContinuousTexturedBox(matrixStack, res, x, y, u, v, width, height, textureWidth, textureHeight, borderSize, borderSize, borderSize, borderSize, zLevel);
    }

    public static void drawContinuousTexturedBox(PoseStack matrixStack, ResourceLocation res, int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight, int topBorder, int bottomBorder, int leftBorder, int rightBorder, float zLevel) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)res);
        GuiUtils.drawContinuousTexturedBox(matrixStack, x, y, u, v, width, height, textureWidth, textureHeight, topBorder, bottomBorder, leftBorder, rightBorder, zLevel);
    }

    public static void drawContinuousTexturedBox(PoseStack matrixStack, int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight, int topBorder, int bottomBorder, int leftBorder, int rightBorder, float zLevel) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        int fillerWidth = textureWidth - leftBorder - rightBorder;
        int fillerHeight = textureHeight - topBorder - bottomBorder;
        int canvasWidth = width - leftBorder - rightBorder;
        int canvasHeight = height - topBorder - bottomBorder;
        int xPasses = canvasWidth / fillerWidth;
        int remainderWidth = canvasWidth % fillerWidth;
        int yPasses = canvasHeight / fillerHeight;
        int remainderHeight = canvasHeight % fillerHeight;
        GuiUtils.drawTexturedModalRect(matrixStack, x, y, u, v, leftBorder, topBorder, zLevel);
        GuiUtils.drawTexturedModalRect(matrixStack, x + leftBorder + canvasWidth, y, u + leftBorder + fillerWidth, v, rightBorder, topBorder, zLevel);
        GuiUtils.drawTexturedModalRect(matrixStack, x, y + topBorder + canvasHeight, u, v + topBorder + fillerHeight, leftBorder, bottomBorder, zLevel);
        GuiUtils.drawTexturedModalRect(matrixStack, x + leftBorder + canvasWidth, y + topBorder + canvasHeight, u + leftBorder + fillerWidth, v + topBorder + fillerHeight, rightBorder, bottomBorder, zLevel);
        for (int i = 0; i < xPasses + (remainderWidth > 0 ? 1 : 0); ++i) {
            GuiUtils.drawTexturedModalRect(matrixStack, x + leftBorder + i * fillerWidth, y, u + leftBorder, v, i == xPasses ? remainderWidth : fillerWidth, topBorder, zLevel);
            GuiUtils.drawTexturedModalRect(matrixStack, x + leftBorder + i * fillerWidth, y + topBorder + canvasHeight, u + leftBorder, v + topBorder + fillerHeight, i == xPasses ? remainderWidth : fillerWidth, bottomBorder, zLevel);
            for (int j = 0; j < yPasses + (remainderHeight > 0 ? 1 : 0); ++j) {
                GuiUtils.drawTexturedModalRect(matrixStack, x + leftBorder + i * fillerWidth, y + topBorder + j * fillerHeight, u + leftBorder, v + topBorder, i == xPasses ? remainderWidth : fillerWidth, j == yPasses ? remainderHeight : fillerHeight, zLevel);
            }
        }
        for (int j = 0; j < yPasses + (remainderHeight > 0 ? 1 : 0); ++j) {
            GuiUtils.drawTexturedModalRect(matrixStack, x, y + topBorder + j * fillerHeight, u, v + topBorder, leftBorder, j == yPasses ? remainderHeight : fillerHeight, zLevel);
            GuiUtils.drawTexturedModalRect(matrixStack, x + leftBorder + canvasWidth, y + topBorder + j * fillerHeight, u + leftBorder + fillerWidth, v + topBorder, rightBorder, j == yPasses ? remainderHeight : fillerHeight, zLevel);
        }
    }

    public static void drawTexturedModalRect(PoseStack matrixStack, int x, int y, int u, int v, int width, int height, float zLevel) {
        float uScale = 0.00390625f;
        float vScale = 0.00390625f;
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder wr = tessellator.m_85915_();
        wr.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        Matrix4f matrix = matrixStack.m_85850_().m_85861_();
        wr.m_85982_(matrix, (float)x, (float)(y + height), zLevel).m_7421_((float)u * 0.00390625f, (float)(v + height) * 0.00390625f).m_5752_();
        wr.m_85982_(matrix, (float)(x + width), (float)(y + height), zLevel).m_7421_((float)(u + width) * 0.00390625f, (float)(v + height) * 0.00390625f).m_5752_();
        wr.m_85982_(matrix, (float)(x + width), (float)y, zLevel).m_7421_((float)(u + width) * 0.00390625f, (float)v * 0.00390625f).m_5752_();
        wr.m_85982_(matrix, (float)x, (float)y, zLevel).m_7421_((float)u * 0.00390625f, (float)v * 0.00390625f).m_5752_();
        tessellator.m_85914_();
    }

    @Deprecated(since="1.18", forRemoval=true)
    public static void preItemToolTip(@Nonnull ItemStack stack) {
        cachedTooltipStack = stack;
    }

    @Deprecated(since="1.18", forRemoval=true)
    public static void postItemToolTip() {
        cachedTooltipStack = ItemStack.f_41583_;
    }

    @Deprecated(since="1.18", forRemoval=true)
    public static void drawHoveringText(PoseStack mStack, List<? extends FormattedText> textLines, int mouseX, int mouseY, int screenWidth, int screenHeight, int maxTextWidth, Font font) {
        GuiUtils.drawHoveringText(mStack, textLines, mouseX, mouseY, screenWidth, screenHeight, maxTextWidth, -267386864, 0x505000FF, 1344798847, font);
    }

    @Deprecated(since="1.18", forRemoval=true)
    public static void drawHoveringText(PoseStack mStack, List<? extends FormattedText> textLines, int mouseX, int mouseY, int screenWidth, int screenHeight, int maxTextWidth, int backgroundColor, int borderColorStart, int borderColorEnd, Font font) {
        GuiUtils.drawHoveringText(cachedTooltipStack, mStack, textLines, mouseX, mouseY, screenWidth, screenHeight, maxTextWidth, backgroundColor, borderColorStart, borderColorEnd, font);
    }

    @Deprecated(since="1.18", forRemoval=true)
    public static void drawHoveringText(@Nonnull ItemStack stack, PoseStack mStack, List<? extends FormattedText> textLines, int mouseX, int mouseY, int screenWidth, int screenHeight, int maxTextWidth, Font font) {
        GuiUtils.drawHoveringText(stack, mStack, textLines, mouseX, mouseY, screenWidth, screenHeight, maxTextWidth, -267386864, 0x505000FF, 1344798847, font);
    }

    @Deprecated(since="1.18", forRemoval=true)
    public static void drawHoveringText(@Nonnull ItemStack stack, PoseStack pStack, List<? extends FormattedText> textLines, int mouseX, int mouseY, int screenWidth, int screenHeight, int maxTextWidth, int backgroundColor, int borderColorStart, int borderColorEnd, Font font) {
        if (!textLines.isEmpty()) {
            int n;
            RenderTooltipEvent.Pre event = new RenderTooltipEvent.Pre(stack, textLines, pStack, mouseX, mouseY, screenWidth, screenHeight, maxTextWidth, font);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                return;
            }
            mouseX = event.getX();
            mouseY = event.getY();
            screenWidth = event.getScreenWidth();
            screenHeight = event.getScreenHeight();
            maxTextWidth = event.getMaxWidth();
            font = event.getFontRenderer();
            RenderSystem.m_69465_();
            int tooltipTextWidth = 0;
            for (FormattedText formattedText : textLines) {
                int textLineWidth = font.m_92852_(formattedText);
                if (textLineWidth <= tooltipTextWidth) continue;
                tooltipTextWidth = textLineWidth;
            }
            boolean needsWrap = false;
            boolean bl = true;
            int tooltipX = mouseX + 12;
            if (tooltipX + tooltipTextWidth + 4 > screenWidth && (tooltipX = mouseX - 16 - tooltipTextWidth) < 4) {
                tooltipTextWidth = mouseX > screenWidth / 2 ? mouseX - 12 - 8 : screenWidth - 16 - mouseX;
                needsWrap = true;
            }
            if (maxTextWidth > 0 && tooltipTextWidth > maxTextWidth) {
                tooltipTextWidth = maxTextWidth;
                needsWrap = true;
            }
            if (needsWrap) {
                int wrappedTooltipWidth = 0;
                ArrayList<? extends FormattedText> wrappedTextLines = new ArrayList<FormattedText>();
                for (int i = 0; i < textLines.size(); ++i) {
                    FormattedText textLine = textLines.get(i);
                    List wrappedLine = font.m_92865_().m_92414_(textLine, tooltipTextWidth, Style.f_131099_);
                    if (i == 0) {
                        n = wrappedLine.size();
                    }
                    for (FormattedText line : wrappedLine) {
                        int lineWidth = font.m_92852_(line);
                        if (lineWidth > wrappedTooltipWidth) {
                            wrappedTooltipWidth = lineWidth;
                        }
                        wrappedTextLines.add((FormattedText)line);
                    }
                }
                tooltipTextWidth = wrappedTooltipWidth;
                textLines = wrappedTextLines;
                tooltipX = mouseX > screenWidth / 2 ? mouseX - 16 - tooltipTextWidth : mouseX + 12;
            }
            int tooltipY = mouseY - 12;
            int tooltipHeight = 8;
            if (textLines.size() > 1) {
                tooltipHeight += (textLines.size() - 1) * 10;
                if (textLines.size() > n) {
                    tooltipHeight += 2;
                }
            }
            if (tooltipY < 4) {
                tooltipY = 4;
            } else if (tooltipY + tooltipHeight + 4 > screenHeight) {
                tooltipY = screenHeight - tooltipHeight - 4;
            }
            int zLevel = 400;
            RenderTooltipEvent.Color colorEvent = new RenderTooltipEvent.Color(stack, textLines, pStack, tooltipX, tooltipY, font, backgroundColor, borderColorStart, borderColorEnd);
            MinecraftForge.EVENT_BUS.post((Event)colorEvent);
            backgroundColor = colorEvent.getBackground();
            borderColorStart = colorEvent.getBorderStart();
            borderColorEnd = colorEvent.getBorderEnd();
            pStack.m_85836_();
            Matrix4f mat = pStack.m_85850_().m_85861_();
            GuiUtils.drawGradientRect(mat, 400, tooltipX - 3, tooltipY - 4, tooltipX + tooltipTextWidth + 3, tooltipY - 3, backgroundColor, backgroundColor);
            GuiUtils.drawGradientRect(mat, 400, tooltipX - 3, tooltipY + tooltipHeight + 3, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 4, backgroundColor, backgroundColor);
            GuiUtils.drawGradientRect(mat, 400, tooltipX - 3, tooltipY - 3, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3, backgroundColor, backgroundColor);
            GuiUtils.drawGradientRect(mat, 400, tooltipX - 4, tooltipY - 3, tooltipX - 3, tooltipY + tooltipHeight + 3, backgroundColor, backgroundColor);
            GuiUtils.drawGradientRect(mat, 400, tooltipX + tooltipTextWidth + 3, tooltipY - 3, tooltipX + tooltipTextWidth + 4, tooltipY + tooltipHeight + 3, backgroundColor, backgroundColor);
            GuiUtils.drawGradientRect(mat, 400, tooltipX - 3, tooltipY - 3 + 1, tooltipX - 3 + 1, tooltipY + tooltipHeight + 3 - 1, borderColorStart, borderColorEnd);
            GuiUtils.drawGradientRect(mat, 400, tooltipX + tooltipTextWidth + 2, tooltipY - 3 + 1, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3 - 1, borderColorStart, borderColorEnd);
            GuiUtils.drawGradientRect(mat, 400, tooltipX - 3, tooltipY - 3, tooltipX + tooltipTextWidth + 3, tooltipY - 3 + 1, borderColorStart, borderColorStart);
            GuiUtils.drawGradientRect(mat, 400, tooltipX - 3, tooltipY + tooltipHeight + 2, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3, borderColorEnd, borderColorEnd);
            MinecraftForge.EVENT_BUS.post((Event)new RenderTooltipEvent.PostBackground(stack, textLines, pStack, tooltipX, tooltipY, font, tooltipTextWidth, tooltipHeight));
            MultiBufferSource.BufferSource renderType = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
            pStack.m_85837_(0.0, 0.0, 400.0);
            int tooltipTop = tooltipY;
            for (int lineNumber = 0; lineNumber < textLines.size(); ++lineNumber) {
                FormattedText line = textLines.get(lineNumber);
                if (line != null) {
                    font.m_92733_(Language.m_128107_().m_5536_(line), (float)tooltipX, (float)tooltipY, -1, true, mat, (MultiBufferSource)renderType, false, 0, 0xF000F0);
                }
                if (lineNumber + 1 == n) {
                    tooltipY += 2;
                }
                tooltipY += 10;
            }
            renderType.m_109911_();
            pStack.m_85849_();
            MinecraftForge.EVENT_BUS.post((Event)new RenderTooltipEvent.PostText(stack, textLines, pStack, tooltipX, tooltipTop, font, tooltipTextWidth, tooltipHeight));
            RenderSystem.m_69482_();
        }
    }

    public static void drawGradientRect(Matrix4f mat, int zLevel, int left, int top, int right, int bottom, int startColor, int endColor) {
        float startAlpha = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float startRed = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float startGreen = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float startBlue = (float)(startColor & 0xFF) / 255.0f;
        float endAlpha = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float endRed = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float endGreen = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float endBlue = (float)(endColor & 0xFF) / 255.0f;
        RenderSystem.m_69482_();
        RenderSystem.m_69472_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        buffer.m_85982_(mat, (float)right, (float)top, (float)zLevel).m_85950_(startRed, startGreen, startBlue, startAlpha).m_5752_();
        buffer.m_85982_(mat, (float)left, (float)top, (float)zLevel).m_85950_(startRed, startGreen, startBlue, startAlpha).m_5752_();
        buffer.m_85982_(mat, (float)left, (float)bottom, (float)zLevel).m_85950_(endRed, endGreen, endBlue, endAlpha).m_5752_();
        buffer.m_85982_(mat, (float)right, (float)bottom, (float)zLevel).m_85950_(endRed, endGreen, endBlue, endAlpha).m_5752_();
        tessellator.m_85914_();
        RenderSystem.m_69461_();
        RenderSystem.m_69493_();
    }

    public static void drawInscribedRect(PoseStack mStack, int x, int y, int boundsWidth, int boundsHeight, int rectWidth, int rectHeight) {
        GuiUtils.drawInscribedRect(mStack, x, y, boundsWidth, boundsHeight, rectWidth, rectHeight, true, true);
    }

    public static void drawInscribedRect(PoseStack mStack, int x, int y, int boundsWidth, int boundsHeight, int rectWidth, int rectHeight, boolean centerX, boolean centerY) {
        if (rectWidth * boundsHeight > rectHeight * boundsWidth) {
            int h = boundsHeight;
            boundsHeight = (int)((double)boundsWidth * ((double)rectHeight / (double)rectWidth));
            if (centerY) {
                y += (h - boundsHeight) / 2;
            }
        } else {
            int w = boundsWidth;
            boundsWidth = (int)((double)boundsHeight * ((double)rectWidth / (double)rectHeight));
            if (centerX) {
                x += (w - boundsWidth) / 2;
            }
        }
        GuiComponent.m_93160_((PoseStack)mStack, (int)x, (int)y, (int)boundsWidth, (int)boundsHeight, (float)0.0f, (float)0.0f, (int)rectWidth, (int)rectHeight, (int)rectWidth, (int)rectHeight);
    }
}

