/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fmllegacy;

import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.WorldData;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fmllegacy.MavenVersionStringHelper;
import net.minecraftforge.fmllegacy.WorldPersistenceHooks;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.RegistryManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public final class FMLWorldPersistenceHook
implements WorldPersistenceHooks.WorldPersistenceHook {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Marker WORLDPERSISTENCE = MarkerManager.getMarker((String)"WP");

    @Override
    public String getModId() {
        return "fml";
    }

    @Override
    public CompoundTag getDataForWriting(LevelStorageSource.LevelStorageAccess levelSave, WorldData serverInfo) {
        CompoundTag fmlData = new CompoundTag();
        ListTag modList = new ListTag();
        ModList.get().getMods().forEach(mi -> {
            CompoundTag mod = new CompoundTag();
            mod.m_128359_("ModId", mi.getModId());
            mod.m_128359_("ModVersion", MavenVersionStringHelper.artifactVersionToString(mi.getVersion()));
            modList.add((Object)mod);
        });
        fmlData.m_128365_("LoadingModList", (Tag)modList);
        CompoundTag registries = new CompoundTag();
        fmlData.m_128365_("Registries", (Tag)registries);
        LOGGER.debug(WORLDPERSISTENCE, "Gathering id map for writing to world save {}", (Object)serverInfo.m_5462_());
        for (Map.Entry<ResourceLocation, ForgeRegistry.Snapshot> e : RegistryManager.ACTIVE.takeSnapshot(true).entrySet()) {
            registries.m_128365_(e.getKey().toString(), (Tag)e.getValue().write());
        }
        LOGGER.debug(WORLDPERSISTENCE, "ID Map collection complete {}", (Object)serverInfo.m_5462_());
        return fmlData;
    }

    @Override
    public void readData(LevelStorageSource.LevelStorageAccess levelSave, WorldData serverInfo, CompoundTag tag) {
        if (tag.m_128441_("LoadingModList")) {
            ListTag modList = tag.m_128437_("LoadingModList", 10);
            for (int i = 0; i < modList.size(); ++i) {
                CompoundTag mod = modList.m_128728_(i);
                String modId = mod.m_128461_("ModId");
                if (Objects.equals("minecraft", modId)) continue;
                String modVersion = mod.m_128461_("ModVersion");
                Optional container = ModList.get().getModContainerById(modId);
                if (!container.isPresent()) {
                    LOGGER.error(WORLDPERSISTENCE, "This world was saved with mod {} which appears to be missing, things may not work well", (Object)modId);
                    continue;
                }
                if (Objects.equals(modVersion, MavenVersionStringHelper.artifactVersionToString(((ModContainer)container.get()).getModInfo().getVersion()))) continue;
                LOGGER.warn(WORLDPERSISTENCE, "This world was saved with mod {} version {} and it is now at version {}, things may not work well", (Object)modId, (Object)modVersion, (Object)MavenVersionStringHelper.artifactVersionToString(((ModContainer)container.get()).getModInfo().getVersion()));
            }
        }
        Multimap<ResourceLocation, ResourceLocation> failedElements = null;
        if (tag.m_128441_("Registries")) {
            HashMap<ResourceLocation, ForgeRegistry.Snapshot> snapshot = new HashMap<ResourceLocation, ForgeRegistry.Snapshot>();
            CompoundTag regs = tag.m_128469_("Registries");
            for (String key : regs.m_128431_()) {
                snapshot.put(new ResourceLocation(key), ForgeRegistry.Snapshot.read(regs.m_128469_(key)));
            }
            failedElements = GameData.injectSnapshot(snapshot, true, true);
        }
        if (failedElements != null && !failedElements.isEmpty()) {
            StringBuilder buf = new StringBuilder();
            buf.append("Forge Mod Loader could not load this save.\n\n").append("There are ").append(failedElements.size()).append(" unassigned registry entries in this save.\n").append("You will not be able to load until they are present again.\n\n");
            failedElements.asMap().forEach((name, entries) -> {
                buf.append("Missing ").append(name).append(":\n");
                entries.forEach(rl -> buf.append("    ").append(rl).append("\n"));
            });
        }
    }
}

