/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fmllegacy;

import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.LogicalSide;

public enum LogicalSidedProvider {
    WORKQUEUE(c -> c.get(), s -> s.get()),
    INSTANCE(c -> c.get(), s -> s.get()),
    CLIENTWORLD(c -> Optional.of(((Minecraft)c.get()).f_91073_), s -> Optional.empty());

    private static Supplier<Minecraft> client;
    private static Supplier<MinecraftServer> server;
    private final Function<Supplier<Minecraft>, ?> clientSide;
    private final Function<Supplier<MinecraftServer>, ?> serverSide;

    private LogicalSidedProvider(Function<Supplier<Minecraft>, ?> clientSide, Function<Supplier<MinecraftServer>, ?> serverSide) {
        this.clientSide = clientSide;
        this.serverSide = serverSide;
    }

    public static void setClient(Supplier<Minecraft> client) {
        LogicalSidedProvider.client = client;
    }

    public static void setServer(Supplier<MinecraftServer> server) {
        LogicalSidedProvider.server = server;
    }

    public <T> T get(LogicalSide side) {
        return (T)(side == LogicalSide.CLIENT ? this.clientSide.apply(client) : this.serverSide.apply(server));
    }
}

