/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fmllegacy.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fmllegacy.network.FMLHandshakeHandler;
import net.minecraftforge.fmllegacy.network.FMLNetworkConstants;
import net.minecraftforge.fmllegacy.network.NetworkDirection;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import net.minecraftforge.fmllegacy.network.NetworkRegistry;
import net.minecraftforge.fmllegacy.network.PacketDispatcher;
import net.minecraftforge.fmllegacy.network.event.EventNetworkChannel;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FMLLoginWrapper {
    private static final Logger LOGGER = LogManager.getLogger();
    static final ResourceLocation WRAPPER = new ResourceLocation("fml:loginwrapper");
    private EventNetworkChannel wrapperChannel = NetworkRegistry.ChannelBuilder.named(WRAPPER).clientAcceptedVersions(a -> true).serverAcceptedVersions(a -> true).networkProtocolVersion(() -> "FML2").eventNetworkChannel();

    FMLLoginWrapper() {
        this.wrapperChannel.addListener(this::wrapperReceived);
    }

    private <T extends NetworkEvent> void wrapperReceived(T packet) {
        if (packet instanceof NetworkEvent.ChannelRegistrationChangeEvent) {
            return;
        }
        NetworkEvent.Context wrappedContext = packet.getSource().get();
        FriendlyByteBuf payload = packet.getPayload();
        ResourceLocation targetNetworkReceiver = FMLNetworkConstants.FML_HANDSHAKE_RESOURCE;
        FriendlyByteBuf data = null;
        if (payload != null) {
            targetNetworkReceiver = payload.m_130281_();
            int payloadLength = payload.m_130242_();
            data = new FriendlyByteBuf(payload.readBytes(payloadLength));
        }
        int loginSequence = packet.getLoginIndex();
        LOGGER.debug(FMLHandshakeHandler.FMLHSMARKER, "Recieved login wrapper packet event for channel {} with index {}", (Object)targetNetworkReceiver, (Object)loginSequence);
        NetworkEvent.Context context = new NetworkEvent.Context(wrappedContext.getNetworkManager(), wrappedContext.getDirection(), new PacketDispatcher((rl, buf) -> {
            LOGGER.debug(FMLHandshakeHandler.FMLHSMARKER, "Dispatching wrapped packet reply for channel {} with index {}", rl, (Object)loginSequence);
            wrappedContext.getPacketDispatcher().sendPacket(WRAPPER, this.wrapPacket((ResourceLocation)rl, (FriendlyByteBuf)buf));
        }));
        NetworkEvent.LoginPayloadEvent loginPayloadEvent = new NetworkEvent.LoginPayloadEvent(data, () -> context, loginSequence);
        NetworkRegistry.findTarget(targetNetworkReceiver).ifPresent(ni -> {
            ni.dispatchLoginPacket(loginPayloadEvent);
            wrappedContext.setPacketHandled(context.getPacketHandled());
        });
    }

    private FriendlyByteBuf wrapPacket(ResourceLocation rl, FriendlyByteBuf buf) {
        FriendlyByteBuf pb = new FriendlyByteBuf(Unpooled.buffer((int)buf.capacity()));
        pb.m_130085_(rl);
        pb.m_130130_(buf.readableBytes());
        pb.writeBytes((ByteBuf)buf);
        return pb;
    }

    void sendServerToClientLoginPacket(ResourceLocation resourceLocation, FriendlyByteBuf buffer, int index, Connection manager) {
        FriendlyByteBuf pb = this.wrapPacket(resourceLocation, buffer);
        manager.m_129512_(NetworkDirection.LOGIN_TO_CLIENT.buildPacket((Pair<FriendlyByteBuf, Integer>)Pair.of((Object)pb, (Object)index), WRAPPER).getThis());
    }
}

