/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fmllegacy.network;

import io.netty.buffer.Unpooled;
import io.netty.util.Attribute;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fmllegacy.network.FMLNetworkConstants;
import net.minecraftforge.fmllegacy.network.ICustomPacket;
import net.minecraftforge.fmllegacy.network.NetworkDirection;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import net.minecraftforge.fmllegacy.network.NetworkRegistry;
import org.apache.commons.lang3.tuple.Pair;

public class FMLMCRegisterPacketHandler {
    public static final FMLMCRegisterPacketHandler INSTANCE = new FMLMCRegisterPacketHandler();

    public void addChannels(Set<ResourceLocation> locations, Connection manager) {
        FMLMCRegisterPacketHandler.getFrom((Connection)manager).locations.addAll(locations);
    }

    void registerListener(NetworkEvent evt) {
        ChannelList channelList = FMLMCRegisterPacketHandler.getFrom(evt);
        channelList.updateFrom(evt.getSource(), evt.getPayload(), NetworkEvent.RegistrationChangeType.REGISTER);
        evt.getSource().get().setPacketHandled(true);
    }

    void unregisterListener(NetworkEvent evt) {
        ChannelList channelList = FMLMCRegisterPacketHandler.getFrom(evt);
        channelList.updateFrom(evt.getSource(), evt.getPayload(), NetworkEvent.RegistrationChangeType.UNREGISTER);
        evt.getSource().get().setPacketHandled(true);
    }

    private static ChannelList getFrom(Connection manager) {
        return FMLMCRegisterPacketHandler.fromAttr((Attribute<ChannelList>)manager.channel().attr(FMLNetworkConstants.FML_MC_REGISTRY));
    }

    private static ChannelList getFrom(NetworkEvent event) {
        return FMLMCRegisterPacketHandler.fromAttr(event.getSource().get().attr(FMLNetworkConstants.FML_MC_REGISTRY));
    }

    private static ChannelList fromAttr(Attribute<ChannelList> attr) {
        attr.setIfAbsent((Object)new ChannelList());
        return (ChannelList)attr.get();
    }

    public void sendRegistry(Connection manager, NetworkDirection dir) {
        FriendlyByteBuf pb = new FriendlyByteBuf(Unpooled.buffer());
        pb.writeBytes(FMLMCRegisterPacketHandler.getFrom(manager).toByteArray());
        ICustomPacket iPacketICustomPacket = dir.buildPacket((Pair<FriendlyByteBuf, Integer>)Pair.of((Object)pb, (Object)0), FMLNetworkConstants.MC_REGISTER_RESOURCE);
        manager.m_129512_(iPacketICustomPacket.getThis());
    }

    public static class ChannelList {
        private Set<ResourceLocation> locations = new HashSet<ResourceLocation>();

        public void updateFrom(Supplier<NetworkEvent.Context> source, FriendlyByteBuf buffer, NetworkEvent.RegistrationChangeType changeType) {
            byte[] data = new byte[Math.max(buffer.readableBytes(), 0)];
            buffer.readBytes(data);
            Set<ResourceLocation> oldLocations = this.locations;
            this.locations = this.bytesToResLocation(data);
            oldLocations.addAll(this.locations);
            oldLocations.stream().map(NetworkRegistry::findTarget).filter(Optional::isPresent).map(Optional::get).forEach(t -> t.dispatchEvent(new NetworkEvent.ChannelRegistrationChangeEvent(source, changeType)));
        }

        byte[] toByteArray() {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            for (ResourceLocation rl : this.locations) {
                try {
                    bos.write(rl.toString().getBytes(StandardCharsets.UTF_8));
                    bos.write(0);
                }
                catch (IOException iOException) {}
            }
            return bos.toByteArray();
        }

        private Set<ResourceLocation> bytesToResLocation(byte[] all) {
            HashSet<ResourceLocation> rl = new HashSet<ResourceLocation>();
            int last = 0;
            for (int cur = 0; cur < all.length; ++cur) {
                if (all[cur] != 0) continue;
                String s = new String(all, last, cur - last, StandardCharsets.UTF_8);
                rl.add(new ResourceLocation(s));
                last = cur + 1;
            }
            return rl;
        }
    }
}

