/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fmllegacy.network;

import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fmllegacy.network.ICustomPacket;
import org.apache.commons.lang3.tuple.Pair;

public class PacketDispatcher {
    BiConsumer<ResourceLocation, FriendlyByteBuf> packetSink;

    PacketDispatcher(BiConsumer<ResourceLocation, FriendlyByteBuf> packetSink) {
        this.packetSink = packetSink;
    }

    private PacketDispatcher() {
    }

    public void sendPacket(ResourceLocation resourceLocation, FriendlyByteBuf buffer) {
        this.packetSink.accept(resourceLocation, buffer);
    }

    static class NetworkManagerDispatcher
    extends PacketDispatcher {
        private final Connection manager;
        private final int packetIndex;
        private final BiFunction<Pair<FriendlyByteBuf, Integer>, ResourceLocation, ICustomPacket<?>> customPacketSupplier;

        NetworkManagerDispatcher(Connection manager, int packetIndex, BiFunction<Pair<FriendlyByteBuf, Integer>, ResourceLocation, ICustomPacket<?>> customPacketSupplier) {
            this.packetSink = this::dispatchPacket;
            this.manager = manager;
            this.packetIndex = packetIndex;
            this.customPacketSupplier = customPacketSupplier;
        }

        private void dispatchPacket(ResourceLocation resourceLocation, FriendlyByteBuf buffer) {
            ICustomPacket<?> packet = this.customPacketSupplier.apply((Pair<FriendlyByteBuf, Integer>)Pair.of((Object)buffer, (Object)this.packetIndex), resourceLocation);
            this.manager.m_129512_(packet.getThis());
        }
    }
}

