/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fmllegacy.server;

import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.network.Connection;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.handshake.ClientIntentionPacket;
import net.minecraft.network.protocol.login.ClientboundLoginDisconnectPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.Logging;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.fml.ModLoadingStage;
import net.minecraftforge.fml.ModLoadingWarning;
import net.minecraftforge.fml.config.ConfigTracker;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FileUtils;
import net.minecraftforge.fmllegacy.LogicalSidedProvider;
import net.minecraftforge.fmllegacy.network.ConnectionType;
import net.minecraftforge.fmllegacy.network.FMLStatusPing;
import net.minecraftforge.fmllegacy.network.NetworkHooks;
import net.minecraftforge.fmllegacy.network.NetworkRegistry;
import net.minecraftforge.fmllegacy.server.LanguageHook;
import net.minecraftforge.fmlserverevents.FMLServerAboutToStartEvent;
import net.minecraftforge.fmlserverevents.FMLServerStartedEvent;
import net.minecraftforge.fmlserverevents.FMLServerStartingEvent;
import net.minecraftforge.fmlserverevents.FMLServerStoppedEvent;
import net.minecraftforge.fmlserverevents.FMLServerStoppingEvent;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.resource.PathResourcePack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class ServerLifecycleHooks {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Marker SERVERHOOKS = MarkerManager.getMarker((String)"SERVERHOOKS");
    private static final LevelResource SERVERCONFIG = new LevelResource("serverconfig");
    private static volatile CountDownLatch exitLatch = null;
    private static MinecraftServer currentServer;
    private static AtomicBoolean allowLogins;

    private static Path getServerConfigPath(MinecraftServer server) {
        Path serverConfig = server.m_129843_(SERVERCONFIG);
        FileUtils.getOrCreateDirectory((Path)serverConfig, (String)"serverconfig");
        return serverConfig;
    }

    public static boolean handleServerAboutToStart(MinecraftServer server) {
        currentServer = server;
        currentServer.m_129928_().setForgeData(new FMLStatusPing());
        LogicalSidedProvider.setServer(() -> server);
        ConfigTracker.INSTANCE.loadConfigs(ModConfig.Type.SERVER, ServerLifecycleHooks.getServerConfigPath(server));
        return !MinecraftForge.EVENT_BUS.post((Event)new FMLServerAboutToStartEvent(server));
    }

    public static boolean handleServerStarting(MinecraftServer server) {
        DistExecutor.runWhenOn((Dist)Dist.DEDICATED_SERVER, () -> () -> LanguageHook.loadLanguagesOnServer(server));
        return !MinecraftForge.EVENT_BUS.post((Event)new FMLServerStartingEvent(server));
    }

    public static void handleServerStarted(MinecraftServer server) {
        MinecraftForge.EVENT_BUS.post((Event)new FMLServerStartedEvent(server));
        allowLogins.set(true);
    }

    public static void handleServerStopping(MinecraftServer server) {
        allowLogins.set(false);
        MinecraftForge.EVENT_BUS.post((Event)new FMLServerStoppingEvent(server));
    }

    public static void expectServerStopped() {
        exitLatch = new CountDownLatch(1);
    }

    public static void handleServerStopped(MinecraftServer server) {
        if (!server.m_6982_()) {
            GameData.revertToFrozen();
        }
        MinecraftForge.EVENT_BUS.post((Event)new FMLServerStoppedEvent(server));
        currentServer = null;
        LogicalSidedProvider.setServer(null);
        CountDownLatch latch = exitLatch;
        if (latch != null) {
            latch.countDown();
            exitLatch = null;
        }
        ConfigTracker.INSTANCE.unloadConfigs(ModConfig.Type.SERVER, ServerLifecycleHooks.getServerConfigPath(server));
    }

    public static MinecraftServer getCurrentServer() {
        return currentServer;
    }

    public static boolean handleServerLogin(ClientIntentionPacket packet, Connection manager) {
        if (!allowLogins.get()) {
            TextComponent text = new TextComponent("Server is still starting! Please wait before reconnecting.");
            LOGGER.info(SERVERHOOKS, "Disconnecting Player (server is still starting): {}", (Object)text.m_6111_());
            manager.m_129512_((Packet)new ClientboundLoginDisconnectPacket((Component)text));
            manager.m_129507_((Component)text);
            return false;
        }
        if (packet.m_134735_() == ConnectionProtocol.LOGIN) {
            ConnectionType connectionType = ConnectionType.forVersionFlag(packet.getFMLVersion());
            int versionNumber = connectionType.getFMLVersionNumber(packet.getFMLVersion());
            if (connectionType == ConnectionType.MODDED && versionNumber != 2) {
                ServerLifecycleHooks.rejectConnection(manager, connectionType, "This modded server is not network compatible with your modded client. Please verify your Forge version closely matches the server. Got net version " + versionNumber + " this server is net version 2");
                return false;
            }
            if (connectionType == ConnectionType.VANILLA && !NetworkRegistry.acceptsVanillaClientConnections()) {
                ServerLifecycleHooks.rejectConnection(manager, connectionType, "This server has mods that require Forge to be installed on the client. Contact your server admin for more details.");
                return false;
            }
        }
        if (packet.m_134735_() == ConnectionProtocol.STATUS) {
            return true;
        }
        NetworkHooks.registerServerLoginChannel(manager, packet);
        return true;
    }

    private static void rejectConnection(Connection manager, ConnectionType type, String message) {
        manager.m_129498_(ConnectionProtocol.LOGIN);
        LOGGER.info(SERVERHOOKS, "Disconnecting {} connection attempt: {}", (Object)type, (Object)message);
        TextComponent text = new TextComponent(message);
        manager.m_129512_((Packet)new ClientboundLoginDisconnectPacket((Component)text));
        manager.m_129507_((Component)text);
    }

    public static void handleExit(int retVal) {
        System.exit(retVal);
    }

    @Deprecated(since="1.18", forRemoval=true)
    public static RepositorySource buildPackFinder(Map<IModFile, ? extends PathResourcePack> modResourcePacks, BiConsumer<? super PathResourcePack, Pack> packSetter) {
        return (packList, factory) -> ServerLifecycleHooks.serverPackFinder(modResourcePacks, packList, factory);
    }

    @Deprecated
    public static RepositorySource buildPackFinderNew(Map<IModFile, ? extends PathResourcePack> modResourcePacks) {
        return (packList, factory) -> ServerLifecycleHooks.serverPackFinder(modResourcePacks, packList, factory);
    }

    private static void serverPackFinder(Map<IModFile, ? extends PathResourcePack> modResourcePacks, Consumer<Pack> consumer, Pack.PackConstructor factory) {
        for (Map.Entry<IModFile, ? extends PathResourcePack> e : modResourcePacks.entrySet()) {
            IModInfo mod = (IModInfo)e.getKey().getModInfos().get(0);
            if (Objects.equals(mod.getModId(), "minecraft")) continue;
            String name = "mod:" + mod.getModId();
            Pack packInfo = Pack.m_10430_((String)name, (boolean)false, e::getValue, (Pack.PackConstructor)factory, (Pack.Position)Pack.Position.BOTTOM, (PackSource)PackSource.f_10527_);
            if (packInfo == null) {
                ModLoader.get().addWarning(new ModLoadingWarning(mod, ModLoadingStage.ERROR, "fml.modloading.brokenresources", new Object[]{e.getKey()}));
                continue;
            }
            LOGGER.debug(Logging.CORE, "Generating PackInfo named {} for mod file {}", (Object)name, (Object)e.getKey().getFilePath());
            consumer.accept(packInfo);
        }
    }

    static {
        allowLogins = new AtomicBoolean(false);
    }
}

