/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.server.permission.context;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.server.permission.context.ContextKey;
import net.minecraftforge.server.permission.context.ContextKeys;
import net.minecraftforge.server.permission.context.PlayerContext;

public class BlockPosContext
extends PlayerContext {
    private final BlockPos blockPos;
    private BlockState blockState;
    private Direction facing;

    public BlockPosContext(Player ep, BlockPos pos, @Nullable BlockState state, @Nullable Direction f) {
        super(ep);
        this.blockPos = (BlockPos)Preconditions.checkNotNull((Object)pos, (Object)"BlockPos can't be null in BlockPosContext!");
        this.blockState = state;
        this.facing = f;
    }

    public BlockPosContext(Player ep, ChunkPos pos) {
        this(ep, new BlockPos(pos.m_45604_() + 8, 0, pos.m_45605_() + 8), null, null);
    }

    @Override
    @Nullable
    public <T> T get(ContextKey<T> key) {
        if (key.equals(ContextKeys.POS)) {
            return (T)this.blockPos;
        }
        if (key.equals(ContextKeys.BLOCK_STATE)) {
            if (this.blockState == null) {
                this.blockState = this.getWorld().m_8055_(this.blockPos);
            }
            return (T)this.blockState;
        }
        if (key.equals(ContextKeys.FACING)) {
            return (T)this.facing;
        }
        return super.get(key);
    }

    @Override
    protected boolean covers(ContextKey<?> key) {
        return key.equals(ContextKeys.POS) || key.equals(ContextKeys.BLOCK_STATE) || this.facing != null && key.equals(ContextKeys.FACING);
    }
}

