/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client;

import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.textures.ITextureAtlasSpriteLoader;

public class MinecraftForgeClient {
    private static float partialTick;
    private static BitSet stencilBits;
    private static HashMap<ResourceLocation, Supplier<NativeImage>> bufferedImageSuppliers;
    private static final Map<ResourceLocation, ITextureAtlasSpriteLoader> textureAtlasSpriteLoaders;
    private static final Map<Class<? extends TooltipComponent>, Function<TooltipComponent, ClientTooltipComponent>> tooltipComponentFactories;

    public static RenderType getRenderType() {
        return ForgeHooksClient.renderType.get();
    }

    public static float getPartialTick() {
        return partialTick;
    }

    public static void setPartialTick(float partialTick) {
        MinecraftForgeClient.partialTick = partialTick;
    }

    public static Locale getLocale() {
        return Minecraft.m_91087_().m_91102_().m_118983_().getJavaLocale();
    }

    public static int reserveStencilBit() {
        int bit = stencilBits.nextSetBit(0);
        if (bit >= 0) {
            stencilBits.clear(bit);
        }
        return bit;
    }

    public static void releaseStencilBit(int bit) {
        if (bit >= 0 && bit < stencilBits.length()) {
            stencilBits.set(bit);
        }
    }

    public static void registerImageLayerSupplier(ResourceLocation resourceLocation, Supplier<NativeImage> supplier) {
        bufferedImageSuppliers.put(resourceLocation, supplier);
    }

    @Nonnull
    public static NativeImage getImageLayer(ResourceLocation resourceLocation, ResourceManager resourceManager) throws IOException {
        Supplier<NativeImage> supplier = bufferedImageSuppliers.get(resourceLocation);
        if (supplier != null) {
            return supplier.get();
        }
        Resource iresource1 = resourceManager.m_142591_(resourceLocation);
        return NativeImage.m_85058_((InputStream)iresource1.m_6679_());
    }

    public static void registerTextureAtlasSpriteLoader(ResourceLocation name, ITextureAtlasSpriteLoader loader) {
        textureAtlasSpriteLoaders.put(name, loader);
    }

    @Nullable
    public static ITextureAtlasSpriteLoader getTextureAtlasSpriteLoader(ResourceLocation name) {
        return textureAtlasSpriteLoaders.get(name);
    }

    public static <T extends TooltipComponent> void registerTooltipComponentFactory(Class<T> cls, Function<? super T, ? extends ClientTooltipComponent> factory) {
        tooltipComponentFactories.put(cls, factory);
    }

    @Nullable
    public static ClientTooltipComponent getClientTooltipComponent(TooltipComponent component) {
        Function<TooltipComponent, ClientTooltipComponent> factory = tooltipComponentFactories.get(component.getClass());
        return factory == null ? null : factory.apply(component);
    }

    static {
        stencilBits = new BitSet(8);
        stencilBits.set(0, 8);
        bufferedImageSuppliers = new HashMap();
        textureAtlasSpriteLoaders = new ConcurrentHashMap<ResourceLocation, ITextureAtlasSpriteLoader>();
        tooltipComponentFactories = new ConcurrentHashMap<Class<? extends TooltipComponent>, Function<TooltipComponent, ClientTooltipComponent>>();
    }
}

