/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import com.mojang.math.Transformation;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;

public class QuadTransformer {
    private static final int POSITION = QuadTransformer.findPositionOffset(DefaultVertexFormat.f_85811_);
    private static final int NORMAL = QuadTransformer.findNormalOffset(DefaultVertexFormat.f_85811_);
    private final Transformation transform;

    public QuadTransformer(Transformation transform) {
        this.transform = transform;
    }

    private void processVertices(int[] inData, int[] outData) {
        int offset;
        int i;
        int stride = DefaultVertexFormat.f_85811_.m_86020_();
        int count = inData.length * 4 / stride;
        for (i = 0; i < count; ++i) {
            offset = POSITION + i * stride;
            float x = Float.intBitsToFloat(QuadTransformer.getAtByteOffset(inData, offset));
            float y = Float.intBitsToFloat(QuadTransformer.getAtByteOffset(inData, offset + 4));
            float z = Float.intBitsToFloat(QuadTransformer.getAtByteOffset(inData, offset + 8));
            Vector4f pos = new Vector4f(x, y, z, 1.0f);
            this.transform.transformPosition(pos);
            pos.m_123621_();
            QuadTransformer.putAtByteOffset(outData, offset, Float.floatToRawIntBits(pos.m_123601_()));
            QuadTransformer.putAtByteOffset(outData, offset + 4, Float.floatToRawIntBits(pos.m_123615_()));
            QuadTransformer.putAtByteOffset(outData, offset + 8, Float.floatToRawIntBits(pos.m_123616_()));
        }
        for (i = 0; i < count; ++i) {
            offset = NORMAL + i * stride;
            int normalIn = QuadTransformer.getAtByteOffset(inData, offset);
            if (normalIn == 0) continue;
            float x = (float)((byte)(normalIn >> 24)) / 127.0f;
            float y = (float)((byte)(normalIn << 8 >> 24)) / 127.0f;
            float z = (float)((byte)(normalIn << 16 >> 24)) / 127.0f;
            Vector3f pos = new Vector3f(x, y, z);
            this.transform.transformNormal(pos);
            pos.m_122278_();
            int normalOut = ((byte)(x / 127.0f) & 0xFF) << 24 | ((byte)(y / 127.0f) & 0xFF) << 16 | ((byte)(z / 127.0f) & 0xFF) << 8 | normalIn & 0xFF;
            QuadTransformer.putAtByteOffset(outData, offset, normalOut);
        }
    }

    private static int getAtByteOffset(int[] inData, int offset) {
        int index = offset / 4;
        int lsb = inData[index];
        int shift = offset % 4 * 8;
        if (shift == 0) {
            return inData[index];
        }
        int msb = inData[index + 1];
        return lsb >>> shift | msb << 32 - shift;
    }

    private static void putAtByteOffset(int[] outData, int offset, int value) {
        int index = offset / 4;
        int shift = offset % 4 * 8;
        if (shift == 0) {
            outData[index] = value;
            return;
        }
        int lsbMask = -1 >>> 32 - shift;
        int msbMask = -1 << shift;
        outData[index] = outData[index] & lsbMask | value << shift;
        outData[index + 1] = outData[index + 1] & msbMask | value >>> 32 - shift;
    }

    private static int findPositionOffset(VertexFormat fmt) {
        int index;
        VertexFormatElement element = null;
        for (index = 0; index < fmt.m_86023_().size(); ++index) {
            VertexFormatElement el = (VertexFormatElement)fmt.m_86023_().get(index);
            if (el.m_86048_() != VertexFormatElement.Usage.POSITION) continue;
            element = el;
            break;
        }
        if (index == fmt.m_86023_().size() || element == null) {
            throw new RuntimeException("Expected vertex format to have a POSITION attribute");
        }
        if (element.m_86041_() != VertexFormatElement.Type.FLOAT) {
            throw new RuntimeException("Expected POSITION attribute to have data type FLOAT");
        }
        if (element.m_86050_() < 3) {
            throw new RuntimeException("Expected POSITION attribute to have at least 3 dimensions");
        }
        return fmt.getOffset(index);
    }

    private static int findNormalOffset(VertexFormat fmt) {
        int index;
        VertexFormatElement element = null;
        for (index = 0; index < fmt.m_86023_().size(); ++index) {
            VertexFormatElement el = (VertexFormatElement)fmt.m_86023_().get(index);
            if (el.m_86048_() != VertexFormatElement.Usage.NORMAL) continue;
            element = el;
            break;
        }
        if (index == fmt.m_86023_().size() || element == null) {
            throw new IllegalStateException("BLOCK format does not have normals?");
        }
        if (element.m_86041_() != VertexFormatElement.Type.BYTE) {
            throw new RuntimeException("Expected NORMAL attribute to have data type BYTE");
        }
        if (element.m_86050_() < 3) {
            throw new RuntimeException("Expected NORMAL attribute to have at least 3 dimensions");
        }
        return fmt.getOffset(index);
    }

    public BakedQuad processOne(BakedQuad input) {
        int[] inData = input.m_111303_();
        int[] outData = Arrays.copyOf(inData, inData.length);
        this.processVertices(inData, outData);
        return new BakedQuad(outData, input.m_111305_(), input.m_111306_(), input.m_173410_(), input.m_111307_());
    }

    public BakedQuad processOneInPlace(BakedQuad input) {
        int[] data = input.m_111303_();
        this.processVertices(data, data);
        return input;
    }

    public List<BakedQuad> processMany(List<BakedQuad> inputs) {
        if (inputs.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList outputs = Lists.newArrayList();
        for (BakedQuad input : inputs) {
            int[] inData = input.m_111303_();
            int[] outData = Arrays.copyOf(inData, inData.length);
            this.processVertices(inData, outData);
            outputs.add(new BakedQuad(outData, input.m_111305_(), input.m_111306_(), input.m_173410_(), input.m_111307_()));
        }
        return outputs;
    }

    public void processManyInPlace(List<BakedQuad> inputs) {
        if (inputs.size() == 0) {
            return;
        }
        for (BakedQuad input : inputs) {
            int[] data = input.m_111303_();
            this.processVertices(data, data);
        }
    }
}

