/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.settings;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum KeyModifier {
    CONTROL{

        @Override
        public boolean matches(InputConstants.Key key) {
            int keyCode = key.m_84873_();
            if (Minecraft.f_91002_) {
                return keyCode == 342 || keyCode == 346;
            }
            return keyCode == 341 || keyCode == 345;
        }

        @Override
        public boolean isActive(@Nullable IKeyConflictContext conflictContext) {
            return Screen.m_96637_();
        }

        @Override
        public Component getCombinedName(InputConstants.Key key, Supplier<Component> defaultLogic) {
            String localizationFormatKey = Minecraft.f_91002_ ? "forge.controlsgui.control.mac" : "forge.controlsgui.control";
            return new TranslatableComponent(localizationFormatKey, new Object[]{defaultLogic.get()});
        }
    }
    ,
    SHIFT{

        @Override
        public boolean matches(InputConstants.Key key) {
            return key.m_84873_() == 340 || key.m_84873_() == 344;
        }

        @Override
        public boolean isActive(@Nullable IKeyConflictContext conflictContext) {
            return Screen.m_96638_();
        }

        @Override
        public Component getCombinedName(InputConstants.Key key, Supplier<Component> defaultLogic) {
            return new TranslatableComponent("forge.controlsgui.shift", new Object[]{defaultLogic.get()});
        }
    }
    ,
    ALT{

        @Override
        public boolean matches(InputConstants.Key key) {
            return key.m_84873_() == 342 || key.m_84873_() == 346;
        }

        @Override
        public boolean isActive(@Nullable IKeyConflictContext conflictContext) {
            return Screen.m_96639_();
        }

        @Override
        public Component getCombinedName(InputConstants.Key keyCode, Supplier<Component> defaultLogic) {
            return new TranslatableComponent("forge.controlsgui.alt", new Object[]{defaultLogic.get()});
        }
    }
    ,
    NONE{

        @Override
        public boolean matches(InputConstants.Key key) {
            return false;
        }

        @Override
        public boolean isActive(@Nullable IKeyConflictContext conflictContext) {
            if (conflictContext != null && !conflictContext.conflicts(KeyConflictContext.IN_GAME)) {
                for (KeyModifier keyModifier : MODIFIER_VALUES) {
                    if (!keyModifier.isActive(conflictContext)) continue;
                    return false;
                }
            }
            return true;
        }

        @Override
        public Component getCombinedName(InputConstants.Key key, Supplier<Component> defaultLogic) {
            return defaultLogic.get();
        }
    };

    public static final KeyModifier[] MODIFIER_VALUES;

    public static KeyModifier getActiveModifier() {
        for (KeyModifier keyModifier : MODIFIER_VALUES) {
            if (!keyModifier.isActive(null)) continue;
            return keyModifier;
        }
        return NONE;
    }

    public static boolean isKeyCodeModifier(InputConstants.Key key) {
        for (KeyModifier keyModifier : MODIFIER_VALUES) {
            if (!keyModifier.matches(key)) continue;
            return true;
        }
        return false;
    }

    public static KeyModifier valueFromString(String stringValue) {
        try {
            return KeyModifier.valueOf(stringValue);
        }
        catch (IllegalArgumentException | NullPointerException ignored) {
            return NONE;
        }
    }

    public abstract boolean matches(InputConstants.Key var1);

    public abstract boolean isActive(@Nullable IKeyConflictContext var1);

    public abstract Component getCombinedName(InputConstants.Key var1, Supplier<Component> var2);

    static {
        MODIFIER_VALUES = new KeyModifier[]{SHIFT, CONTROL, ALT};
    }
}

