/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.capabilities;

import java.util.IdentityHashMap;
import java.util.List;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.Logging;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public enum CapabilityManager {
    INSTANCE;

    static final Logger LOGGER;
    private final IdentityHashMap<String, Capability<?>> providers = new IdentityHashMap();

    public static <T> Capability<T> get(CapabilityToken<T> type) {
        return INSTANCE.get(type.getType(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> Capability<T> get(String realName, boolean registering) {
        Capability cap;
        Object object = this.providers;
        synchronized (object) {
            realName = realName.intern();
            cap = this.providers.computeIfAbsent(realName, Capability::new);
        }
        if (registering) {
            object = cap;
            synchronized (object) {
                if (cap.isRegistered()) {
                    LOGGER.error(Logging.CAPABILITIES, "Cannot register capability implementation multiple times : {}", (Object)realName);
                    throw new IllegalArgumentException("Cannot register a capability implementation multiple times : " + realName);
                }
                cap.onRegister();
            }
        }
        return cap;
    }

    public void injectCapabilities(List<ModFileScanData> data) {
        RegisterCapabilitiesEvent event = new RegisterCapabilitiesEvent();
        ModLoader.get().postEvent((Event)event);
    }

    static {
        LOGGER = LogManager.getLogger();
    }
}

