/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.RecipeBookCategories;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.ApiStatus;

public class RecipeBookRegistry {
    private static final Map<RecipeBookCategories, List<RecipeBookCategories>> MUTABLE_AGGREGATE_CATEGORIES = new HashMap<RecipeBookCategories, List<RecipeBookCategories>>();
    private static final Map<RecipeBookType, List<RecipeBookCategories>> TYPE_TO_CATEGORIES = new HashMap<RecipeBookType, List<RecipeBookCategories>>();
    private static final Map<RecipeType<?>, Function<Recipe<?>, RecipeBookCategories>> FIND_CATEGORIES_FOR_TYPE = new HashMap();
    public static final Map<RecipeBookCategories, List<RecipeBookCategories>> AGGREGATE_CATEGORIES_VIEW = Collections.unmodifiableMap(MUTABLE_AGGREGATE_CATEGORIES);
    public static final Map<RecipeBookType, List<RecipeBookCategories>> TYPE_TO_CATEGORIES_VIEW = Collections.unmodifiableMap(TYPE_TO_CATEGORIES);

    public static void addCategoriesToType(RecipeBookType type, List<RecipeBookCategories> categories) {
        TYPE_TO_CATEGORIES.put(type, categories instanceof ImmutableList ? categories : Collections.unmodifiableList(categories));
    }

    public static void addAggregateCategories(RecipeBookCategories search, List<RecipeBookCategories> aggregate) {
        MUTABLE_AGGREGATE_CATEGORIES.put(search, aggregate instanceof ImmutableList ? aggregate : Collections.unmodifiableList(aggregate));
    }

    public static void addCategoriesFinder(RecipeType<?> type, Function<Recipe<?>, RecipeBookCategories> finder) {
        FIND_CATEGORIES_FOR_TYPE.put(type, finder);
    }

    @Nullable
    public static RecipeBookCategories findCategories(RecipeType<?> type, Recipe<?> recipe) {
        return Optional.ofNullable(FIND_CATEGORIES_FOR_TYPE.get(type)).map(f -> (RecipeBookCategories)f.apply(recipe)).orElse(null);
    }

    @ApiStatus.Internal
    public static void initDefaultValues() {
        MUTABLE_AGGREGATE_CATEGORIES.putAll((Map<RecipeBookCategories, List<RecipeBookCategories>>)ImmutableMap.of((Object)RecipeBookCategories.CRAFTING_SEARCH, (Object)ImmutableList.of((Object)RecipeBookCategories.CRAFTING_EQUIPMENT, (Object)RecipeBookCategories.CRAFTING_BUILDING_BLOCKS, (Object)RecipeBookCategories.CRAFTING_MISC, (Object)RecipeBookCategories.CRAFTING_REDSTONE), (Object)RecipeBookCategories.FURNACE_SEARCH, (Object)ImmutableList.of((Object)RecipeBookCategories.FURNACE_FOOD, (Object)RecipeBookCategories.FURNACE_BLOCKS, (Object)RecipeBookCategories.FURNACE_MISC), (Object)RecipeBookCategories.BLAST_FURNACE_SEARCH, (Object)ImmutableList.of((Object)RecipeBookCategories.BLAST_FURNACE_BLOCKS, (Object)RecipeBookCategories.BLAST_FURNACE_MISC), (Object)RecipeBookCategories.SMOKER_SEARCH, (Object)ImmutableList.of((Object)RecipeBookCategories.SMOKER_FOOD)));
    }
}

