/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.extensions;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Vec3i;
import net.minecraftforge.client.model.pipeline.LightUtil;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.MemoryStack;

public interface IForgeVertexConsumer {
    @Nullable
    default public VertexFormat getVertexFormat() {
        return null;
    }

    default public void putBulkData(PoseStack.Pose poseStack, BakedQuad bakedQuad, float red, float green, float blue, int packedLight, int packedOverlay, boolean readExistingColor) {
        this.putBulkData(poseStack, bakedQuad, red, green, blue, 1.0f, packedLight, packedOverlay, readExistingColor);
    }

    default public void putBulkData(PoseStack.Pose pose, BakedQuad bakedQuad, float red, float green, float blue, float alpha, int packedLight, int packedOverlay) {
        this.putBulkData(pose, bakedQuad, new float[]{1.0f, 1.0f, 1.0f, 1.0f}, red, green, blue, alpha, new int[]{packedLight, packedLight, packedLight, packedLight}, packedOverlay, false);
    }

    default public void putBulkData(PoseStack.Pose pose, BakedQuad bakedQuad, float red, float green, float blue, float alpha, int packedLight, int packedOverlay, boolean readExistingColor) {
        this.putBulkData(pose, bakedQuad, new float[]{1.0f, 1.0f, 1.0f, 1.0f}, red, green, blue, alpha, new int[]{packedLight, packedLight, packedLight, packedLight}, packedOverlay, readExistingColor);
    }

    default public void putBulkData(PoseStack.Pose pose, BakedQuad bakedQuad, float[] baseBrightness, float red, float green, float blue, float alpha, int[] lightmap, int packedOverlay, boolean readExistingColor) {
        int[] aint = bakedQuad.m_111303_();
        Vec3i faceNormal = bakedQuad.m_111306_().m_122436_();
        Vector3f normal = new Vector3f((float)faceNormal.m_123341_(), (float)faceNormal.m_123342_(), (float)faceNormal.m_123343_());
        Matrix4f matrix4f = pose.m_85861_();
        normal.m_122249_(pose.m_85864_());
        int intSize = DefaultVertexFormat.f_85811_.m_86017_();
        int vertexCount = aint.length / intSize;
        try (MemoryStack memorystack = MemoryStack.stackPush();){
            ByteBuffer bytebuffer = memorystack.malloc(DefaultVertexFormat.f_85811_.m_86020_());
            IntBuffer intbuffer = bytebuffer.asIntBuffer();
            for (int v = 0; v < vertexCount; ++v) {
                float ca;
                float cb;
                float cg;
                float cr;
                ((Buffer)intbuffer).clear();
                intbuffer.put(aint, v * 8, 8);
                float f = bytebuffer.getFloat(0);
                float f1 = bytebuffer.getFloat(4);
                float f2 = bytebuffer.getFloat(8);
                if (readExistingColor) {
                    float r = (float)(bytebuffer.get(12) & 0xFF) / 255.0f;
                    float g = (float)(bytebuffer.get(13) & 0xFF) / 255.0f;
                    float b = (float)(bytebuffer.get(14) & 0xFF) / 255.0f;
                    float a = (float)(bytebuffer.get(15) & 0xFF) / 255.0f;
                    cr = r * baseBrightness[v] * red;
                    cg = g * baseBrightness[v] * green;
                    cb = b * baseBrightness[v] * blue;
                    ca = a * alpha;
                } else {
                    cr = baseBrightness[v] * red;
                    cg = baseBrightness[v] * green;
                    cb = baseBrightness[v] * blue;
                    ca = alpha;
                }
                int lightmapCoord = this.applyBakedLighting(lightmap[v], bytebuffer);
                float f9 = bytebuffer.getFloat(16);
                float f10 = bytebuffer.getFloat(20);
                Vector4f pos = new Vector4f(f, f1, f2, 1.0f);
                pos.m_123607_(matrix4f);
                this.applyBakedNormals(normal, bytebuffer, pose.m_85864_());
                ((VertexConsumer)this).m_5954_(pos.m_123601_(), pos.m_123615_(), pos.m_123616_(), cr, cg, cb, ca, f9, f10, packedOverlay, lightmapCoord, normal.m_122239_(), normal.m_122260_(), normal.m_122269_());
            }
        }
    }

    default public int applyBakedLighting(int packedLight, ByteBuffer data) {
        int bl = packedLight & 0xFFFF;
        int sl = packedLight >> 16 & 0xFFFF;
        int offset = LightUtil.getLightOffset(0) * 4;
        int blBaked = Short.toUnsignedInt(data.getShort(offset));
        int slBaked = Short.toUnsignedInt(data.getShort(offset + 2));
        bl = Math.max(bl, blBaked);
        sl = Math.max(sl, slBaked);
        return bl | sl << 16;
    }

    default public void applyBakedNormals(Vector3f generated, ByteBuffer data, Matrix3f normalTransform) {
        byte nx = data.get(28);
        byte ny = data.get(29);
        byte nz = data.get(30);
        if (nx != 0 || ny != 0 || nz != 0) {
            generated.m_122245_((float)nx / 127.0f, (float)ny / 127.0f, (float)nz / 127.0f);
            generated.m_122249_(normalTransform);
        }
    }
}

