/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids;

import java.util.function.BiFunction;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.fluids.FluidStack;

public class FluidAttributes {
    public static final int BUCKET_VOLUME = 1000;
    private String translationKey;
    private final ResourceLocation stillTexture;
    private final ResourceLocation flowingTexture;
    @Nullable
    private final ResourceLocation overlayTexture;
    private final SoundEvent fillSound;
    private final SoundEvent emptySound;
    private final int luminosity;
    private final int density;
    private final int temperature;
    private final int viscosity;
    private final boolean isGaseous;
    private final Rarity rarity;
    private final int color;

    protected FluidAttributes(Builder builder, Fluid fluid) {
        this.translationKey = builder.translationKey != null ? builder.translationKey : Util.m_137492_((String)"fluid", (ResourceLocation)fluid.getRegistryName());
        this.stillTexture = builder.stillTexture;
        this.flowingTexture = builder.flowingTexture;
        this.overlayTexture = builder.overlayTexture;
        this.color = builder.color;
        this.fillSound = builder.fillSound;
        this.emptySound = builder.emptySound;
        this.luminosity = builder.luminosity;
        this.temperature = builder.temperature;
        this.viscosity = builder.viscosity;
        this.density = builder.density;
        this.isGaseous = builder.isGaseous;
        this.rarity = builder.rarity;
    }

    public ItemStack getBucket(FluidStack stack) {
        return new ItemStack((ItemLike)stack.getFluid().m_6859_());
    }

    public BlockState getBlock(BlockAndTintGetter reader, BlockPos pos, FluidState state) {
        return state.m_76188_();
    }

    public FluidState getStateForPlacement(BlockAndTintGetter reader, BlockPos pos, FluidStack state) {
        return state.getFluid().m_76145_();
    }

    public final boolean canBePlacedInWorld(BlockAndTintGetter reader, BlockPos pos, FluidState state) {
        return !this.getBlock(reader, pos, state).m_60795_();
    }

    public final boolean canBePlacedInWorld(BlockAndTintGetter reader, BlockPos pos, FluidStack state) {
        return !this.getBlock(reader, pos, this.getStateForPlacement(reader, pos, state)).m_60795_();
    }

    public final boolean isLighterThanAir() {
        return this.density <= 0;
    }

    public boolean doesVaporize(BlockAndTintGetter reader, BlockPos pos, FluidStack fluidStack) {
        BlockState blockstate = this.getBlock(reader, pos, this.getStateForPlacement(reader, pos, fluidStack));
        if (blockstate == null) {
            return false;
        }
        return blockstate.m_60767_() == Material.f_76305_;
    }

    public void vaporize(@Nullable Player player, Level worldIn, BlockPos pos, FluidStack fluidStack) {
        worldIn.m_5594_(player, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 2.6f + (worldIn.f_46441_.nextFloat() - worldIn.f_46441_.nextFloat()) * 0.8f);
        for (int l = 0; l < 8; ++l) {
            worldIn.m_7107_((ParticleOptions)ParticleTypes.f_123755_, (double)pos.m_123341_() + Math.random(), (double)pos.m_123342_() + Math.random(), (double)pos.m_123343_() + Math.random(), 0.0, 0.0, 0.0);
        }
    }

    public Component getDisplayName(FluidStack stack) {
        return new TranslatableComponent(this.getTranslationKey(stack));
    }

    public String getTranslationKey(FluidStack stack) {
        return this.getTranslationKey();
    }

    public String getTranslationKey() {
        return this.translationKey;
    }

    public final int getLuminosity() {
        return this.luminosity;
    }

    public final int getDensity() {
        return this.density;
    }

    public final int getTemperature() {
        return this.temperature;
    }

    public final int getViscosity() {
        return this.viscosity;
    }

    public final boolean isGaseous() {
        return this.isGaseous;
    }

    public Rarity getRarity() {
        return this.rarity;
    }

    public int getColor() {
        return this.color;
    }

    public ResourceLocation getStillTexture() {
        return this.stillTexture;
    }

    public ResourceLocation getFlowingTexture() {
        return this.flowingTexture;
    }

    @Nullable
    public ResourceLocation getOverlayTexture() {
        return this.overlayTexture;
    }

    public SoundEvent getFillSound() {
        return this.fillSound;
    }

    public SoundEvent getEmptySound() {
        return this.emptySound;
    }

    public int getLuminosity(FluidStack stack) {
        return this.getLuminosity();
    }

    public int getDensity(FluidStack stack) {
        return this.getDensity();
    }

    public int getTemperature(FluidStack stack) {
        return this.getTemperature();
    }

    public int getViscosity(FluidStack stack) {
        return this.getViscosity();
    }

    public boolean isGaseous(FluidStack stack) {
        return this.isGaseous();
    }

    public Rarity getRarity(FluidStack stack) {
        return this.getRarity();
    }

    public int getColor(FluidStack stack) {
        return this.getColor();
    }

    public ResourceLocation getStillTexture(FluidStack stack) {
        return this.getStillTexture();
    }

    public ResourceLocation getFlowingTexture(FluidStack stack) {
        return this.getFlowingTexture();
    }

    public SoundEvent getFillSound(FluidStack stack) {
        return this.getFillSound();
    }

    public SoundEvent getEmptySound(FluidStack stack) {
        return this.getEmptySound();
    }

    public int getLuminosity(BlockAndTintGetter level, BlockPos pos) {
        return this.getLuminosity();
    }

    public int getDensity(BlockAndTintGetter level, BlockPos pos) {
        return this.getDensity();
    }

    public int getTemperature(BlockAndTintGetter level, BlockPos pos) {
        return this.getTemperature();
    }

    public int getViscosity(BlockAndTintGetter level, BlockPos pos) {
        return this.getViscosity();
    }

    public boolean isGaseous(BlockAndTintGetter level, BlockPos pos) {
        return this.isGaseous();
    }

    public Rarity getRarity(BlockAndTintGetter level, BlockPos pos) {
        return this.getRarity();
    }

    public int getColor(BlockAndTintGetter level, BlockPos pos) {
        return this.getColor();
    }

    public ResourceLocation getStillTexture(BlockAndTintGetter level, BlockPos pos) {
        return this.getStillTexture();
    }

    public ResourceLocation getFlowingTexture(BlockAndTintGetter level, BlockPos pos) {
        return this.getFlowingTexture();
    }

    public SoundEvent getFillSound(BlockAndTintGetter level, BlockPos pos) {
        return this.getFillSound();
    }

    public SoundEvent getEmptySound(BlockAndTintGetter level, BlockPos pos) {
        return this.getEmptySound();
    }

    public static Builder builder(ResourceLocation stillTexture, ResourceLocation flowingTexture) {
        return new Builder(stillTexture, flowingTexture, FluidAttributes::new);
    }

    public Stream<ResourceLocation> getTextures() {
        if (this.overlayTexture != null) {
            return Stream.of(this.stillTexture, this.flowingTexture, this.overlayTexture);
        }
        return Stream.of(this.stillTexture, this.flowingTexture);
    }

    public static class Builder {
        private final ResourceLocation stillTexture;
        private final ResourceLocation flowingTexture;
        private ResourceLocation overlayTexture;
        private int color = -1;
        private String translationKey;
        private SoundEvent fillSound;
        private SoundEvent emptySound;
        private int luminosity = 0;
        private int density = 1000;
        private int temperature = 300;
        private int viscosity = 1000;
        private boolean isGaseous;
        private Rarity rarity = Rarity.COMMON;
        private BiFunction<Builder, Fluid, FluidAttributes> factory;

        protected Builder(ResourceLocation stillTexture, ResourceLocation flowingTexture, BiFunction<Builder, Fluid, FluidAttributes> factory) {
            this.factory = factory;
            this.stillTexture = stillTexture;
            this.flowingTexture = flowingTexture;
        }

        public final Builder translationKey(String translationKey) {
            this.translationKey = translationKey;
            return this;
        }

        public final Builder color(int color) {
            this.color = color;
            return this;
        }

        public final Builder overlay(ResourceLocation texture) {
            this.overlayTexture = texture;
            return this;
        }

        public final Builder luminosity(int luminosity) {
            this.luminosity = luminosity;
            return this;
        }

        public final Builder density(int density) {
            this.density = density;
            return this;
        }

        public final Builder temperature(int temperature) {
            this.temperature = temperature;
            return this;
        }

        public final Builder viscosity(int viscosity) {
            this.viscosity = viscosity;
            return this;
        }

        public final Builder gaseous() {
            this.isGaseous = true;
            return this;
        }

        public final Builder rarity(Rarity rarity) {
            this.rarity = rarity;
            return this;
        }

        public final Builder sound(SoundEvent sound) {
            this.fillSound = this.emptySound = sound;
            return this;
        }

        public final Builder sound(SoundEvent fillSound, SoundEvent emptySound) {
            this.fillSound = fillSound;
            this.emptySound = emptySound;
            return this;
        }

        public FluidAttributes build(Fluid fluid) {
            return this.factory.apply(this, fluid);
        }
    }

    public static class Water
    extends FluidAttributes {
        protected Water(Builder builder, Fluid fluid) {
            super(builder, fluid);
        }

        @Override
        public int getColor(BlockAndTintGetter level, BlockPos pos) {
            return BiomeColors.m_108811_((BlockAndTintGetter)level, (BlockPos)pos) | 0xFF000000;
        }

        public static Builder builder(ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            return new Builder(stillTexture, flowingTexture, Water::new);
        }
    }
}

