/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.network.filters;

import com.google.common.collect.ImmutableMap;
import io.netty.channel.ChannelHandler;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.network.Connection;
import net.minecraftforge.network.filters.ForgeConnectionNetworkFilter;
import net.minecraftforge.network.filters.VanillaConnectionNetworkFilter;
import net.minecraftforge.network.filters.VanillaPacketFilter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NetworkFilters {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<String, Function<Connection, VanillaPacketFilter>> instances = ImmutableMap.of((Object)"forge:vanilla_filter", manager -> new VanillaConnectionNetworkFilter(), (Object)"forge:forge_fixes", ForgeConnectionNetworkFilter::new);

    public static void injectIfNecessary(Connection manager) {
        instances.forEach((key, filterFactory) -> {
            VanillaPacketFilter filter = (VanillaPacketFilter)((Object)((Object)filterFactory.apply(manager)));
            if (filter.isNecessary(manager)) {
                manager.channel().pipeline().addBefore("packet_handler", key, (ChannelHandler)filter);
                LOGGER.debug("Injected {} into {}", (Object)filter, (Object)manager);
            }
        });
    }

    private NetworkFilters() {
    }
}

