/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.registries;

import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.NewRegistryEvent;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryManager;
import net.minecraftforge.registries.RegistryObject;
import net.minecraftforge.registries.VanillaRegisterEvent;
import net.minecraftforge.registries.tags.ITagManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeferredRegister<T> {
    @Nullable
    private final ResourceKey<? extends Registry<T>> registryKey;
    @Nullable
    private final Class<? extends IForgeRegistryEntry<?>> superType;
    private final String modid;
    private final boolean optionalRegistry;
    private final Map<RegistryObject<T>, Supplier<? extends T>> entries = new LinkedHashMap<RegistryObject<T>, Supplier<? extends T>>();
    private final Set<RegistryObject<T>> entriesView = Collections.unmodifiableSet(this.entries.keySet());
    @Nullable
    private Supplier<RegistryBuilder<?>> registryFactory;
    @Nullable
    private SetMultimap<TagKey<T>, Supplier<T>> optionalTags;
    private boolean seenRegisterEvent = false;

    public static <B extends IForgeRegistryEntry<B>> DeferredRegister<B> create(IForgeRegistry<B> reg, String modid) {
        return new DeferredRegister(reg, modid);
    }

    @Deprecated(forRemoval=true, since="1.18.2")
    public static <B extends IForgeRegistryEntry<B>> DeferredRegister<B> create(Class<B> base, String modid) {
        return new DeferredRegister(null, base, modid, false);
    }

    public static <B> DeferredRegister<B> create(ResourceKey<? extends Registry<B>> key, String modid) {
        return new DeferredRegister(key, null, modid, false);
    }

    public static <B> DeferredRegister<B> createOptional(ResourceKey<? extends Registry<B>> key, String modid) {
        return new DeferredRegister(key, null, modid, true);
    }

    public static <B> DeferredRegister<B> create(ResourceLocation registryName, String modid) {
        return new DeferredRegister(ResourceKey.m_135788_((ResourceLocation)registryName), null, modid, false);
    }

    public static <B> DeferredRegister<B> createOptional(ResourceLocation registryName, String modid) {
        return new DeferredRegister(ResourceKey.m_135788_((ResourceLocation)registryName), null, modid, true);
    }

    private <E extends IForgeRegistryEntry<E>> DeferredRegister(@Nullable ResourceKey<? extends Registry<T>> registryKey, @Nullable Class<E> base, String modid, boolean optionalRegistry) {
        this.registryKey = registryKey;
        this.superType = base;
        this.modid = modid;
        this.optionalRegistry = optionalRegistry;
    }

    private <E extends IForgeRegistryEntry<E>> DeferredRegister(IForgeRegistry<E> reg, String modid) {
        this(reg.getRegistryKey(), reg.getRegistrySuperType(), modid, false);
    }

    public <I extends T> RegistryObject<I> register(String name, Supplier<? extends I> sup) {
        RegistryObject ret;
        if (this.seenRegisterEvent) {
            throw new IllegalStateException("Cannot register new entries to DeferredRegister after RegistryEvent.Register has been fired.");
        }
        Objects.requireNonNull(name);
        Objects.requireNonNull(sup);
        ResourceLocation key = new ResourceLocation(this.modid, name);
        if (this.registryKey != null) {
            ret = this.optionalRegistry ? RegistryObject.createOptional(key, this.registryKey, this.modid) : RegistryObject.create(key, this.registryKey, this.modid);
        } else if (this.superType != null) {
            ret = RegistryObject.of(key, this.superType, this.modid);
        } else {
            throw new IllegalStateException("Could not create RegistryObject in DeferredRegister");
        }
        Supplier<Object> prevValue = this.entries.putIfAbsent(ret, () -> {
            Object value = sup.get();
            if (value instanceof IForgeRegistryEntry) {
                IForgeRegistryEntry regEntry = (IForgeRegistryEntry)value;
                regEntry.setRegistryName(key);
            }
            return value;
        });
        if (prevValue != null) {
            throw new IllegalArgumentException("Duplicate registration " + name);
        }
        return ret;
    }

    @Deprecated(forRemoval=true, since="1.18.2")
    public <E extends IForgeRegistryEntry<E>> Supplier<IForgeRegistry<E>> makeRegistry(String name, Supplier<RegistryBuilder<E>> sup) {
        return this.makeRegistry(new ResourceLocation(this.modid, name), this.superType, sup);
    }

    public <E extends IForgeRegistryEntry<E>> Supplier<IForgeRegistry<E>> makeRegistry(Class<E> base, Supplier<RegistryBuilder<E>> sup) {
        return this.makeRegistry(this.registryKey.m_135782_(), base, sup);
    }

    @NotNull
    public TagKey<T> createTagKey(@NotNull String path) {
        Objects.requireNonNull(path);
        return this.createTagKey(new ResourceLocation(this.modid, path));
    }

    @NotNull
    public TagKey<T> createTagKey(@NotNull ResourceLocation location) {
        if (this.registryKey == null) {
            throw new IllegalStateException("The registry name was not set, cannot create a tag key");
        }
        Objects.requireNonNull(location);
        return TagKey.m_203882_(this.registryKey, (ResourceLocation)location);
    }

    @NotNull
    public TagKey<T> createOptionalTagKey(@NotNull String path, @NotNull Set<? extends Supplier<T>> defaults) {
        Objects.requireNonNull(path);
        return this.createOptionalTagKey(new ResourceLocation(this.modid, path), defaults);
    }

    @NotNull
    public TagKey<T> createOptionalTagKey(@NotNull ResourceLocation location, @NotNull Set<? extends Supplier<T>> defaults) {
        TagKey<T> tagKey = this.createTagKey(location);
        this.addOptionalTagDefaults(tagKey, defaults);
        return tagKey;
    }

    public void addOptionalTagDefaults(@NotNull TagKey<T> name, @NotNull Set<? extends Supplier<T>> defaults) {
        Objects.requireNonNull(defaults);
        if (this.optionalTags == null) {
            this.optionalTags = Multimaps.newSetMultimap(new IdentityHashMap(), HashSet::new);
        }
        this.optionalTags.putAll(name, defaults);
    }

    public void register(IEventBus bus) {
        bus.register((Object)new EventDispatcher(this));
        if (this.registryKey != null && this.findForgeRegistry() == null) {
            bus.addListener(this::vanillaRegister);
        }
        if (this.registryFactory != null) {
            bus.addListener(this::createRegistry);
        }
    }

    public Collection<RegistryObject<T>> getEntries() {
        return this.entriesView;
    }

    @Nullable
    public ResourceLocation getRegistryName() {
        return this.registryKey == null ? null : this.registryKey.m_135782_();
    }

    private <E extends IForgeRegistryEntry<E>> Supplier<IForgeRegistry<E>> makeRegistry(final ResourceLocation registryName, Class<E> superType, Supplier<RegistryBuilder<E>> sup) {
        if (registryName == null) {
            throw new IllegalStateException("Cannot create a registry without specifying a registry name");
        }
        if (superType == null) {
            throw new IllegalStateException("Cannot create a registry without specifying a base type");
        }
        if (RegistryManager.ACTIVE.getRegistry(registryName) != null || this.registryFactory != null) {
            throw new IllegalStateException("Cannot create a registry for a type that already exists");
        }
        this.registryFactory = () -> ((RegistryBuilder)sup.get()).setName(registryName).setType(superType);
        return new Supplier<IForgeRegistry<E>>(){
            private IForgeRegistry<E> registry;

            @Override
            public IForgeRegistry<E> get() {
                if (this.registry == null) {
                    this.registry = RegistryManager.ACTIVE.getRegistry(registryName);
                }
                return this.registry;
            }
        };
    }

    private void onFill(IForgeRegistry<?> registry) {
        if (this.optionalTags == null) {
            return;
        }
        ITagManager<?> tagManager = registry.tags();
        if (tagManager == null) {
            throw new IllegalStateException("The forge registry " + String.valueOf(registry.getRegistryName()) + " does not support tags, but optional tags were registered!");
        }
        Multimaps.asMap(this.optionalTags).forEach(tagManager::addOptionalTagDefaults);
    }

    private void addEntries(RegistryEvent.Register<?> event) {
        IForgeRegistry<?> storedType = this.findForgeRegistry();
        if (storedType != null && event.getGenericType() == storedType.getRegistrySuperType()) {
            this.seenRegisterEvent = true;
            IForgeRegistry<?> reg = event.getRegistry();
            for (Map.Entry<RegistryObject<T>, Supplier<T>> e : this.entries.entrySet()) {
                reg.register((IForgeRegistryEntry)e.getValue().get());
                e.getKey().updateReference(reg);
            }
        }
    }

    private void createRegistry(NewRegistryEvent event) {
        event.create(this.registryFactory.get(), this::onFill);
    }

    private void vanillaRegister(VanillaRegisterEvent event) {
        if (this.registryKey != null && event.vanillaRegistry.m_123023_() == this.registryKey) {
            this.seenRegisterEvent = true;
            for (Map.Entry<RegistryObject<T>, Supplier<T>> e : this.entries.entrySet()) {
                Registry.m_122965_(event.vanillaRegistry, (ResourceLocation)e.getKey().getId(), e.getValue().get());
                e.getKey().updateReference(event.vanillaRegistry);
            }
        }
    }

    @Nullable
    private IForgeRegistry<?> findForgeRegistry() {
        if (this.registryKey != null) {
            return RegistryManager.ACTIVE.getRegistry(this.registryKey);
        }
        if (this.superType != null) {
            return RegistryManager.ACTIVE.getRegistry(this.superType);
        }
        return null;
    }

    public static class EventDispatcher {
        private final DeferredRegister<?> register;

        public EventDispatcher(DeferredRegister<?> register) {
            this.register = register;
        }

        @SubscribeEvent
        public void handleEvent(RegistryEvent.Register<?> event) {
            this.register.addEntries(event);
        }
    }
}

