/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.registries;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.BuiltinRegistries;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.event.IModBusEvent;
import net.minecraftforge.registries.DataPackRegistriesHooks;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryManager;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class NewRegistryEvent
extends Event
implements IModBusEvent {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final List<RegistryData<?>> registries = new ArrayList();

    public <V extends IForgeRegistryEntry<V>> Supplier<IForgeRegistry<V>> create(RegistryBuilder<V> builder) {
        return this.create(builder, null);
    }

    public <V extends IForgeRegistryEntry<V>> Supplier<IForgeRegistry<V>> create(RegistryBuilder<V> builder, @Nullable Consumer<IForgeRegistry<V>> onFill) {
        RegistryHolder registryHolder = new RegistryHolder();
        this.registries.add(new RegistryData<V>(builder, registryHolder, onFill));
        return registryHolder;
    }

    void fill() {
        IdentityHashMap<RegistryBuilder, IForgeRegistry> builtRegistries = new IdentityHashMap<RegistryBuilder, IForgeRegistry>();
        RuntimeException aggregate = new RuntimeException("Failed to create some forge registries, see suppressed exceptions for details");
        for (RegistryData<?> registryData : this.registries) {
            RegistryBuilder<?> builder2 = registryData.builder();
            try {
                builtRegistries.put(builder2, builder2.create());
            }
            catch (Exception e) {
                aggregate.addSuppressed(e);
            }
        }
        builtRegistries.forEach((builder, reg) -> {
            try {
                RegistryAccess.RegistryData dataPackRegistryData = builder.getDataPackRegistryData();
                if (dataPackRegistryData != null) {
                    if (!BuiltinRegistries.f_123858_.m_7804_(reg.getRegistryName())) {
                        DataPackRegistriesHooks.addRegistryCodec(dataPackRegistryData);
                        RegistryManager.registerToBuiltinRegistry((ForgeRegistry)reg);
                    }
                } else if (builder.getHasWrapper() && !Registry.f_122897_.m_7804_(reg.getRegistryName())) {
                    RegistryManager.registerToRootRegistry((ForgeRegistry)reg);
                }
            }
            catch (Exception e) {
                aggregate.addSuppressed(e);
            }
        });
        for (RegistryData<?> data : this.registries) {
            IForgeRegistry registry = (IForgeRegistry)builtRegistries.get(data.builder);
            if (registry == null) continue;
            data.registryHolder.registry = registry;
            try {
                if (data.onFill == null) continue;
                data.onFill.accept(registry);
            }
            catch (Exception e) {
                aggregate.addSuppressed(e);
            }
        }
        if (aggregate.getSuppressed().length > 0) {
            LOGGER.error("", (Throwable)aggregate);
            throw aggregate;
        }
    }

    public String toString() {
        return "RegistryEvent.NewRegistry";
    }

    private static class RegistryHolder<V extends IForgeRegistryEntry<V>>
    implements Supplier<IForgeRegistry<V>> {
        IForgeRegistry<V> registry = null;

        private RegistryHolder() {
        }

        @Override
        public IForgeRegistry<V> get() {
            return this.registry;
        }
    }

    private record RegistryData<V extends IForgeRegistryEntry<V>>(RegistryBuilder<V> builder, RegistryHolder<V> registryHolder, Consumer<IForgeRegistry<V>> onFill) {
    }
}

