/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.registries;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolderRegistry;
import net.minecraftforge.registries.RegistryManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RegistryObject<T>
implements Supplier<T> {
    @Nullable
    private final ResourceLocation name;
    @Nullable
    private ResourceKey<T> key;
    private final boolean optionalRegistry;
    @Nullable
    private T value;
    @Nullable
    private Holder<T> holder;
    private static final RegistryObject<?> EMPTY = new RegistryObject();

    @Deprecated(forRemoval=true, since="1.18.2")
    public static <T extends IForgeRegistryEntry<T>, U extends T> RegistryObject<U> of(ResourceLocation name, Supplier<Class<? super T>> registryType) {
        return new RegistryObject<T>(name, registryType);
    }

    @Deprecated(forRemoval=true, since="1.18.2")
    public static <T extends IForgeRegistryEntry<T>, U extends T> RegistryObject<U> of(ResourceLocation name, IForgeRegistry<T> registry) {
        return new RegistryObject<T>(name, registry);
    }

    public static <T extends IForgeRegistryEntry<T>, U extends T> RegistryObject<U> create(ResourceLocation name, IForgeRegistry<T> registry) {
        return new RegistryObject<T>(name, registry);
    }

    @Deprecated(forRemoval=true, since="1.18.2")
    public static <T extends IForgeRegistryEntry<T>, U extends T> RegistryObject<U> of(ResourceLocation name, Class<T> baseType, String modid) {
        return new RegistryObject<T>(name, baseType, modid);
    }

    @Deprecated(forRemoval=true, since="1.18.2")
    public static <T, U extends T> RegistryObject<U> of(ResourceLocation name, ResourceKey<? extends Registry<T>> registryKey, String modid) {
        return new RegistryObject<T>(name, registryKey.m_135782_(), modid, false);
    }

    public static <T, U extends T> RegistryObject<U> create(ResourceLocation name, ResourceKey<? extends Registry<T>> registryKey, String modid) {
        return new RegistryObject<T>(name, registryKey.m_135782_(), modid, false);
    }

    public static <T, U extends T> RegistryObject<U> createOptional(ResourceLocation name, ResourceKey<? extends Registry<T>> registryKey, String modid) {
        return new RegistryObject<T>(name, registryKey.m_135782_(), modid, true);
    }

    @Deprecated(forRemoval=true, since="1.18.2")
    public static <T, U extends T> RegistryObject<U> of(ResourceLocation name, ResourceLocation registryName, String modid) {
        return new RegistryObject<T>(name, registryName, modid, false);
    }

    public static <T, U extends T> RegistryObject<U> create(ResourceLocation name, ResourceLocation registryName, String modid) {
        return new RegistryObject<T>(name, registryName, modid, false);
    }

    public static <T, U extends T> RegistryObject<U> createOptional(ResourceLocation name, ResourceLocation registryName, String modid) {
        return new RegistryObject<T>(name, registryName, modid, true);
    }

    private static <T> RegistryObject<T> empty() {
        RegistryObject<?> t = EMPTY;
        return t;
    }

    private RegistryObject() {
        this.name = null;
        this.optionalRegistry = false;
    }

    @Deprecated(forRemoval=true, since="1.18.2")
    private <V extends IForgeRegistryEntry<V>> RegistryObject(ResourceLocation name, Supplier<Class<? super V>> registryType) {
        this(name, RegistryManager.ACTIVE.getRegistry(registryType.get()));
    }

    private <V extends IForgeRegistryEntry<V>> RegistryObject(ResourceLocation name, IForgeRegistry<V> registry) {
        if (registry == null) {
            throw new IllegalArgumentException("Invalid registry argument, must not be null");
        }
        this.name = name;
        this.optionalRegistry = false;
        ObjectHolderRegistry.addHandler(pred -> {
            if (pred.test(registry.getRegistryName())) {
                this.updateReference(registry);
            }
        });
        this.updateReference(registry);
    }

    @Deprecated(forRemoval=true, since="1.18.2")
    private <V extends IForgeRegistryEntry<V>> RegistryObject(ResourceLocation name, final Class<V> baseType, final String modid) {
        this.name = name;
        this.optionalRegistry = false;
        final Throwable callerStack = new Throwable("Calling Site from mod: " + modid);
        ObjectHolderRegistry.addHandler(new Consumer<Predicate<ResourceLocation>>(){
            private IForgeRegistry<V> registry;
            private boolean invalidRegistry = false;

            @Override
            public void accept(Predicate<ResourceLocation> pred) {
                if (this.invalidRegistry) {
                    return;
                }
                if (this.registry == null) {
                    this.registry = RegistryManager.ACTIVE.getRegistry(baseType);
                    if (this.registry == null) {
                        this.invalidRegistry = true;
                        throw new IllegalStateException("Unable to find registry for type " + baseType.getName() + " for mod \"" + modid + "\". Check the 'caused by' to see further stack.", callerStack);
                    }
                }
                if (pred.test(this.registry.getRegistryName())) {
                    RegistryObject.this.updateReference(this.registry);
                }
            }
        });
        IForgeRegistry<V> registry = RegistryManager.ACTIVE.getRegistry(baseType);
        if (registry != null) {
            this.updateReference(registry);
        }
    }

    private RegistryObject(ResourceLocation name, final ResourceLocation registryName, final String modid, boolean optionalRegistry) {
        this.name = name;
        this.key = ResourceKey.m_135785_((ResourceKey)ResourceKey.m_135788_((ResourceLocation)registryName), (ResourceLocation)name);
        this.optionalRegistry = optionalRegistry;
        final Throwable callerStack = new Throwable("Calling Site from mod: " + modid);
        ObjectHolderRegistry.addHandler(new Consumer<Predicate<ResourceLocation>>(){
            private boolean registryExists = false;
            private boolean invalidRegistry = false;

            @Override
            public void accept(Predicate<ResourceLocation> pred) {
                if (this.invalidRegistry) {
                    return;
                }
                if (!RegistryObject.this.optionalRegistry && !this.registryExists) {
                    if (!RegistryObject.registryExists(registryName)) {
                        this.invalidRegistry = true;
                        throw new IllegalStateException("Unable to find registry with key " + String.valueOf(registryName) + " for mod \"" + modid + "\". Check the 'caused by' to see further stack.", callerStack);
                    }
                    this.registryExists = true;
                }
                if (pred.test(registryName)) {
                    RegistryObject.this.updateReference(registryName);
                }
            }
        });
        this.updateReference(registryName);
    }

    @Override
    @NotNull
    public T get() {
        T ret = this.value;
        Objects.requireNonNull(ret, () -> "Registry Object not present: " + String.valueOf(this.name));
        return ret;
    }

    @Deprecated(since="1.18.1")
    public void updateReference(IForgeRegistry<? extends T> registry) {
        if (this.name == null) {
            return;
        }
        if (registry.containsKey(this.name)) {
            this.value = registry.getValue(this.name);
            if (this.key == null) {
                this.key = ResourceKey.m_135785_(registry.getRegistryKey(), (ResourceLocation)this.name);
            }
            this.holder = registry.getHolder((T)this.name).orElse(null);
        } else {
            this.value = null;
            this.holder = null;
        }
    }

    void updateReference(Registry<? extends T> registry) {
        if (this.name == null) {
            return;
        }
        if (registry.m_7804_(this.name)) {
            this.value = registry.m_7745_(this.name);
            if (this.key == null) {
                this.key = ResourceKey.m_135785_((ResourceKey)registry.m_123023_(), (ResourceLocation)this.name);
            }
            this.holder = registry.m_203636_(this.key).orElse(null);
        } else {
            this.value = null;
            this.holder = null;
        }
    }

    void updateReference(ResourceLocation registryName) {
        if (this.name == null) {
            return;
        }
        ForgeRegistry forgeRegistry = RegistryManager.ACTIVE.getRegistry(registryName);
        if (forgeRegistry != null) {
            this.updateReference(forgeRegistry);
            return;
        }
        Registry vanillaRegistry = (Registry)Registry.f_122897_.m_7745_(registryName);
        if (vanillaRegistry != null) {
            this.updateReference(vanillaRegistry);
            return;
        }
        Registry builtinRegistry = (Registry)BuiltinRegistries.f_123858_.m_7745_(registryName);
        if (builtinRegistry != null) {
            this.updateReference(builtinRegistry);
            return;
        }
        this.value = null;
        this.holder = null;
    }

    private static boolean registryExists(ResourceLocation registryName) {
        return RegistryManager.ACTIVE.getRegistry(registryName) != null || Registry.f_122897_.m_7804_(registryName) || BuiltinRegistries.f_123858_.m_7804_(registryName);
    }

    public ResourceLocation getId() {
        return this.name;
    }

    @Nullable
    public ResourceKey<T> getKey() {
        return this.key;
    }

    public Stream<T> stream() {
        return this.isPresent() ? Stream.of(this.get()) : Stream.of(new Object[0]);
    }

    public boolean isPresent() {
        return this.value != null;
    }

    public void ifPresent(Consumer<? super T> consumer) {
        if (this.isPresent()) {
            consumer.accept(this.get());
        }
    }

    public RegistryObject<T> filter(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        if (!this.isPresent()) {
            return this;
        }
        return predicate.test(this.get()) ? this : RegistryObject.empty();
    }

    public <U> Optional<U> map(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper);
        if (!this.isPresent()) {
            return Optional.empty();
        }
        return Optional.ofNullable(mapper.apply(this.get()));
    }

    public <U> Optional<U> flatMap(Function<? super T, Optional<U>> mapper) {
        Objects.requireNonNull(mapper);
        if (!this.isPresent()) {
            return Optional.empty();
        }
        return Objects.requireNonNull(mapper.apply(this.get()));
    }

    public <U> Supplier<U> lazyMap(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper);
        return () -> this.isPresent() ? mapper.apply((T)this.get()) : null;
    }

    public T orElse(T other) {
        return this.isPresent() ? this.get() : other;
    }

    public T orElseGet(Supplier<? extends T> other) {
        return this.isPresent() ? this.get() : other.get();
    }

    public <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        if (this.isPresent()) {
            return this.get();
        }
        throw (Throwable)exceptionSupplier.get();
    }

    @NotNull
    public Optional<Holder<T>> getHolder() {
        if (this.holder == null && this.key != null && RegistryObject.registryExists(this.key.m_211136_())) {
            ResourceLocation registryName = this.key.m_211136_();
            Registry registry = (Registry)Registry.f_122897_.m_7745_(registryName);
            if (registry == null) {
                registry = (Registry)BuiltinRegistries.f_123858_.m_7745_(registryName);
            }
            if (registry != null) {
                this.holder = registry.m_203538_(this.key);
            }
        }
        return Optional.ofNullable(this.holder);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RegistryObject) {
            return Objects.equals(((RegistryObject)obj).name, this.name);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.name);
    }
}

