/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.generators;

import com.google.gson.JsonObject;
import com.mojang.math.Transformation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.util.TransformationHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class BlockModelBuilder
extends ModelBuilder<BlockModelBuilder> {
    private final RootTransformBuilder rootTransform = new RootTransformBuilder(super.rootTransforms());

    public BlockModelBuilder(ResourceLocation outputLocation, ExistingFileHelper existingFileHelper) {
        super(outputLocation, existingFileHelper);
    }

    @Deprecated(forRemoval=true, since="1.19.4")
    public RootTransformBuilder rootTransform() {
        return this.rootTransform;
    }

    @Override
    public JsonObject toJson() {
        return super.toJson();
    }

    @Deprecated(forRemoval=true, since="1.19.4")
    public class RootTransformBuilder {
        private final ModelBuilder.RootTransformsBuilder rootTransforms;

        private RootTransformBuilder(ModelBuilder.RootTransformsBuilder rootTransforms) {
            this.rootTransforms = rootTransforms;
        }

        public RootTransformBuilder translation(Vector3f translation) {
            this.rootTransforms.translation(translation);
            return this;
        }

        public RootTransformBuilder translation(float x, float y, float z) {
            return this.translation(new Vector3f(x, y, z));
        }

        public RootTransformBuilder rotation(Quaternionf rotation) {
            this.rootTransforms.rotation(rotation);
            return this;
        }

        public RootTransformBuilder rotation(float x, float y, float z, boolean isDegrees) {
            return this.rotation(TransformationHelper.quatFromXYZ(x, y, z, isDegrees));
        }

        public RootTransformBuilder leftRotation(Quaternionf leftRotation) {
            return this.rotation(leftRotation);
        }

        public RootTransformBuilder leftRotation(float x, float y, float z, boolean isDegrees) {
            return this.leftRotation(TransformationHelper.quatFromXYZ(x, y, z, isDegrees));
        }

        public RootTransformBuilder rightRotation(Quaternionf rightRotation) {
            this.rootTransforms.rightRotation(rightRotation);
            return this;
        }

        public RootTransformBuilder rightRotation(float x, float y, float z, boolean isDegrees) {
            return this.rightRotation(TransformationHelper.quatFromXYZ(x, y, z, isDegrees));
        }

        public RootTransformBuilder postRotation(Quaternionf postRotation) {
            return this.rightRotation(postRotation);
        }

        public RootTransformBuilder postRotation(float x, float y, float z, boolean isDegrees) {
            return this.postRotation(TransformationHelper.quatFromXYZ(x, y, z, isDegrees));
        }

        public RootTransformBuilder scale(float scale) {
            return this.scale(new Vector3f(scale, scale, scale));
        }

        public RootTransformBuilder scale(float xScale, float yScale, float zScale) {
            return this.scale(new Vector3f(xScale, yScale, zScale));
        }

        public RootTransformBuilder scale(Vector3f scale) {
            this.rootTransforms.scale(scale);
            return this;
        }

        public RootTransformBuilder transform(Transformation transformation) {
            this.rootTransforms.transform(transformation);
            return this;
        }

        public RootTransformBuilder origin(Vector3f origin) {
            this.rootTransforms.origin(origin);
            return this;
        }

        public RootTransformBuilder origin(TransformOrigin origin) {
            this.rootTransforms.origin(origin.toNewOrigin());
            return this;
        }

        public BlockModelBuilder end() {
            return BlockModelBuilder.this;
        }

        public JsonObject toJson() {
            return this.rootTransforms.toJson();
        }

        @Deprecated(forRemoval=true, since="1.19.4")
        public static enum TransformOrigin implements StringRepresentable
        {
            CENTER(TransformationHelper.TransformOrigin.CENTER),
            CORNER(TransformationHelper.TransformOrigin.CORNER),
            OPPOSING_CORNER(TransformationHelper.TransformOrigin.OPPOSING_CORNER);

            private final TransformationHelper.TransformOrigin newOrigin;

            private TransformOrigin(TransformationHelper.TransformOrigin newOrigin) {
                this.newOrigin = newOrigin;
            }

            public Vector3f getVector() {
                return this.newOrigin.getVector();
            }

            @NotNull
            public String m_7912_() {
                return this.newOrigin.m_7912_();
            }

            private TransformationHelper.TransformOrigin toNewOrigin() {
                return this.newOrigin;
            }

            @Nullable
            public static TransformOrigin fromString(String originName) {
                if (CENTER.m_7912_().equals(originName)) {
                    return CENTER;
                }
                if (CORNER.m_7912_().equals(originName)) {
                    return CORNER;
                }
                if (OPPOSING_CORNER.m_7912_().equals(originName)) {
                    return OPPOSING_CORNER;
                }
                return null;
            }
        }
    }
}

