/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.crafting.ingredients;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.ingredients.AbstractIngredient;
import net.minecraftforge.common.crafting.ingredients.IIngredientSerializer;
import org.jetbrains.annotations.Nullable;

public class IntersectionIngredient
extends AbstractIngredient {
    private final List<Ingredient> children;
    private final boolean isSimple;
    private ItemStack[] intersectedMatchingStacks = null;
    private IntList packedMatchingStacks = null;
    public static final Codec<IntersectionIngredient> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Ingredient.f_291570_.listOf().fieldOf("children").forGetter(i -> i.children)).apply((Applicative)builder, IntersectionIngredient::new));
    public static final IIngredientSerializer<IntersectionIngredient> SERIALIZER = new IIngredientSerializer<IntersectionIngredient>(){

        @Override
        public Codec<? extends IntersectionIngredient> codec() {
            return CODEC;
        }

        @Override
        public IntersectionIngredient read(FriendlyByteBuf buffer) {
            return new IntersectionIngredient(buffer.m_236845_(Ingredient::m_43940_));
        }

        @Override
        public void write(FriendlyByteBuf buffer, IntersectionIngredient value) {
            buffer.m_236828_(value.children, (b, i) -> i.m_43923_(b));
        }
    };

    public static Ingredient of(Ingredient ... ingredients) {
        if (ingredients.length == 0) {
            throw new IllegalArgumentException("Cannot create an IntersectionIngredient with no children, use Ingredient.of() to create an empty ingredient");
        }
        if (ingredients.length == 1) {
            return ingredients[0];
        }
        return new IntersectionIngredient(Arrays.asList(ingredients));
    }

    private IntersectionIngredient(List<Ingredient> children) {
        if (children.size() < 2) {
            throw new IllegalArgumentException("Cannot create an IntersectionIngredient with one or no children");
        }
        this.children = Collections.unmodifiableList(children);
        this.isSimple = children.stream().allMatch(Ingredient::isSimple);
    }

    public boolean test(@Nullable ItemStack stack) {
        if (stack == null || stack.m_41619_()) {
            return false;
        }
        for (Ingredient ingredient : this.children) {
            if (ingredient.test(stack)) continue;
            return false;
        }
        return true;
    }

    public ItemStack[] m_43908_() {
        if (this.intersectedMatchingStacks == null) {
            this.intersectedMatchingStacks = (ItemStack[])Arrays.stream(this.children.get(0).m_43908_()).filter(stack -> {
                for (int i = 1; i < this.children.size(); ++i) {
                    if (this.children.get(i).test(stack)) continue;
                    return false;
                }
                return true;
            }).toArray(ItemStack[]::new);
        }
        return this.intersectedMatchingStacks;
    }

    public boolean m_43947_() {
        return this.children.stream().anyMatch(Ingredient::m_43947_);
    }

    @Override
    public boolean isSimple() {
        return this.isSimple;
    }

    protected void invalidate() {
        super.invalidate();
        this.intersectedMatchingStacks = null;
        this.packedMatchingStacks = null;
    }

    public IntList m_43931_() {
        if (this.packedMatchingStacks == null || this.checkInvalidation()) {
            this.markValid();
            ItemStack[] matchingStacks = this.m_43908_();
            this.packedMatchingStacks = new IntArrayList(matchingStacks.length);
            for (ItemStack stack : matchingStacks) {
                this.packedMatchingStacks.add(StackedContents.m_36496_((ItemStack)stack));
            }
            this.packedMatchingStacks.sort(IntComparators.NATURAL_COMPARATOR);
        }
        return this.packedMatchingStacks;
    }

    public IIngredientSerializer<IntersectionIngredient> serializer() {
        return SERIALIZER;
    }
}

