/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.network;

import com.mojang.logging.LogUtils;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.ResourceLocationException;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.network.ChannelRegistrationChangeEvent;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.ChannelBuilder;
import net.minecraftforge.network.EventNetworkChannel;
import net.minecraftforge.network.NetworkContext;
import net.minecraftforge.network.NetworkInstance;
import net.minecraftforge.network.NetworkRegistry;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;

@ApiStatus.Internal
public class ChannelListManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    static final EventNetworkChannel REGISTER = ChannelBuilder.named("minecraft:register").optional().eventNetworkChannel().addListener(ChannelListManager::registerListener);
    static final EventNetworkChannel UNREGISTER = ChannelBuilder.named("minecraft:unregister").optional().eventNetworkChannel().addListener(ChannelListManager::unregisterListener);

    private static void registerListener(CustomPayloadEvent evt) {
        CustomPayloadEvent.Context ctx = evt.getSource();
        ChannelListManager.updateFrom(ctx, evt.getPayload(), ChannelRegistrationChangeEvent.Type.REGISTER);
        ctx.setPacketHandled(true);
        if (ctx.isClientSide()) {
            ChannelListManager.addChannels(ctx.getConnection());
        }
    }

    private static void unregisterListener(CustomPayloadEvent evt) {
        CustomPayloadEvent.Context ctx = evt.getSource();
        ChannelListManager.updateFrom(ctx, evt.getPayload(), ChannelRegistrationChangeEvent.Type.UNREGISTER);
        ctx.setPacketHandled(true);
    }

    public static void addChannels(Connection connection) {
        ChannelListManager.addChannels(connection, NetworkRegistry.buildChannelVersions().keySet().stream().filter(rl -> !"minecraft".equals(rl.m_135827_())).toList());
    }

    public static void addChannels(Connection connection, ResourceLocation ... channels) {
        ChannelListManager.addChannels(connection, Arrays.asList(channels));
    }

    public static void addChannels(Connection connection, Collection<ResourceLocation> channels) {
        NetworkContext list = NetworkContext.get(connection);
        HashSet<ResourceLocation> toSend = new HashSet<ResourceLocation>();
        for (ResourceLocation channel : channels) {
            if (!list.sentChannels.add(channel)) continue;
            toSend.add(channel);
        }
        ChannelListManager.sendChannels(REGISTER, connection, toSend);
    }

    public static void removeChannels(Connection connection, ResourceLocation ... channels) {
        ChannelListManager.removeChannels(connection, Arrays.asList(channels));
    }

    public static void removeChannels(Connection connection, Collection<ResourceLocation> channels) {
        NetworkContext list = NetworkContext.get(connection);
        HashSet<ResourceLocation> toSend = new HashSet<ResourceLocation>();
        for (ResourceLocation channel : channels) {
            if (!list.sentChannels.remove(channel)) continue;
            toSend.add(channel);
        }
        ChannelListManager.sendChannels(UNREGISTER, connection, toSend);
    }

    private static void sendChannels(EventNetworkChannel channel, Connection connection, Collection<ResourceLocation> channels) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        for (ResourceLocation c : channels) {
            buf.writeBytes(c.toString().getBytes(StandardCharsets.UTF_8));
            buf.writeByte(0);
        }
        channel.send(buf, connection);
    }

    private static void updateFrom(CustomPayloadEvent.Context source, FriendlyByteBuf buffer, ChannelRegistrationChangeEvent.Type changeType) {
        byte[] data = new byte[Math.max(buffer.readableBytes(), 0)];
        buffer.readBytes(data);
        HashSet<ResourceLocation> changed = new HashSet<ResourceLocation>();
        int last = 0;
        for (int cur = 0; cur < data.length; ++cur) {
            if (data[cur] != 0) continue;
            String channel = new String(data, last, cur - last, StandardCharsets.UTF_8);
            try {
                changed.add(new ResourceLocation(channel));
            }
            catch (ResourceLocationException ex) {
                LOGGER.warn("Invalid channel name received: {}. Ignoring", (Object)channel);
            }
            last = cur + 1;
        }
        ForgeEventFactory.onChannelRegistrationChange(source.getConnection(), changeType, changed);
        NetworkContext list = NetworkContext.get(source.getConnection());
        for (ResourceLocation channel : changed) {
            NetworkInstance target;
            boolean fire = changeType == ChannelRegistrationChangeEvent.Type.UNREGISTER ? list.remoteChannels.remove(channel) : list.remoteChannels.add(channel);
            if (!fire || (target = NetworkRegistry.findTarget(channel)) == null) continue;
            target.registrationChange(changeType == ChannelRegistrationChangeEvent.Type.REGISTER);
        }
    }
}

