/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapDecoder;
import com.mojang.serialization.MapEncoder;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.ConditionalAdvancement;
import net.minecraftforge.common.crafting.conditions.ConditionCodec;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class ConditionalRecipe {
    private static final Codec<Recipe<?>> CODEC = Codec.of((MapEncoder)new MapEncoder.Implementation<Recipe<?>>(){

        public <T> RecordBuilder<T> encode(Recipe<?> input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
            if (!(input instanceof Wrapper)) {
                new IllegalStateException("ConditionalRecipe.CODEC can only be used during data gen, how did you get here?");
            }
            Wrapper wrapper = (Wrapper)input;
            if (wrapper.main != null) {
                prefix.add("forge:condition", ICondition.CODEC.encodeStart(ops, (Object)wrapper.main));
            } else if (wrapper.recipes.size() == 1) {
                prefix.add("forge:condition", ICondition.CODEC.encodeStart(ops, (Object)wrapper.recipes.get(0).condition()));
            }
            ArrayList<Object> recipes = new ArrayList<Object>();
            for (InnerRecipe recipe : wrapper.recipes) {
                JsonObject json = (JsonObject)2.json(Recipe.f_302387_, recipe.recipe());
                if (wrapper.recipes.size() > 1) {
                    json.add("forge:condition", 2.json(ICondition.CODEC, recipe.condition()));
                }
                recipes.add(JsonOps.INSTANCE.convertTo(ops, (JsonElement)json));
            }
            prefix.add("recipes", ops.createList(recipes.stream()));
            return prefix;
        }

        public <T> Stream<T> keys(DynamicOps<T> ops) {
            return Stream.of(ops.createString("forge:condition"), ops.createString("recipes"));
        }

        private static <T> JsonElement json(Codec<T> codec, T object) {
            return (JsonElement)Util.m_260975_((DataResult)codec.encodeStart((DynamicOps)JsonOps.INSTANCE, object), IllegalStateException::new);
        }
    }, (MapDecoder)new MapDecoder.Implementation<Recipe<?>>(){

        public <T> DataResult<Recipe<?>> decode(DynamicOps<T> ops, MapLike<T> input) {
            ICondition.IContext context = ConditionCodec.getContext(ops);
            JsonElement json = (JsonElement)ops.convertTo((DynamicOps)JsonOps.INSTANCE, input.get("recipes"));
            try {
                JsonArray recipes = GsonHelper.m_13924_((JsonElement)json, (String)"recipes");
                int idx = 0;
                for (JsonElement entry : recipes) {
                    JsonObject conditionjson;
                    ICondition condition;
                    JsonObject object = GsonHelper.m_13918_((JsonElement)entry, (String)("recipe[" + idx++ + "]"));
                    if (object.has("forge:condition") && !(condition = (ICondition)Util.m_260975_((DataResult)ICondition.SAFE_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)(conditionjson = GsonHelper.m_13930_((JsonObject)object, (String)"forge:condition"))), JsonSyntaxException::new)).test(context)) continue;
                    ResourceLocation type = new ResourceLocation(GsonHelper.m_13906_((JsonObject)object, (String)"type"));
                    RecipeSerializer<?> serializer = ForgeRegistries.RECIPE_SERIALIZERS.getValue(type);
                    if (serializer == null) {
                        return DataResult.error(() -> "Invalid or unsupported recipe type '" + type + "' Conditions were successful, but unknown type");
                    }
                    DataResult parsed = serializer.m_292673_().parse((DynamicOps)JsonOps.INSTANCE, (Object)object);
                    if (parsed.error().isPresent()) {
                        return DataResult.error(() -> ((DataResult.PartialResult)((DataResult.PartialResult)parsed.error().get())).message());
                    }
                    if (!parsed.result().isPresent()) {
                        return DataResult.error(() -> "Recipe passed all conditions but did not parse a valid return");
                    }
                    return DataResult.success((Object)((Recipe)parsed.result().get()));
                }
                return DataResult.error(() -> "No recipe passed conditions, if this is the case, you should have an outer condition.");
            }
            catch (JsonSyntaxException e) {
                return DataResult.error(() -> e.getMessage());
            }
        }

        public <T> Stream<T> keys(DynamicOps<T> ops) {
            return Stream.of(ops.createString("forge:condition"), ops.createString("recipes"));
        }
    }).codec();
    public static final RecipeSerializer<Recipe<?>> SERIALZIER = new RecipeSerializer<Recipe<?>>(){

        public Codec<Recipe<?>> m_292673_() {
            return CODEC;
        }

        public Recipe<?> m_8005_(FriendlyByteBuf buffer) {
            throw new UnsupportedOperationException("ConditionaRecipe.SERIALIZER does not support decoding from network");
        }

        public void m_6178_(FriendlyByteBuf buffer, Recipe<?> recipe) {
            throw new UnsupportedOperationException("ConditionaRecipe.SERIALIZER does not support encoding to network");
        }
    };

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private List<InnerRecipe> recipes = new ArrayList<InnerRecipe>();
        private List<InnerAdvancement> advancements = new ArrayList<InnerAdvancement>();
        private RecipeOutput bouncer = new RecipeOutput(){

            public void m_292927_(ResourceLocation id, Recipe<?> value, @Nullable AdvancementHolder advancement) {
                this.recipe(id, value, advancement);
            }

            public Advancement.Builder m_293552_() {
                return Advancement.Builder.m_285878_().m_138396_(RecipeBuilder.f_236353_);
            }

            public void accept(ResourceLocation id, Recipe<?> recipe, ResourceLocation advancementId, JsonElement advancement) {
                AdvancementHolder holder = null;
                if (advancement != null) {
                    Advancement adv = (Advancement)Util.m_260975_((DataResult)Advancement.f_303179_.parse((DynamicOps)JsonOps.INSTANCE, (Object)advancement), JsonParseException::new);
                    holder = new AdvancementHolder(advancementId, adv);
                }
                this.m_292927_(id, recipe, holder);
            }
        };
        @Nullable
        private ICondition condition;
        @Nullable
        private ICondition mainCondition;
        @Nullable
        private ResourceLocation advancementId;

        public Builder mainCondition(ICondition value) {
            if (this.mainCondition != null) {
                throw new IllegalStateException("Attempted to overrride the main condition, only one is allowed to be set");
            }
            this.mainCondition = value;
            return this;
        }

        public Builder condition(ICondition value) {
            if (this.condition != null) {
                throw new IllegalStateException("Attempted to override a previous set condition before adding a recipe");
            }
            this.condition = value;
            return this;
        }

        public Builder recipe(Consumer<RecipeOutput> callable) {
            callable.accept(this.bouncer);
            return this;
        }

        public Builder recipe(ResourceLocation id, Recipe<?> recipe, @Nullable AdvancementHolder advancement) {
            if (this.condition == null) {
                throw new IllegalStateException("Can not add a recipe with no conditions.");
            }
            this.recipes.add(new InnerRecipe(this.condition, recipe));
            if (advancement != null) {
                this.advancements.add(new InnerAdvancement(this.condition, advancement));
            }
            this.condition = null;
            return this;
        }

        public Builder advancement(ResourceLocation id) {
            this.advancementId = id;
            return this;
        }

        public void save(RecipeOutput out, String namespace, String path) {
            this.save(out, new ResourceLocation(namespace, path));
        }

        public void save(RecipeOutput out, ResourceLocation id) {
            if (this.condition != null) {
                throw new IllegalStateException("Invalid ConditionalRecipe builder, Orphaned conditions");
            }
            if (this.recipes.isEmpty()) {
                throw new IllegalStateException("Invalid ConditionalRecipe builder, No recipes");
            }
            JsonObject advancement = null;
            if (!this.advancements.isEmpty()) {
                ConditionalAdvancement.Builder adv = ConditionalAdvancement.builder();
                for (InnerAdvancement data : this.advancements) {
                    adv.condition(data.condition()).advancement(data.advancement());
                }
                if (this.advancementId == null) {
                    this.advancementId = id.m_246208_("recipes/");
                }
                advancement = adv.build();
            } else {
                this.advancementId = null;
            }
            out.accept(id, (Recipe)new Wrapper(this.mainCondition, this.recipes), this.advancementId, (JsonElement)advancement);
        }
    }

    private static class Wrapper
    implements Recipe<Container> {
        @Nullable
        private final ICondition main;
        private final List<InnerRecipe> recipes;

        public boolean m_5818_(Container inv, Level level) {
            return false;
        }

        public ItemStack m_5874_(Container inv, RegistryAccess reg) {
            return null;
        }

        public boolean m_8004_(int width, int height) {
            return false;
        }

        public ItemStack m_8043_(RegistryAccess reg) {
            return null;
        }

        public RecipeSerializer<?> m_7707_() {
            return SERIALZIER;
        }

        public RecipeType<?> m_6671_() {
            throw new UnsupportedOperationException();
        }

        private Wrapper(@Nullable ICondition main, List<InnerRecipe> recipes) {
            this.main = main;
            this.recipes = recipes;
        }
    }

    private record InnerAdvancement(ICondition condition, AdvancementHolder advancement) {
    }

    private record InnerRecipe(ICondition condition, Recipe<?> recipe) {
    }
}

