/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.resource;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.SharedConstants;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.CompositePackResources;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraftforge.fml.Logging;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.fml.ModLoadingStage;
import net.minecraftforge.fml.ModLoadingWarning;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.resource.DelegatingPackResources;
import net.minecraftforge.resource.PathPackResources;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class ResourcePackLoader {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void loadResourcePacks(PackRepository resourcePacks, boolean client) {
        resourcePacks.addPackFinder(repo -> ResourcePackLoader.findPacks(repo, client));
    }

    @NotNull
    public static PathPackResources createPackForMod(IModFileInfo mf) {
        return new ModPathPackResources(mf.getFile(), new String[0]);
    }

    public static List<String> getPackNames() {
        return ModList.get().applyForEachModFile(mf -> "mod:" + ((IModInfo)mf.getModInfos().get(0)).getModId()).filter(n -> !n.equals("mod:minecraft")).collect(Collectors.toList());
    }

    public static <V> Comparator<Map.Entry<String, V>> getSorter() {
        ArrayList<String> order = new ArrayList<String>();
        order.add("vanilla");
        order.add("mod_resources");
        ModList.get().getModFiles().stream().filter(mf -> mf.requiredLanguageLoaders().stream().noneMatch(ls -> ls.languageName().equals("minecraft"))).map(e -> ((IModInfo)e.getMods().get(0)).getModId()).map(e -> "mod:" + e).forEach(order::add);
        Object2IntOpenHashMap order_f = new Object2IntOpenHashMap(order.size());
        for (int x = 0; x < order.size(); ++x) {
            order_f.put((Object)((String)order.get(x)), x);
        }
        return (arg_0, arg_1) -> ResourcePackLoader.lambda$getSorter$7((Object2IntMap)order_f, arg_0, arg_1);
    }

    private static void findPacks(Consumer<Pack> packAcceptor, boolean client) {
        PackType type = client ? PackType.CLIENT_RESOURCES : PackType.SERVER_DATA;
        int version = SharedConstants.m_183709_().m_264084_(type);
        ArrayList<PackResources> hiddenPacks = new ArrayList<PackResources>();
        for (IModFileInfo mod : ModList.get().getModFiles()) {
            if (mod.requiredLanguageLoaders().stream().anyMatch(ls -> ls.languageName().equals("minecraft"))) continue;
            IModFile file = mod.getFile();
            ModPathPackResources.Supplier supplier = new ModPathPackResources.Supplier(file);
            IModInfo modinfo = (IModInfo)file.getModInfos().get(0);
            String name = "mod:" + modinfo.getModId();
            Pack.Info meta = Pack.m_246334_((String)name, (Pack.ResourcesSupplier)supplier, (int)version);
            Pack pack = null;
            if (meta != null) {
                pack = Pack.m_245512_((String)name, (Component)Component.m_237113_((String)file.getFileName()), (boolean)false, (Pack.ResourcesSupplier)supplier, (Pack.Info)meta, (Pack.Position)Pack.Position.BOTTOM, (boolean)false, (PackSource)PackSource.f_10527_);
            }
            if (pack == null) {
                ModLoader.get().addWarning(new ModLoadingWarning(modinfo, ModLoadingStage.ERROR, "fml.modloading.brokenresources", new Object[]{file}));
                continue;
            }
            LOGGER.debug(Logging.CORE, "Generating PackInfo named {} for mod file {}", (Object)name, (Object)file.getFilePath());
            if (!client || mod.showAsResourcePack()) {
                packAcceptor.accept(pack);
                continue;
            }
            hiddenPacks.add(pack.m_10445_());
        }
        if (!hiddenPacks.isEmpty()) {
            DelegatingPackResources delegating = new DelegatingPackResources("mod_resources", false, new PackMetadataSection((Component)Component.m_237110_((String)"fml.resources.modresources", (Object[])new Object[]{hiddenPacks.size()}), version, Optional.empty()), hiddenPacks);
            Pack.ResourcesSupplier supplier = delegating.supplier();
            Pack modResourcesPack = Pack.m_245429_((String)"mod_resources", (Component)Component.m_237113_((String)"Mod Resources"), (boolean)true, (Pack.ResourcesSupplier)supplier, (PackType)type, (Pack.Position)Pack.Position.BOTTOM, (PackSource)PackSource.f_10527_);
            packAcceptor.accept(modResourcesPack);
        }
    }

    private static /* synthetic */ int lambda$getSorter$7(Object2IntMap order_f, Map.Entry e1, Map.Entry e2) {
        int i2;
        String s1 = (String)e1.getKey();
        String s2 = (String)e2.getKey();
        int i1 = order_f.getOrDefault((Object)s1, -1);
        if (i1 == (i2 = order_f.getOrDefault((Object)s2, -1)) && i1 == -1) {
            return s1.compareTo(s2);
        }
        if (i1 == -1) {
            return 1;
        }
        if (i2 == -1) {
            return -1;
        }
        return i2 - i1;
    }

    private static class ModPathPackResources
    extends PathPackResources {
        private final IModFile mod;
        private final String[] prefix;

        private ModPathPackResources(IModFile mod, String ... prefix) {
            super(mod.getFileName(), true, mod.getFilePath());
            this.mod = mod;
            this.prefix = prefix;
        }

        @Override
        @NotNull
        protected Path resolve(String ... paths) {
            if (this.prefix != null && this.prefix.length > 0) {
                String[] tmp = new String[this.prefix.length + paths.length];
                System.arraycopy(this.prefix, 0, tmp, 0, this.prefix.length);
                System.arraycopy(paths, 0, tmp, this.prefix.length, paths.length);
                return this.mod.findResource(tmp);
            }
            return this.mod.findResource(paths);
        }

        private static class Supplier
        implements Pack.ResourcesSupplier {
            private final IModFile mod;

            private Supplier(IModFile mod) {
                this.mod = mod;
            }

            public PackResources m_293078_(String packId) {
                return new ModPathPackResources(this.mod, new String[0]);
            }

            public PackResources m_247679_(String packId, Pack.Info info) {
                PackResources primary = this.m_293078_(packId);
                if (info.f_291122_().isEmpty()) {
                    return primary;
                }
                ArrayList<ModPathPackResources> lst = new ArrayList<ModPathPackResources>(info.f_291122_().size());
                for (String overlay : info.f_291122_()) {
                    lst.add(new ModPathPackResources(this.mod, overlay));
                }
                return new CompositePackResources(primary, lst);
            }
        }
    }
}

