/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.loot;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LootModifierManager
extends SimpleJsonResourceReloadListener {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final String FOLDER = "loot_modifiers";
    private Map<ResourceLocation, IGlobalLootModifier> modifiers = ImmutableMap.of();

    public LootModifierManager() {
        super(GSON, FOLDER);
    }

    protected Map<ResourceLocation, JsonElement> prepare(ResourceManager resources, ProfilerFiller profilerFiller) {
        ResourceLocation path = new ResourceLocation("forge", "loot_modifiers/global_loot_modifiers.json");
        ArrayList<ResourceLocation> toLoad = new ArrayList<ResourceLocation>();
        for (Resource resource : resources.getResourceStack(path)) {
            try {
                BufferedReader reader = resource.openAsReader();
                try {
                    JsonObject json = (JsonObject)GsonHelper.fromJson((Gson)GSON, (Reader)reader, JsonObject.class);
                    if (GsonHelper.getAsBoolean((JsonObject)json, (String)"replace", (boolean)false)) {
                        toLoad.clear();
                    }
                    for (JsonElement entry : GsonHelper.getAsJsonArray((JsonObject)json, (String)"entries")) {
                        ResourceLocation loc = new ResourceLocation(entry.getAsString());
                        toLoad.remove(loc);
                        toLoad.add(loc);
                    }
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            catch (IOException | RuntimeException ioexception) {
                LOGGER.error("Couldn't read global loot modifier list {} in data pack {}", (Object)path, (Object)resource.sourcePackId(), (Object)ioexception);
            }
        }
        Map ret = super.prepare(resources, profilerFiller);
        ret.keySet().removeIf(k -> !toLoad.contains(k));
        return ret;
    }

    protected void apply(Map<ResourceLocation, JsonElement> resources, ResourceManager resourceManagerIn, ProfilerFiller profilerIn) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        resources.forEach((location, json) -> IGlobalLootModifier.DIRECT_CODEC.parse((DynamicOps)JsonOps.INSTANCE, json).resultOrPartial(errorMsg -> LOGGER.warn("Could not decode GlobalLootModifier with json id {} - error: {}", location, errorMsg)).ifPresent(modifier -> builder.put(location, modifier)));
        this.modifiers = builder.build();
    }

    public Collection<IGlobalLootModifier> getAllLootMods() {
        return this.modifiers.values();
    }
}

