/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.extensions;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.VertexFormatElement;

public interface IForgeVertexFormat {
    public ImmutableList<VertexFormatElement> getElements();

    default public boolean hasPosition() {
        return this.getElements().stream().anyMatch(e -> e.getUsage() == VertexFormatElement.Usage.POSITION);
    }

    default public boolean hasNormal() {
        return this.getElements().stream().anyMatch(e -> e.getUsage() == VertexFormatElement.Usage.NORMAL);
    }

    default public boolean hasColor() {
        return this.getElements().stream().anyMatch(e -> e.getUsage() == VertexFormatElement.Usage.COLOR);
    }

    default public boolean hasUV(int which) {
        for (VertexFormatElement e : this.getElements()) {
            if (e.getUsage() != VertexFormatElement.Usage.UV || e.getIndex() != which) continue;
            return true;
        }
        return false;
    }
}

