/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.gui.overlay;

import com.google.common.collect.ImmutableList;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.FieldsAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.event.ForgeEventFactoryClient;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@FieldsAreNonnullByDefault
@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public final class ForgeLayeredDraw
extends LayeredDraw {
    private static int unknown = 0;
    private final Map<ResourceLocation, LayeredDraw.Layer> namedLayers = new HashMap<ResourceLocation, LayeredDraw.Layer>();
    private final Map<ResourceLocation, Map.Entry<LayeredDraw, BooleanSupplier>> subLayerStacks = new HashMap<ResourceLocation, Map.Entry<LayeredDraw, BooleanSupplier>>();
    private final List<ResourceLocation> order = new LinkedList<ResourceLocation>();
    private final List<ResourceLocation> expectedNames = new ArrayList<ResourceLocation>();
    private final ResourceLocation name;
    public static final ResourceLocation PRE_SLEEP_STACK = ResourceLocation.withDefaultNamespace((String)"pre_sleep_phase");
    public static final ResourceLocation CAMERA_OVERLAY = ResourceLocation.withDefaultNamespace((String)"camera_overlay");
    public static final ResourceLocation CROSSHAIR = ResourceLocation.withDefaultNamespace((String)"crosshair");
    public static final ResourceLocation HOTBAR = ResourceLocation.withDefaultNamespace((String)"hotbar");
    public static final ResourceLocation EXPERIENCE = ResourceLocation.withDefaultNamespace((String)"experience");
    public static final ResourceLocation POTION_EFFECTS = ResourceLocation.withDefaultNamespace((String)"potion_effects");
    public static final ResourceLocation BOSS_OVERLAY = ResourceLocation.withDefaultNamespace((String)"boss_overlay");
    public static final ResourceLocation POST_SLEEP_STACK = ResourceLocation.withDefaultNamespace((String)"post_sleep_phase");
    public static final ResourceLocation DEMO_OVERLAY = ResourceLocation.withDefaultNamespace((String)"demo");
    public static final ResourceLocation DEBUG_OVERLAY = ResourceLocation.withDefaultNamespace((String)"debug");
    public static final ResourceLocation SCOREBOARD = ResourceLocation.withDefaultNamespace((String)"scoreboard");
    public static final ResourceLocation HOTBAR_MESSAGE = ResourceLocation.withDefaultNamespace((String)"hotbar_message");
    public static final ResourceLocation TITLE_OVERLAY = ResourceLocation.withDefaultNamespace((String)"title");
    public static final ResourceLocation CHAT_OVERLAY = ResourceLocation.withDefaultNamespace((String)"chat_overlay");
    public static final ResourceLocation TAB_LIST = ResourceLocation.withDefaultNamespace((String)"tab_list");
    public static final ResourceLocation SUBTITLE_OVERLAY = ResourceLocation.withDefaultNamespace((String)"subtitle");
    public static final ResourceLocation VANILLA_ROOT = ResourceLocation.withDefaultNamespace((String)"vanilla_root");
    public static final ResourceLocation SLEEP_OVERLAY = ResourceLocation.withDefaultNamespace((String)"sleep_overlay");
    public static final ImmutableList<ResourceLocation> PRE_LIST = ImmutableList.of((Object)CAMERA_OVERLAY, (Object)CROSSHAIR, (Object)HOTBAR, (Object)EXPERIENCE, (Object)POTION_EFFECTS, (Object)BOSS_OVERLAY);
    public static final ImmutableList<ResourceLocation> POST_LIST = ImmutableList.of((Object)DEMO_OVERLAY, (Object)DEBUG_OVERLAY, (Object)SCOREBOARD, (Object)HOTBAR_MESSAGE, (Object)TITLE_OVERLAY, (Object)CHAT_OVERLAY, (Object)TAB_LIST, (Object)SUBTITLE_OVERLAY);
    public static final ImmutableList<ResourceLocation> COMBINE_LIST = ImmutableList.of((Object)PRE_SLEEP_STACK, (Object)SLEEP_OVERLAY, (Object)POST_SLEEP_STACK);

    @ApiStatus.Internal
    public ForgeLayeredDraw(ResourceLocation name, List<ResourceLocation> layers) {
        this.name = name;
        this.expectedNames.addAll(layers);
    }

    public ForgeLayeredDraw(ResourceLocation name) {
        this.name = name;
    }

    @Deprecated
    public ForgeLayeredDraw add(LayeredDraw layeredDraw, BooleanSupplier booleanSupplier) {
        return this.add(this.getNextPreName(), layeredDraw, booleanSupplier);
    }

    public ForgeLayeredDraw add(ResourceLocation name, LayeredDraw layeredDraw, BooleanSupplier supplier) {
        if (this.isNameAvailable(name)) {
            this.subLayerStacks.put(name, Map.entry(layeredDraw, supplier));
            this.order.add(name);
        } else {
            this.nameTakenWarning(name);
        }
        return this;
    }

    @Deprecated
    public LayeredDraw add(LayeredDraw.Layer layer) {
        this.add(this.getNextPreName(), layer);
        return this;
    }

    public ForgeLayeredDraw add(ResourceLocation targetStack, ResourceLocation name, LayeredDraw.Layer layer) {
        this.locateStack(targetStack).ifPresentOrElse(stack -> stack.add(name, layer), () -> this.stackNotPresentWarning(targetStack));
        return this;
    }

    public ForgeLayeredDraw add(ResourceLocation name, LayeredDraw.Layer layer) {
        if (this.isNameAvailable(name)) {
            this.namedLayers.put(name, layer);
            this.order.add(name);
        } else {
            this.nameTakenWarning(name);
        }
        return this;
    }

    public ForgeLayeredDraw putAbove(ResourceLocation expectedStack, ResourceLocation target, ResourceLocation destination) {
        this.locateStack(expectedStack).ifPresentOrElse(stack -> stack.move(target, destination, LayerOffset.ABOVE), () -> this.stackNotPresentWarning(expectedStack));
        return this;
    }

    public ForgeLayeredDraw putBelow(ResourceLocation expectedStack, ResourceLocation target, ResourceLocation destination) {
        this.locateStack(expectedStack).ifPresentOrElse(stack -> stack.move(target, destination, LayerOffset.BELOW), () -> this.stackNotPresentWarning(expectedStack));
        return this;
    }

    public ForgeLayeredDraw move(ResourceLocation target, ResourceLocation destination, LayerOffset offset) {
        if (!this.order.contains(target)) {
            this.layerNotPresentWarning(target);
            return this;
        }
        int loc = this.order.indexOf(destination);
        if (loc == -1) {
            this.layerNotPresentWarning(destination);
            return this;
        }
        this.order.remove(target);
        this.order.add(loc + (offset == LayerOffset.ABOVE ? 1 : 0), target);
        return this;
    }

    public ForgeLayeredDraw addAbove(ResourceLocation expectedStack, ResourceLocation newLayer, ResourceLocation otherLayer, LayeredDraw.Layer layer) {
        this.locateStack(expectedStack).ifPresentOrElse(stack -> {
            if (!stack.isNameAvailable(otherLayer)) {
                stack.add(newLayer, layer).move(newLayer, otherLayer, LayerOffset.ABOVE);
            } else {
                this.layerNotPresentWarning(otherLayer);
            }
        }, () -> this.stackNotPresentWarning(expectedStack));
        return this;
    }

    public ForgeLayeredDraw addAbove(ResourceLocation newLayer, ResourceLocation otherLayer, LayeredDraw.Layer layer) {
        return this.addAbove(this.name, newLayer, otherLayer, layer);
    }

    public ForgeLayeredDraw addBelow(ResourceLocation expectedStack, ResourceLocation newLayer, ResourceLocation otherLayer, LayeredDraw.Layer layer) {
        this.locateStack(expectedStack).ifPresentOrElse(stack -> {
            if (!stack.isNameAvailable(otherLayer)) {
                stack.add(newLayer, layer).move(newLayer, otherLayer, LayerOffset.BELOW);
            } else {
                this.layerNotPresentWarning(otherLayer);
            }
        }, () -> this.stackNotPresentWarning(expectedStack));
        return this;
    }

    public ForgeLayeredDraw addBelow(ResourceLocation newLayer, ResourceLocation otherLayer, LayeredDraw.Layer layer) {
        return this.addBelow(this.name, newLayer, otherLayer, layer);
    }

    public ForgeLayeredDraw addWithCondition(ResourceLocation targetStack, ResourceLocation name, LayeredDraw.Layer layer, BooleanSupplier condition) {
        this.locateStack(targetStack).ifPresentOrElse(stack -> stack.addWithCondition(name, layer, condition), () -> this.stackNotPresentWarning(targetStack));
        return this;
    }

    public ForgeLayeredDraw addWithCondition(ResourceLocation name, LayeredDraw.Layer layer, BooleanSupplier condition) {
        this.add(name, layer).addConditionTo(name, condition);
        return this;
    }

    public ForgeLayeredDraw addConditionTo(ResourceLocation targetStack, ResourceLocation targetLayer, BooleanSupplier condition) {
        this.locateStack(targetStack).ifPresentOrElse(stack -> stack.addConditionTo(targetLayer, condition), () -> this.stackNotPresentWarning(targetStack));
        return this;
    }

    public ForgeLayeredDraw addConditionTo(ResourceLocation targetLayer, BooleanSupplier condition) {
        LayeredDraw.Layer result = this.namedLayers.computeIfPresent(targetLayer, (name, layer) -> (guiGraphics, deltaTracker) -> {
            if (condition.getAsBoolean()) {
                layer.render(guiGraphics, deltaTracker);
            }
        });
        if (result == null) {
            this.layerNotPresentWarning(targetLayer);
        }
        return this;
    }

    @ApiStatus.Internal
    public ForgeLayeredDraw resolveLayers() {
        if (!this.order.isEmpty()) {
            ForgeEventFactoryClient.onComputeLayerOrder(this);
        }
        if (this.namedLayers.size() + this.subLayerStacks.size() < this.order.size()) {
            LogUtils.getLogger().warn("Found {} unbound pre-defined layer names when resolving gui overlay order. This is not an error, but potentially indicates a mod directly modifying Gui instead of using this api.", (Object)(this.order.size() - this.namedLayers.size()));
        }
        this.resolveNested();
        this.order.clear();
        return this;
    }

    private void resolveNested() {
        for (ResourceLocation layerName : this.order) {
            if (this.subLayerStacks.containsKey(layerName)) {
                Map.Entry<LayeredDraw, BooleanSupplier> entry = this.subLayerStacks.get(layerName);
                LayeredDraw layeredDraw = entry.getKey();
                if (layeredDraw instanceof ForgeLayeredDraw) {
                    ForgeLayeredDraw resolveable = (ForgeLayeredDraw)layeredDraw;
                    resolveable.resolveNested();
                }
                super.add((gg, tr) -> {
                    if (((BooleanSupplier)entry.getValue()).getAsBoolean()) {
                        ((LayeredDraw)entry.getKey()).render(gg, tr);
                    }
                });
                continue;
            }
            super.add(this.namedLayers.get(layerName));
        }
    }

    public Optional<ForgeLayeredDraw> locateStack(ResourceLocation targetStack) {
        if (!this.name.equals((Object)targetStack)) {
            for (Map.Entry<LayeredDraw, BooleanSupplier> value : this.subLayerStacks.values()) {
                ForgeLayeredDraw searchable;
                Optional<ForgeLayeredDraw> res;
                LayeredDraw layeredDraw = value.getKey();
                if (!(layeredDraw instanceof ForgeLayeredDraw) || !(res = (searchable = (ForgeLayeredDraw)layeredDraw).locateStack(targetStack)).isPresent()) continue;
                return res;
            }
            return Optional.empty();
        }
        return Optional.of(this);
    }

    @Nullable
    public LayeredDraw getChild(ResourceLocation childName) {
        return this.locateStack(childName).orElse(null);
    }

    @Nullable
    public LayeredDraw.Layer getLayer(ResourceLocation layerName) {
        return this.namedLayers.get(layerName);
    }

    private ResourceLocation getNextPreName() {
        return this.expectedNames.isEmpty() ? ResourceLocation.fromNamespaceAndPath((String)"unknown", (String)("layer_" + unknown++)) : this.expectedNames.removeFirst();
    }

    public ResourceLocation getName() {
        return this.name;
    }

    private void stackNotPresentWarning(ResourceLocation stackName) {
        LogUtils.getLogger().warn("Target stack {} was not present anywhere. Is your ResourceLocation correct?", (Object)stackName);
    }

    private void layerNotPresentWarning(ResourceLocation layer) {
        LogUtils.getLogger().warn("Expected layer {} was not found in stack {}, no layer modifications have been made.", (Object)layer, (Object)this.name);
    }

    private void nameTakenWarning(ResourceLocation layer) {
        LogUtils.getLogger().warn("Name {} was already present in {} and cannot be re-used.", (Object)layer, (Object)this.name);
    }

    private boolean isNameAvailable(ResourceLocation name) {
        return !this.namedLayers.containsKey(name) && !this.subLayerStacks.containsKey(name);
    }

    public static enum LayerOffset {
        ABOVE,
        BELOW;

    }
}

