/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.ListBuilder;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapDecoder;
import com.mojang.serialization.MapEncoder;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.ConditionalAdvancement;
import net.minecraftforge.common.crafting.conditions.ConditionCodec;
import net.minecraftforge.common.crafting.conditions.ICondition;
import org.jetbrains.annotations.Nullable;

public class ConditionalRecipe {
    private static final MapCodec<Recipe<?>> CODEC = Codec.of((MapEncoder)new MapEncoder.Implementation<Recipe<?>>(){

        public <T> RecordBuilder<T> encode(Recipe<?> input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
            if (!(input instanceof Wrapper)) {
                new IllegalStateException("ConditionalRecipe.CODEC can only be used during data gen, how did you get here?");
            }
            Wrapper wrapper = (Wrapper)input;
            if (wrapper.main != null) {
                prefix.add("forge:condition", ICondition.CODEC.encodeStart(ops, (Object)wrapper.main));
            } else if (wrapper.recipes.size() == 1) {
                prefix.add("forge:condition", ICondition.CODEC.encodeStart(ops, (Object)wrapper.recipes.get(0).condition()));
            }
            ListBuilder recipes = ops.listBuilder();
            for (InnerRecipe recipe : wrapper.recipes) {
                RecordBuilder map = ops.mapBuilder();
                if (wrapper.main != null || wrapper.recipes.size() != 1) {
                    map.add("forge:condition", (Object)recipe.condition(), ICondition.CODEC);
                }
                map.add("recipe", recipe.recipe(), (Encoder)Recipe.CODEC);
                recipes.add(map.build(ops.emptyMap()));
            }
            prefix.add("recipes", recipes.build(ops.emptyList()));
            return prefix;
        }

        public <T> Stream<T> keys(DynamicOps<T> ops) {
            return Stream.of(ops.createString("forge:condition"), ops.createString("recipes"));
        }
    }, (MapDecoder)new MapDecoder.Implementation<Recipe<?>>(){

        public <T> DataResult<Recipe<?>> decode(DynamicOps<T> ops, MapLike<T> input) {
            ICondition.IContext context = ConditionCodec.getContext(ops);
            return ops.getStream(input.get("recipes")).flatMap(stream -> {
                Holder count = new Holder();
                count.value = -1;
                DataResult ret = stream.map(entry -> this.accept(context, ops, count, entry)).filter(entry -> entry != null).findFirst().orElse(null);
                if (ret != null) {
                    return ret;
                }
                return DataResult.error(() -> "No recipe passed conditions, if this is the case, you should have an outer condition.");
            });
        }

        private <T> DataResult<Recipe<?>> accept(ICondition.IContext context, DynamicOps<T> ops, Holder<Integer> count, T entry) {
            ICondition condition;
            DataResult parsed;
            count.value = (Integer)count.value + 1;
            MapLike map = ops.getMap(entry).result().orElse(null);
            if (map == null) {
                return DataResult.error(() -> "Entry " + String.valueOf(count.value) + " was not MapLike " + String.valueOf(entry.getClass()));
            }
            if (map.get("forge:condition") != null && (parsed = ICondition.SAFE_CODEC.parse(ops, map.get("forge:condition"))).result().isPresent() && !(condition = (ICondition)parsed.result().get()).test(context, ops)) {
                return null;
            }
            Object recipe = map.get("recipe");
            if (recipe == null) {
                return DataResult.error(() -> "Missing `recipe` entry " + String.valueOf(count.value));
            }
            DataResult ret = Recipe.CODEC.parse(ops, recipe);
            return ret;
        }

        public <T> Stream<T> keys(DynamicOps<T> ops) {
            return Stream.of(ops.createString("forge:condition"), ops.createString("recipes"));
        }
    });
    public static final RecipeSerializer<Recipe<?>> SERIALZIER = new RecipeSerializer<Recipe<?>>(){

        public MapCodec<Recipe<?>> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, Recipe<?>> streamCodec() {
            throw new UnsupportedOperationException("ConditionaRecipe.SERIALIZER does not support encoding to network");
        }
    };

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private List<InnerRecipe> recipes = new ArrayList<InnerRecipe>();
        private List<InnerAdvancement> advancements = new ArrayList<InnerAdvancement>();
        private RecipeOutput bouncer = new RecipeOutput(){

            public void accept(ResourceLocation id, Recipe<?> value, @Nullable AdvancementHolder advancement) {
                this.recipe(id, value, advancement);
            }

            public Advancement.Builder advancement() {
                return Advancement.Builder.recipeAdvancement().parent(RecipeBuilder.ROOT_RECIPE_ADVANCEMENT);
            }

            public void accept(ResourceLocation id, Recipe<?> recipe, ResourceLocation advancementId, JsonElement advancement) {
                AdvancementHolder holder = null;
                if (advancement != null) {
                    Advancement adv = (Advancement)Advancement.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)advancement).getOrThrow(JsonParseException::new);
                    holder = new AdvancementHolder(advancementId, adv);
                }
                this.accept(id, recipe, holder);
            }

            public HolderLookup.Provider registry() {
                return null;
            }
        };
        @Nullable
        private ICondition condition;
        @Nullable
        private ICondition mainCondition;
        @Nullable
        private ResourceLocation advancementId;

        public Builder mainCondition(ICondition value) {
            if (this.mainCondition != null) {
                throw new IllegalStateException("Attempted to overrride the main condition, only one is allowed to be set");
            }
            this.mainCondition = value;
            return this;
        }

        public Builder condition(ICondition value) {
            if (this.condition != null) {
                throw new IllegalStateException("Attempted to override a previous set condition before adding a recipe");
            }
            this.condition = value;
            return this;
        }

        public Builder recipe(Consumer<RecipeOutput> callable) {
            callable.accept(this.bouncer);
            return this;
        }

        public Builder recipe(ResourceLocation id, Recipe<?> recipe, @Nullable AdvancementHolder advancement) {
            if (this.condition == null) {
                throw new IllegalStateException("Can not add a recipe with no conditions.");
            }
            this.recipes.add(new InnerRecipe(this.condition, recipe));
            if (advancement != null) {
                this.advancements.add(new InnerAdvancement(this.condition, advancement, null));
            }
            this.condition = null;
            return this;
        }

        public Builder advancement(ResourceLocation id) {
            this.advancementId = id;
            return this;
        }

        public void save(RecipeOutput out, String namespace, String path) {
            this.save(out, new ResourceLocation(namespace, path));
        }

        public void save(RecipeOutput out, ResourceLocation id) {
            if (this.condition != null) {
                throw new IllegalStateException("Invalid ConditionalRecipe builder, Orphaned conditions");
            }
            if (this.recipes.isEmpty()) {
                throw new IllegalStateException("Invalid ConditionalRecipe builder, No recipes");
            }
            JsonObject advancement = null;
            if (!this.advancements.isEmpty()) {
                ConditionalAdvancement.Builder adv = ConditionalAdvancement.builder();
                for (InnerAdvancement data : this.advancements) {
                    adv.condition(data.condition());
                    if (data.json != null) {
                        adv.advancement(data.json());
                        continue;
                    }
                    adv.advancement(data.advancement());
                }
                if (this.advancementId == null) {
                    this.advancementId = id.withPrefix("recipes/");
                }
                advancement = adv.build(out.registry());
            } else {
                this.advancementId = null;
            }
            out.accept(id, (Recipe)new Wrapper(this.mainCondition, this.recipes), this.advancementId, advancement);
        }
    }

    private static class Holder<T> {
        private T value;

        private Holder() {
        }
    }

    private static class Wrapper
    implements Recipe<Container> {
        @Nullable
        private final ICondition main;
        private final List<InnerRecipe> recipes;

        public boolean matches(Container inv, Level level) {
            return false;
        }

        public ItemStack assemble(Container inv, HolderLookup.Provider reg) {
            return null;
        }

        public boolean canCraftInDimensions(int width, int height) {
            return false;
        }

        public ItemStack getResultItem(HolderLookup.Provider reg) {
            return null;
        }

        public RecipeSerializer<?> getSerializer() {
            return SERIALZIER;
        }

        public RecipeType<?> getType() {
            throw new UnsupportedOperationException();
        }

        private Wrapper(@Nullable ICondition main, List<InnerRecipe> recipes) {
            this.main = main;
            this.recipes = recipes;
        }
    }

    private record InnerAdvancement(ICondition condition, AdvancementHolder advancement, JsonObject json) {
    }

    private record InnerRecipe(ICondition condition, Recipe<?> recipe) {
    }
}

