/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.crafting.conditions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.registries.ForgeRegistries;

public record ItemExistsCondition(ResourceLocation item) implements ICondition
{
    public static final MapCodec<ItemExistsCondition> CODEC = RecordCodecBuilder.mapCodec(b -> b.group((App)ResourceLocation.CODEC.fieldOf("item").forGetter(ItemExistsCondition::item)).apply((Applicative)b, ItemExistsCondition::new));

    @Override
    public boolean test(ICondition.IContext context, DynamicOps<?> ops) {
        RegistryOps reg;
        Optional items;
        if (ops instanceof RegistryOps && (items = (reg = (RegistryOps)ops).getter(Registries.ITEM)).isPresent()) {
            ResourceKey key = ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)this.item);
            return ((HolderGetter)items.get()).get(key).isPresent();
        }
        return ForgeRegistries.ITEMS.containsKey(this.item);
    }

    @Override
    public String toString() {
        return "item_exists(\"" + String.valueOf(this.item) + "\")";
    }

    @Override
    public MapCodec<? extends ICondition> codec() {
        return CODEC;
    }
}

